/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.antlr.v4;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.antlr.parser.antlr4.ANTLRv4Lexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.languages.antlr.AntlrParser;
import org.netbeans.modules.languages.antlr.AntlrParserResult;
import org.netbeans.modules.languages.antlr.AntlrTokenSequence;
import org.netbeans.modules.languages.antlr.v4.Antlr4ParserResult;
import org.netbeans.modules.languages.antlr.v4.Bundle;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;

public class Antlr4CompletionProvider
implements CompletionProvider {
    private static final String ANTLR_ICON = "org/netbeans/modules/languages/antlr/resources/antlr.png";
    private static final String ICON_BASE = "org/netbeans/modules/csl/source/resources/icons/";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        return new AsyncCompletionTask((AsyncCompletionQuery)new AntlrCompletionQuery(Antlr4CompletionProvider.isCaseSensitive()), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static boolean isCaseSensitive() {
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        return prefs.getBoolean("completion-case-sensitive", false);
    }

    private static String getReferenceIcon(AntlrParserResult.ReferenceType rtype) {
        switch (rtype) {
            case CHANNEL: {
                return "org/netbeans/modules/csl/source/resources/icons/database.gif";
            }
            case FRAGMENT: {
                return "org/netbeans/modules/csl/source/resources/icons/constantPublic.png";
            }
            case MODE: {
                return "org/netbeans/modules/csl/source/resources/icons/class.png";
            }
            case RULE: {
                return "org/netbeans/modules/csl/source/resources/icons/rule.png";
            }
            case TOKEN: {
                return "org/netbeans/modules/csl/source/resources/icons/fieldPublic.png";
            }
        }
        return null;
    }

    private class AntlrCompletionQuery
    extends AsyncCompletionQuery {
        final boolean caseSensitive;

        public AntlrCompletionQuery(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            AbstractDocument adoc = (AbstractDocument)doc;
            try {
                AntlrTokenSequence tokens;
                FileObject fo = EditorDocumentUtils.getFileObject((Document)doc);
                if (fo == null) {
                    return;
                }
                AntlrParserResult<?> r = AntlrParser.getParserResult(fo);
                if (!(r instanceof Antlr4ParserResult)) {
                    return;
                }
                Antlr4ParserResult result = (Antlr4ParserResult)r;
                String prefix = "";
                adoc.readLock();
                try {
                    String text = doc.getText(0, doc.getLength());
                    tokens = new AntlrTokenSequence((TokenSource)new ANTLRv4Lexer((CharStream)CharStreams.fromString((String)text)));
                    adoc.readUnlock();
                }
                catch (BadLocationException ex) {
                    adoc.readUnlock();
                    resultSet.finish();
                    return;
                    catch (Throwable throwable) {
                        adoc.readUnlock();
                        throw throwable;
                    }
                }
                if (tokens.isEmpty()) return;
                boolean inRule = false;
                block16: while (tokens.hasNext() && tokens.getOffset() < caretOffset) {
                    Optional<Token> next = tokens.next();
                    switch (next.get().getType()) {
                        case 29: {
                            inRule = true;
                            break;
                        }
                        case 32: {
                            inRule = false;
                            continue block16;
                        }
                    }
                }
                tokens.seekTo(caretOffset);
                int tokenOffset = tokens.getOffset();
                if (!tokens.hasNext()) return;
                Token nt = tokens.next().get();
                if (caretOffset > tokenOffset) {
                    if (nt.getChannel() == 3) return;
                    if (nt.getType() == 60) {
                        return;
                    }
                    if (nt.getChannel() == 0) {
                        prefix = nt.getText().substring(0, caretOffset - tokenOffset);
                    }
                } else if (nt.getType() == 60) {
                    return;
                }
                tokens.previous();
                if (inRule) {
                    this.lookInRule(result, tokens, caretOffset, prefix, resultSet);
                    return;
                }
                this.lookNonRule(result, tokens, caretOffset, prefix, resultSet);
                return;
            }
            finally {
                resultSet.finish();
            }
        }

        private void lookInRule(Antlr4ParserResult result, AntlrTokenSequence tokens, int caretOffset, String prefix, CompletionResultSet resultSet) {
            AntlrParserResult.GrammarType grammarType = result != null ? result.getGrammarType() : AntlrParserResult.GrammarType.UNKNOWN;
            Optional<Token> opt = tokens.previous(AntlrTokenSequence.DEFAULT_CHANNEL);
            Token pt = opt.get();
            if ((pt.getType() == 2 || pt.getType() == 1) && caretOffset == pt.getStopIndex() + 1) {
                prefix = pt.getText();
                opt = tokens.previous(AntlrTokenSequence.DEFAULT_CHANNEL);
            }
            pt = opt.get();
            switch (pt.getType()) {
                case 37: {
                    this.addTokens(prefix, caretOffset, resultSet, "skip", "more", "type", "channel", "mode", "pushMode", "popMode");
                    return;
                }
                case 33: {
                    Optional<Token> lexerCommand = tokens.previous(AntlrTokenSequence.DEFAULT_CHANNEL);
                    if (!lexerCommand.isPresent()) break;
                    switch (lexerCommand.get().getText()) {
                        case "channel": {
                            this.addReferences(result, prefix, caretOffset, resultSet, EnumSet.of(AntlrParserResult.ReferenceType.CHANNEL));
                            return;
                        }
                        case "mode": 
                        case "pushMode": {
                            this.addReferences(result, prefix, caretOffset, resultSet, EnumSet.of(AntlrParserResult.ReferenceType.MODE));
                            return;
                        }
                        case "type": {
                            this.addReferences(result, prefix, caretOffset, resultSet, EnumSet.of(AntlrParserResult.ReferenceType.TOKEN));
                            return;
                        }
                    }
                }
            }
            EnumSet<AntlrParserResult.ReferenceType> rtypes = EnumSet.noneOf(AntlrParserResult.ReferenceType.class);
            tokens.seekTo(caretOffset);
            tokens.previous(29);
            Optional<Token> ref = tokens.previous(AntlrTokenSequence.DEFAULT_CHANNEL);
            if (ref.isPresent() && (ref.get().getType() == 2 || ref.get().getType() == 1)) {
                if (ref.get().getType() == 1) {
                    rtypes.add(AntlrParserResult.ReferenceType.FRAGMENT);
                } else {
                    rtypes.add(AntlrParserResult.ReferenceType.TOKEN);
                    rtypes.add(AntlrParserResult.ReferenceType.RULE);
                    if (grammarType == AntlrParserResult.GrammarType.MIXED) {
                        rtypes.add(AntlrParserResult.ReferenceType.FRAGMENT);
                    }
                }
            } else {
                if (grammarType == AntlrParserResult.GrammarType.LEXER || grammarType == AntlrParserResult.GrammarType.MIXED) {
                    rtypes.add(AntlrParserResult.ReferenceType.FRAGMENT);
                }
                if (grammarType == AntlrParserResult.GrammarType.PARSER || grammarType == AntlrParserResult.GrammarType.MIXED) {
                    rtypes.add(AntlrParserResult.ReferenceType.TOKEN);
                    rtypes.add(AntlrParserResult.ReferenceType.RULE);
                }
            }
            this.addReferences(result, prefix, caretOffset, resultSet, rtypes);
        }

        private void lookNonRule(Antlr4ParserResult result, AntlrTokenSequence tokens, int caretOffset, String prefix, CompletionResultSet resultSet) {
            AntlrParserResult.GrammarType grammarType = result != null ? result.getGrammarType() : AntlrParserResult.GrammarType.UNKNOWN;
            Optional<Token> opt = tokens.previous(AntlrTokenSequence.DEFAULT_CHANNEL);
            if (!opt.isPresent()) {
                Optional<Token> t = tokens.next(AntlrTokenSequence.DEFAULT_CHANNEL);
                if (t.isPresent() && t.get().getType() != 17) {
                    this.addTokens(prefix, caretOffset, resultSet, "lexer");
                }
                if (t.isPresent() && t.get().getType() != 18) {
                    this.addTokens(prefix, caretOffset, resultSet, "parser");
                }
                if (t.isPresent() && t.get().getType() != 17 && t.get().getType() != 19) {
                    this.addTokens(prefix, caretOffset, resultSet, "grammar");
                }
                return;
            }
            Token pt = opt.get();
            if ((pt.getType() == 2 || pt.getType() == 1) && caretOffset == pt.getStopIndex() + 1) {
                prefix = pt.getText();
                opt = tokens.previous(AntlrTokenSequence.DEFAULT_CHANNEL);
            }
            if (!opt.isPresent()) {
                this.addTokens(prefix, caretOffset, resultSet, "lexer", "parser", "grammar");
                return;
            }
            pt = opt.get();
            switch (pt.getType()) {
                case 17: 
                case 18: {
                    Optional<Token> t = tokens.next(AntlrTokenSequence.DEFAULT_CHANNEL);
                    if (!t.isPresent() || t.get().getType() != 19) {
                        this.addTokens(prefix, caretOffset, resultSet, "grammar");
                    }
                    return;
                }
                case 16: 
                case 32: {
                    if (grammarType != AntlrParserResult.GrammarType.PARSER) {
                        this.addTokens(prefix, caretOffset, resultSet, "mode", "fragment");
                    }
                    this.addUnknownReferences(result, prefix, caretOffset, resultSet);
                    return;
                }
            }
        }

        public void addTokens(String prefix, int caretOffset, CompletionResultSet resultSet, String ... tokens) {
            String uprefix = this.caseSensitive ? prefix : prefix.toUpperCase();
            for (String token : tokens) {
                String utoken;
                String string = utoken = this.caseSensitive ? token : token.toUpperCase();
                if (!utoken.startsWith(uprefix)) continue;
                CompletionItem item = CompletionUtilities.newCompletionItemBuilder((String)token).iconResource(Antlr4CompletionProvider.ANTLR_ICON).startOffset(caretOffset - prefix.length()).leftHtmlText(token).build();
                resultSet.addItem(item);
            }
        }

        public void addUnknownReferences(Antlr4ParserResult result, String prefix, int caretOffset, CompletionResultSet resultSet) {
            int startOffset = caretOffset - prefix.length();
            String mprefix = this.caseSensitive ? prefix : prefix.toUpperCase();
            for (String unknownReference : result.unknownReferences) {
                String mref = this.caseSensitive ? unknownReference : unknownReference.toUpperCase();
                if (!mref.startsWith(mprefix)) continue;
                boolean ruleRef = Character.isLowerCase(unknownReference.codePointAt(0));
                CompletionItem item = null;
                if (ruleRef && (result.getGrammarType() == AntlrParserResult.GrammarType.PARSER || result.getGrammarType() == AntlrParserResult.GrammarType.MIXED)) {
                    item = CompletionUtilities.newCompletionItemBuilder((String)unknownReference).iconResource(Antlr4CompletionProvider.getReferenceIcon(AntlrParserResult.ReferenceType.RULE)).startOffset(startOffset).leftHtmlText(unknownReference).rightHtmlText(Bundle.newRule()).sortText((CharSequence)mref).build();
                }
                if (!(ruleRef || result.getGrammarType() != AntlrParserResult.GrammarType.LEXER && result.getGrammarType() != AntlrParserResult.GrammarType.MIXED)) {
                    item = CompletionUtilities.newCompletionItemBuilder((String)unknownReference).iconResource(Antlr4CompletionProvider.getReferenceIcon(AntlrParserResult.ReferenceType.TOKEN)).startOffset(startOffset).leftHtmlText(unknownReference).rightHtmlText(Bundle.newRule()).sortText((CharSequence)mref).build();
                }
                if (item == null) continue;
                resultSet.addItem(item);
            }
        }

        private void addReferences(Antlr4ParserResult result, String prefix, int caretOffset, CompletionResultSet resultSet, Set<AntlrParserResult.ReferenceType> rtypes) {
            HashMap matching = new HashMap();
            String mprefix = this.caseSensitive ? prefix : prefix.toUpperCase();
            result.allImports().values().forEach(r -> {
                Map refs = r.references;
                for (AntlrParserResult.Reference ref : refs.values()) {
                    String mref = this.caseSensitive ? ref.name : ref.name.toUpperCase();
                    boolean match = mref.startsWith(mprefix);
                    if (!match || matching.containsKey(ref.name) || !rtypes.contains((Object)ref.type)) continue;
                    matching.put(ref.name, ref);
                }
            });
            int startOffset = caretOffset - prefix.length();
            for (AntlrParserResult.Reference ref : matching.values()) {
                CompletionItem item = CompletionUtilities.newCompletionItemBuilder((String)ref.name).iconResource(Antlr4CompletionProvider.getReferenceIcon(ref.type)).startOffset(startOffset).leftHtmlText(ref.name).sortText((CharSequence)(this.caseSensitive ? ref.name : ref.name.toUpperCase())).build();
                resultSet.addItem(item);
            }
        }
    }
}

