/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.ui.customizer;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferences;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferencesValidator;
import org.netbeans.modules.javascript.karma.ui.customizer.Bundle;
import org.netbeans.modules.javascript.karma.util.KarmaUtils;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CustomizerKarma
extends JPanel {
    private final Project project;
    private final BrowserUISupport.BrowserComboBoxModel browserModel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile String karma;
    private volatile String config;
    private volatile boolean autowatch;
    private volatile boolean failOnError;
    private volatile boolean debug;
    private volatile String selectedBrowserId;
    private ValidationResult validationResult;
    private JCheckBox autowatchCheckBox;
    private JButton configBrowseButton;
    private JLabel configLabel;
    private JButton configSearchButton;
    private JTextField configTextField;
    private JLabel coverageConfigLabel;
    private JLabel coverageDebugLabel;
    private JLabel coverageInfoLabel;
    private JLabel coverageIstanbulInfoLabel;
    private JLabel coverageLabel;
    private JLabel coverageLearnMoreLabel;
    private JComboBox<WebBrowser> debugBrowserIdComboBox;
    private JLabel debugBrowserIdLabel;
    private JCheckBox debugCheckBox;
    private JLabel debugLabel;
    private JCheckBox failOnErrorCheckBox;

    public CustomizerKarma(Project project) {
        assert (EventQueue.isDispatchThread());
        assert (project != null);
        this.project = project;
        this.browserModel = BrowserUISupport.createBrowserModel((String)KarmaPreferences.getDebugBrowserId(project), KarmaUtils.getDebugBrowsers());
        this.initComponents();
        this.init();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getKarma() {
        return this.karma;
    }

    public String getConfig() {
        return this.config;
    }

    public boolean isAutowatch() {
        return this.autowatch;
    }

    public boolean isFailOnBrowserError() {
        return this.failOnError;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getSelectedBrowserId() {
        return this.selectedBrowserId;
    }

    public String getWarningMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator iterator = this.validationResult.getWarnings().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            return message.getMessage();
        }
        return null;
    }

    public String getErrorMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator iterator = this.validationResult.getErrors().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            return message.getMessage();
        }
        return null;
    }

    private void init() {
        assert (EventQueue.isDispatchThread());
        this.configTextField.setText(KarmaPreferences.getConfig(this.project));
        this.autowatchCheckBox.setSelected(KarmaPreferences.isAutowatch(this.project));
        this.failOnErrorCheckBox.setSelected(KarmaPreferences.isFailOnBrowserError(this.project));
        this.debugCheckBox.setSelected(KarmaPreferences.isDebug(this.project));
        this.debugBrowserIdComboBox.setModel((ComboBoxModel<WebBrowser>)this.browserModel);
        this.debugBrowserIdComboBox.setRenderer(BrowserUISupport.createBrowserRenderer());
        this.enableDebugBrowserComboBox(this.debugCheckBox.isSelected());
        this.addListeners();
        this.validateData();
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        DefaultActionListener defaultActionListener = new DefaultActionListener();
        this.configTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.autowatchCheckBox.addItemListener(defaultItemListener);
        this.failOnErrorCheckBox.addItemListener(defaultItemListener);
        this.debugCheckBox.addItemListener(new DebugItemListener());
        this.debugBrowserIdComboBox.addActionListener(defaultActionListener);
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        this.config = this.configTextField.getText();
        this.debug = this.debugCheckBox.isSelected();
        this.autowatch = this.autowatchCheckBox.isSelected();
        this.failOnError = this.failOnErrorCheckBox.isSelected();
        this.selectedBrowserId = this.browserModel.getSelectedBrowserId();
        this.validationResult = new KarmaPreferencesValidator().validateConfig(this.config).validateDebug(this.debug, this.selectedBrowserId).getResult();
        this.changeSupport.fireChange();
    }

    void enableDebugBrowserComboBox(boolean enabled) {
        this.debugBrowserIdComboBox.setEnabled(enabled);
    }

    private File getProjectDirectory() {
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    private void initComponents() {
        this.configLabel = new JLabel();
        this.configTextField = new JTextField();
        this.configBrowseButton = new JButton();
        this.configSearchButton = new JButton();
        this.autowatchCheckBox = new JCheckBox();
        this.failOnErrorCheckBox = new JCheckBox();
        this.debugLabel = new JLabel();
        this.debugCheckBox = new JCheckBox();
        this.debugBrowserIdLabel = new JLabel();
        this.debugBrowserIdComboBox = new JComboBox();
        this.coverageLabel = new JLabel();
        this.coverageInfoLabel = new JLabel();
        this.coverageLearnMoreLabel = new JLabel();
        this.coverageIstanbulInfoLabel = new JLabel();
        this.coverageConfigLabel = new JLabel();
        this.coverageDebugLabel = new JLabel();
        this.configLabel.setLabelFor(this.configTextField);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.configLabel.text"));
        this.configTextField.setColumns(30);
        Mnemonics.setLocalizedText((AbstractButton)this.configBrowseButton, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.configBrowseButton.text"));
        this.configBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerKarma.this.configBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configSearchButton, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.configSearchButton.text"));
        this.configSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerKarma.this.configSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.autowatchCheckBox, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.autowatchCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.failOnErrorCheckBox, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.failOnErrorCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.debugLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.debugLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckBox, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.debugCheckBox.text"));
        this.debugBrowserIdLabel.setLabelFor(this.debugBrowserIdComboBox);
        Mnemonics.setLocalizedText((JLabel)this.debugBrowserIdLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.debugBrowserIdLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.coverageLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.coverageLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.coverageInfoLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.coverageInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.coverageLearnMoreLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.coverageLearnMoreLabel.text"));
        this.coverageLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CustomizerKarma.this.coverageLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CustomizerKarma.this.coverageLearnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.coverageIstanbulInfoLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.coverageIstanbulInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.coverageConfigLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.coverageConfigLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.coverageDebugLabel, (String)NbBundle.getMessage(CustomizerKarma.class, (String)"CustomizerKarma.coverageDebugLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.configLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configSearchButton)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.coverageInfoLabel).addGap(18, 18, 18).addComponent(this.coverageLearnMoreLabel, -2, -1, -2)).addComponent(this.coverageIstanbulInfoLabel).addComponent(this.coverageConfigLabel, -2, -1, -2).addComponent(this.coverageDebugLabel).addGroup(layout.createSequentialGroup().addComponent(this.debugBrowserIdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugBrowserIdComboBox, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autowatchCheckBox).addComponent(this.coverageLabel).addComponent(this.debugLabel).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.debugCheckBox)).addComponent(this.failOnErrorCheckBox)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configLabel).addComponent(this.configTextField, -2, -1, -2).addComponent(this.configBrowseButton).addComponent(this.configSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autowatchCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.failOnErrorCheckBox).addGap(18, 18, 18).addComponent(this.debugLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debugBrowserIdLabel).addComponent(this.debugBrowserIdComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.coverageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.coverageInfoLabel).addComponent(this.coverageLearnMoreLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coverageIstanbulInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coverageConfigLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coverageDebugLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void configBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(CustomizerKarma.class).setTitle(Bundle.CustomizerKarma_chooser_config()).setFilesOnly(true).setDefaultWorkingDirectory(KarmaUtils.getKarmaConfigDir(this.project)).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.configTextField.setText(file.getAbsolutePath());
        }
    }

    private void configSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File karmaConfig = KarmaUtils.findKarmaConfig(KarmaUtils.getKarmaConfigDir(this.project));
        if (karmaConfig != null) {
            this.configTextField.setText(karmaConfig.getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.CustomizerKarma_config_none());
    }

    private void coverageLearnMoreLabelMouseEntered(MouseEvent evt) {
        assert (EventQueue.isDispatchThread());
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void coverageLearnMoreLabelMousePressed(MouseEvent evt) {
        assert (EventQueue.isDispatchThread());
        try {
            URL url = new URL("https://github.com/karma-runner/karma-coverage");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            CustomizerKarma.this.validateData();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CustomizerKarma.this.validateData();
        }
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerKarma.this.validateData();
        }
    }

    private final class DebugItemListener
    implements ItemListener {
        private DebugItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CustomizerKarma.this.enableDebugBrowserComboBox(e.getStateChange() == 1);
            CustomizerKarma.this.validateData();
        }
    }
}

