/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.lib.chrome_devtools_protocol.debugger.GetScriptSourceRequest;
import org.netbeans.modules.javascript.cdtdebug.Bundle;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript2.debug.sources.SourceContent;
import org.netbeans.modules.javascript2.debug.sources.SourceFilesCache;
import org.netbeans.modules.web.common.sourcemap.SourceMapsScanner;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class ScriptsHandler {
    private static final Logger LOG = Logger.getLogger(ScriptsHandler.class.getName());
    private static final boolean USE_SOURCE_MAPS = Boolean.parseBoolean(System.getProperty("javascript.debugger.useSourceMaps", "true"));
    private final Map<String, CDTScript> scriptsById = new HashMap<String, CDTScript>();
    private final Map<URL, CDTScript> scriptsByURL = new HashMap<URL, CDTScript>();
    private final SourceMapsTranslator smt;
    private final String remotePathPrefix;
    private final boolean doPathTranslation;
    private final int numPrefixes;
    private final String[] localPathPrefixes;
    private final String[] serverPathPrefixes;
    private final char localPathSeparator;
    private final char serverPathSeparator;
    @NullAllowed
    private final FileObject[] localRoots;
    @NullAllowed
    private final FileObject[] localPathExclusionFilters;
    private final CDTDebugger dbg;

    ScriptsHandler(@NullAllowed List<String> localPaths, @NullAllowed List<String> serverPaths, Collection<String> localPathExclusionFilters, @NullAllowed CDTDebugger dbg) {
        FileObject localRoot;
        int i;
        this.remotePathPrefix = dbg != null ? dbg.getWebSocketDebuggerUrl().getHost() + "_" + dbg.getWebSocketDebuggerUrl().getPort() + "/" : "";
        if (localPaths != null && !localPaths.isEmpty() && serverPaths != null && !serverPaths.isEmpty()) {
            int n;
            this.doPathTranslation = true;
            this.numPrefixes = n = localPaths.size();
            this.localPathPrefixes = new String[n];
            this.serverPathPrefixes = new String[n];
            for (i = 0; i < n; ++i) {
                this.localPathPrefixes[i] = ScriptsHandler.stripSeparator(localPaths.get(i));
            }
            this.localPathSeparator = ScriptsHandler.findSeparator(localPaths.get(0));
            for (i = 0; i < n; ++i) {
                this.serverPathPrefixes[i] = ScriptsHandler.stripSeparator(serverPaths.get(i));
            }
            this.serverPathSeparator = ScriptsHandler.findSeparator(serverPaths.get(0));
        } else {
            this.doPathTranslation = false;
            this.localPathPrefixes = null;
            this.serverPathPrefixes = null;
            this.localPathSeparator = '\u0000';
            this.serverPathSeparator = '\u0000';
            this.numPrefixes = 0;
        }
        if (localPaths != null && !localPaths.isEmpty()) {
            FileObject[] lroots = new FileObject[localPaths.size()];
            i = 0;
            for (String localPath : localPaths) {
                localRoot = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(localPath)));
                if (localRoot == null) continue;
                lroots[i++] = localRoot;
            }
            if (i < localPaths.size()) {
                lroots = Arrays.copyOf(lroots, i);
            }
            this.localRoots = lroots;
            this.smt = USE_SOURCE_MAPS ? SourceMapsScanner.getInstance().scan(this.localRoots) : null;
        } else {
            this.localRoots = null;
            this.smt = USE_SOURCE_MAPS ? SourceMapsTranslator.create() : null;
        }
        if (!localPathExclusionFilters.isEmpty()) {
            FileObject[] lpefs = new FileObject[localPathExclusionFilters.size()];
            i = 0;
            for (String lpef : localPathExclusionFilters) {
                localRoot = FileUtil.toFileObject((File)new File(lpef));
                if (localRoot != null) {
                    lpefs[i++] = localRoot;
                    continue;
                }
                lpefs = Arrays.copyOf(lpefs, lpefs.length - 1);
            }
            this.localPathExclusionFilters = lpefs.length > 0 ? lpefs : null;
        } else {
            this.localPathExclusionFilters = null;
        }
        LOG.log(Level.FINE, "ScriptsHandler: doPathTranslation = {0}, localPathPrefixes = {1}, separator = {2}, serverPathPrefixes = {3}, separator = {4}, localRoots = {5}, localPathExclusionFilters = {6}.", new Object[]{this.doPathTranslation, Arrays.toString(this.localPathPrefixes), Character.valueOf(this.localPathSeparator), Arrays.toString(this.serverPathPrefixes), Character.valueOf(this.serverPathSeparator), Arrays.toString(this.localRoots), Arrays.toString(this.localPathExclusionFilters)});
        this.dbg = dbg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(CDTScript script) {
        Map<String, CDTScript> map = this.scriptsById;
        synchronized (map) {
            this.scriptsById.put(script.getScriptId(), script);
        }
    }

    @CheckForNull
    public SourceMapsTranslator getSourceMapsTranslator() {
        return this.smt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public CDTScript getScript(String id) {
        Map<String, CDTScript> map = this.scriptsById;
        synchronized (map) {
            return this.scriptsById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<CDTScript> getScripts() {
        Map<String, CDTScript> map = this.scriptsById;
        synchronized (map) {
            return new ArrayList<CDTScript>(this.scriptsById.values());
        }
    }

    public boolean containsLocalFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        if ("js-scripts".equals(fo.toURL().getProtocol())) {
            return true;
        }
        if (this.localPathExclusionFilters != null) {
            for (FileObject lpef : this.localPathExclusionFilters) {
                if (!FileUtil.isParentOf((FileObject)lpef, (FileObject)fo)) continue;
                return false;
            }
        }
        if (this.localRoots == null) {
            return true;
        }
        for (FileObject localRoot : this.localRoots) {
            if (!FileUtil.isParentOf((FileObject)localRoot, (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRemoteFile(URL url) {
        int index;
        String path;
        if (!"js-scripts".equals(url.getProtocol())) {
            return false;
        }
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException usex) {
            return false;
        }
        int l = path.length();
        for (index = 0; index < l && path.charAt(index) == '/'; ++index) {
        }
        int begin = path.indexOf(47, index);
        if (begin > 0) {
            return path.regionMatches(begin + 1, this.remotePathPrefix, 0, this.remotePathPrefix.length());
        }
        return false;
    }

    @CheckForNull
    public FileObject getFile(String scriptId) {
        CDTScript script = this.getScript(scriptId);
        if (script == null) {
            return null;
        }
        return this.getFile(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(@NonNull CDTScript script) {
        FileObject fo;
        Object name = script.getUrl().getPath();
        if (name == null) {
            return null;
        }
        File localFile = null;
        if (this.doPathTranslation) {
            try {
                String lp = this.getLocalPath((String)name);
                localFile = new File(lp);
            }
            catch (OutOfScope lp) {}
        } else {
            File f = new File((String)name);
            if (f.isAbsolute()) {
                localFile = f;
            }
        }
        if (localFile != null && (fo = FileUtil.toFileObject(localFile)) != null) {
            Map<URL, CDTScript> map = this.scriptsByURL;
            synchronized (map) {
                this.scriptsByURL.put(fo.toURL(), script);
            }
            return fo;
        }
        if (name == null) {
            name = "unknown.js";
        }
        name = this.remotePathPrefix + (String)name;
        URL sourceURL = SourceFilesCache.getDefault().getSourceFile((String)name, script.getHash(), (SourceContent)new ScriptContentLoader(script, this.dbg));
        Map<URL, CDTScript> map = this.scriptsByURL;
        synchronized (map) {
            this.scriptsByURL.put(sourceURL, script);
        }
        return URLMapper.findFileObject((URL)sourceURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public CDTScript findScript(@NonNull URL scriptURL) {
        Map<URL, CDTScript> map = this.scriptsByURL;
        synchronized (map) {
            return this.scriptsByURL.get(scriptURL);
        }
    }

    @CheckForNull
    public String getServerPath(@NonNull FileObject fo) {
        String serverPath;
        File file = FileUtil.toFile((FileObject)fo);
        if (file != null) {
            String localPath = file.getAbsolutePath();
            try {
                serverPath = this.getServerPath(localPath);
            }
            catch (OutOfScope oos) {
                serverPath = null;
            }
        } else {
            String path;
            int begin;
            URL url = fo.toURL();
            CDTScript script = this.findScript(url);
            serverPath = script != null ? script.getUrl().getPath() : ("js-scripts".equals(url.getProtocol()) ? ((begin = (path = fo.getPath()).indexOf(47)) > 0 ? ((path = path.substring(begin + 1)).startsWith(this.remotePathPrefix) ? path.substring(this.remotePathPrefix.length()) : null) : null) : null);
        }
        return serverPath;
    }

    @CheckForNull
    public String getServerPath(@NonNull URL url) {
        int index;
        String path;
        if (!"js-scripts".equals(url.getProtocol())) {
            return null;
        }
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException usex) {
            return null;
        }
        int l = path.length();
        for (index = 0; index < l && path.charAt(index) == '/'; ++index) {
        }
        int begin = path.indexOf(47, index);
        if (begin > 0) {
            if (path.regionMatches(begin + 1, this.remotePathPrefix, 0, this.remotePathPrefix.length())) {
                path = path.substring(begin + 1 + this.remotePathPrefix.length());
                return path;
            }
            return null;
        }
        return null;
    }

    public String getLocalPath(@NonNull String serverPath) throws OutOfScope {
        if (!this.doPathTranslation) {
            return serverPath;
        }
        for (int i = 0; i < this.numPrefixes; ++i) {
            if (!ScriptsHandler.isChildOf(this.serverPathPrefixes[i], serverPath)) continue;
            return ScriptsHandler.translate(serverPath, this.serverPathPrefixes[i], this.serverPathSeparator, this.localPathPrefixes[i], this.localPathSeparator);
        }
        throw new OutOfScope(serverPath, Arrays.toString(this.serverPathPrefixes));
    }

    public String getServerPath(@NonNull String localPath) throws OutOfScope {
        if (!this.doPathTranslation) {
            return localPath;
        }
        for (int i = 0; i < this.numPrefixes; ++i) {
            if (!ScriptsHandler.isChildOf(this.localPathPrefixes[i], localPath)) continue;
            return ScriptsHandler.translate(localPath, this.localPathPrefixes[i], this.localPathSeparator, this.serverPathPrefixes[i], this.serverPathSeparator);
        }
        throw new OutOfScope(localPath, Arrays.toString(this.localPathPrefixes));
    }

    public File[] getLocalRoots() {
        if (this.localRoots == null) {
            return new File[0];
        }
        int l = this.localRoots.length;
        File[] roots = new File[l];
        for (int i = 0; i < l; ++i) {
            roots[i] = FileUtil.toFile((FileObject)this.localRoots[i]);
        }
        return roots;
    }

    private static boolean isChildOf(String parent, String child) {
        if (!child.startsWith(parent)) {
            return false;
        }
        int l = parent.length();
        return ScriptsHandler.isRootPath(parent) || child.length() <= l || ScriptsHandler.isSeparator(child.charAt(l));
    }

    private static String translate(String path, String pathPrefix, char pathSeparator, String otherPathPrefix, char otherPathSeparator) throws OutOfScope {
        int l;
        if (!path.startsWith(pathPrefix)) {
            throw new OutOfScope(path, pathPrefix);
        }
        if (!ScriptsHandler.isRootPath(pathPrefix) && path.length() > l && !ScriptsHandler.isSeparator(path.charAt(l))) {
            throw new OutOfScope(path, pathPrefix);
        }
        for (l = pathPrefix.length(); path.length() > l && ScriptsHandler.isSeparator(path.charAt(l)); ++l) {
        }
        String otherPath = path.substring(l);
        if (pathSeparator != otherPathSeparator) {
            otherPath = otherPath.replace(pathSeparator, otherPathSeparator);
        }
        if (otherPath.isEmpty()) {
            return otherPathPrefix;
        }
        if (ScriptsHandler.isRootPath(otherPathPrefix)) {
            return otherPathPrefix + otherPath;
        }
        return otherPathPrefix + otherPathSeparator + otherPath;
    }

    private static char findSeparator(String path) {
        if (path.indexOf(47) >= 0) {
            return '/';
        }
        if (path.indexOf(92) >= 0) {
            return '\\';
        }
        return '/';
    }

    private static boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    private static boolean isRootPath(String path) {
        if ("/".equals(path)) {
            return true;
        }
        return path.length() == 4 && path.endsWith(":\\\\");
    }

    private static String stripSeparator(String path) {
        if (ScriptsHandler.isRootPath(path)) {
            return path;
        }
        while (path.length() > 1 && (path.endsWith("/") || path.endsWith("\\"))) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final class OutOfScope
    extends Exception {
        private OutOfScope(String path, String scope) {
            super(path);
        }
    }

    private static final class ScriptContentLoader
    implements SourceContent {
        private final CDTScript script;
        private final CDTDebugger dbg;
        private String content;
        private final Object contentLock = new Object();
        private String contentLoadError;

        public ScriptContentLoader(CDTScript script, CDTDebugger dbg) {
            this.script = script;
            this.dbg = dbg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContent() throws IOException {
            if (this.content != null) {
                return this.content;
            }
            GetScriptSourceRequest gssr = new GetScriptSourceRequest();
            gssr.setScriptId(this.script.getScriptId());
            this.dbg.getConnection().getDebugger().getScriptSource(gssr).handle((res, thr) -> {
                Object object = this.contentLock;
                synchronized (object) {
                    if (thr != null) {
                        this.contentLoadError = Bundle.ERR_ScriptFailedToLoad();
                    } else if (res == null || res.getScriptSource() == null) {
                        this.contentLoadError = Bundle.ERR_ScriptHasNoSource();
                    } else {
                        this.content = res.getScriptSource();
                    }
                    this.contentLock.notifyAll();
                }
                return null;
            });
            Object object = this.contentLock;
            synchronized (object) {
                if (this.content == null && this.contentLoadError == null) {
                    try {
                        this.contentLock.wait();
                    }
                    catch (InterruptedException iex) {
                        throw new IOException(Bundle.ERR_Interrupted(), iex);
                    }
                }
                if (this.contentLoadError != null) {
                    throw new IOException(this.contentLoadError);
                }
                return this.content;
            }
        }

        public long getLength() {
            if (this.content != null) {
                return this.content.length();
            }
            return this.script.getLength();
        }
    }
}

