/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.javafx2.project.JFXGeneratedFilesHelper;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.JavaFXProjectWizardIterator;
import org.netbeans.modules.javafx2.project.fxml.ConfigureFXMLControllerPanelVisual;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JFXProjectGenerator {
    private static final String METRICS_LOGGER = "org.netbeans.ui.metrics.projects";
    private static final String JFX_METRICS_LOGGER = "org.netbeans.ui.metrics.jfx";
    private static final String PROJECT_TYPE = "org.netbeans.modules.javafx2.project.JFXProject";
    private static SpecificationVersion defaultSourceLevel;
    private static final Pattern INVALID_NAME;

    private JFXProjectGenerator() {
    }

    public static AntProjectHelper createProject(File dir, final String name, final String mainClass, String fxmlName, final String manifestFile, final String librariesDefinition, final String platformName, final String preloader, final JavaFXProjectWizardIterator.WizardType type) throws IOException {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"name", (Object)name);
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        final FileObject[] srcFolder = new FileObject[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = JFXProjectGenerator.createProject(dirFO, name, "src", "test", mainClass, manifestFile, librariesDefinition, platformName, preloader, type);
                Project p = ProjectManager.getDefault().findProject(dirFO);
                JFXProjectUtils.createJfxExtension(p, dirFO, type);
                ProjectManager.getDefault().saveProject(p);
                if (type != JavaFXProjectWizardIterator.WizardType.SWING) {
                    JFXGeneratedFilesHelper.generateBuildScriptFromStylesheet(h[0], "build.xml", JFXProjectGenerator.class.getResource("resources/build.xsl"));
                }
                final ReferenceHelper refHelper = JFXProjectGenerator.getReferenceHelper(p);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            JFXProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex.getException());
                }
                srcFolder[0] = dirFO.createFolder("src");
            }
        });
        if (srcFolder[0] != null) {
            JFXProjectGenerator.createFiles(mainClass, fxmlName, srcFolder[0], type);
        }
        return h[0];
    }

    private static ReferenceHelper getReferenceHelper(Project p) {
        try {
            return (ReferenceHelper)p.getClass().getMethod("getReferenceHelper", new Class[0]).invoke((Object)p, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    static AntProjectHelper createProject(File dir, final String name, final File[] sourceFolders, final File[] testFolders, final String manifestFile, final String librariesDefinition, final String buildXmlName, final String platformName, final String preloader, final JavaFXProjectWizardIterator.WizardType type) throws IOException {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"sourceFolders", (Object)sourceFolders);
        Parameters.notNull((CharSequence)"testFolders", (Object)testFolders);
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = JFXProjectGenerator.createProject(dirFO, name, null, null, null, manifestFile, librariesDefinition, platformName, preloader, type);
                final Project p = ProjectManager.getDefault().findProject(dirFO);
                final ReferenceHelper refHelper = JFXProjectGenerator.getReferenceHelper(p);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            Element root;
                            EditableProperties props;
                            int rootIndex;
                            String propName;
                            int i;
                            Element data = h[0].getPrimaryConfigurationData(true);
                            Document doc = data.getOwnerDocument();
                            NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
                            assert (nl.getLength() == 1);
                            Element sourceRoots = (Element)nl.item(0);
                            nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
                            assert (nl.getLength() == 1);
                            Element testRoots = (Element)nl.item(0);
                            for (i = 0; i < sourceFolders.length; ++i) {
                                if (i == 0) {
                                    propName = "src.dir";
                                } else {
                                    String name = sourceFolders[i].getName();
                                    propName = name + ".dir";
                                }
                                rootIndex = 1;
                                props = h[0].getProperties("nbproject/project.properties");
                                while (props.containsKey((Object)propName)) {
                                    propName = name + ++rootIndex + ".dir";
                                }
                                String srcReference = refHelper.createForeignFileReference(sourceFolders[i], "java");
                                root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                                root.setAttribute("id", propName);
                                sourceRoots.appendChild(root);
                                props = h[0].getProperties("nbproject/project.properties");
                                props.put(propName, srcReference);
                                h[0].putProperties("nbproject/project.properties", props);
                            }
                            for (i = 0; i < testFolders.length; ++i) {
                                if (!testFolders[i].exists()) {
                                    testFolders[i].mkdirs();
                                }
                                if (i == 0) {
                                    propName = "test.src.dir";
                                } else {
                                    String name = testFolders[i].getName();
                                    propName = "test." + name + ".dir";
                                }
                                rootIndex = 1;
                                props = h[0].getProperties("nbproject/project.properties");
                                while (props.containsKey((Object)propName)) {
                                    propName = "test." + name + ++rootIndex + ".dir";
                                }
                                String testReference = refHelper.createForeignFileReference(testFolders[i], "java");
                                root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                                root.setAttribute("id", propName);
                                testRoots.appendChild(root);
                                props = h[0].getProperties("nbproject/project.properties");
                                props.put(propName, testReference);
                                h[0].putProperties("nbproject/project.properties", props);
                            }
                            h[0].putPrimaryConfigurationData(data, true);
                            if (buildXmlName != null) {
                                EditableProperties props2 = h[0].getProperties("nbproject/project.properties");
                                props2.put("buildfile", buildXmlName);
                                h[0].putProperties("nbproject/project.properties", props2);
                            }
                            JFXProjectUtils.createJfxExtension(p, dirFO, type);
                            ProjectManager.getDefault().saveProject(p);
                            if (type != JavaFXProjectWizardIterator.WizardType.SWING) {
                                JFXGeneratedFilesHelper.generateBuildScriptFromStylesheet(h[0], "build.xml", JFXProjectGenerator.class.getResource("resources/build.xsl"));
                            }
                            JFXProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            ProjectUtils.getSources((Project)p).getSourceGroups("java");
                            return null;
                        }
                    });
                }
                catch (MutexException me) {
                    ErrorManager.getDefault().notify((Throwable)me);
                }
            }
        });
        return h[0];
    }

    static AntProjectHelper createPreloaderProject(File dir, final String name, final String librariesDefinition, final String platformName, final String preloaderClassName) throws IOException {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"name", (Object)name);
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        final FileObject[] srcFolder = new FileObject[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = JFXProjectGenerator.createProject(dirFO, name, "src", "test", preloaderClassName, "manifest.mf", librariesDefinition, platformName, null, JavaFXProjectWizardIterator.WizardType.PRELOADER);
                Project p = ProjectManager.getDefault().findProject(dirFO);
                JFXProjectUtils.createJfxExtension(p, dirFO, JavaFXProjectWizardIterator.WizardType.PRELOADER);
                ProjectManager.getDefault().saveProject(p);
                JFXGeneratedFilesHelper.generateBuildScriptFromStylesheet(h[0], "build.xml", JFXProjectGenerator.class.getResource("resources/build.xsl"));
                final ReferenceHelper refHelper = JFXProjectGenerator.getReferenceHelper(p);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            JFXProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex.getException());
                }
                srcFolder[0] = dirFO.createFolder("src");
            }
        });
        if (srcFolder[0] != null && preloaderClassName != null) {
            JFXProjectGenerator.createPreloaderClass(preloaderClassName, srcFolder[0]);
        }
        JavaFXProjectWizardIterator.createManifest(FileUtil.toFileObject((File)dir), true);
        return h[0];
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, String srcRoot, String testRoot, String mainClass, String manifestFile, String librariesDefinition, String platformName, String preloader, JavaFXProjectWizardIterator.WizardType type) throws IOException {
        Iterator<Map.Entry<String, String>> iterator;
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.java.j2seproject", (String)librariesDefinition);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        if (!JFXProjectGenerator.isDefaultPlatform(platformName)) {
            Element explicitPlatformEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "explicit-platform");
            explicitPlatformEl.setAttribute("explicit-source-supported", "true");
            data.appendChild(explicitPlatformEl);
        }
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "test.src.dir");
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        JFXProjectUtils.initializeJavaFXProperties(ep, type, platformName, mainClass, preloader);
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", "false");
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("annotation.processing.processor.options", "");
        ep.setProperty("dist.dir", "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/" + JFXProjectGenerator.validatePropertyValue(name) + ".jar");
        ep.setProperty("application.vendor", System.getProperty("user.name", "User Name"));
        ep.setProperty("application.title", name);
        ep.setProperty("javac.processorpath", new String[]{"${javac.classpath}"});
        ep.setProperty("javac.test.processorpath", new String[]{"${javac.test.classpath}"});
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", new String[]{"${dist.jar}:", "${javac.classpath}:", "${build.classes.dir}"});
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setComment("debug.classpath", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_debug.transport"), "#debug.transport=dt_socket"}, false);
        ep.setProperty("jar.compress", "false");
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        SpecificationVersion sourceLevel = JFXProjectGenerator.getPlatformSourceLevel(platformName);
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}"});
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("meta.inf.dir", "${src.dir}/META-INF");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", platformName);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (manifestFile != null) {
            ep.setProperty("manifest.file", manifestFile);
        }
        h.putProperties("nbproject/project.properties", ep);
        Map<String, String> browserInfo = JFXProjectUtils.getDefaultBrowserInfo();
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("endorsed.javafx.ant.classpath", ".");
        ep.setComment("endorsed.javafx.ant.classpath", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_endorsed_ant_classpath")}, false);
        if (browserInfo != null && !browserInfo.isEmpty() && (iterator = browserInfo.entrySet().iterator()).hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            ep.setProperty("javafx.run.inbrowser", entry.getKey());
            ep.setProperty("javafx.run.inbrowser.path", entry.getValue());
        }
        h.putProperties("nbproject/private/private.properties", ep);
        JFXProjectUtils.updateDefaultRunAsConfigFile(dirFO, JFXProjectProperties.RunAsType.ASWEBSTART, false);
        JFXProjectUtils.updateDefaultRunAsConfigFile(dirFO, JFXProjectProperties.RunAsType.INBROWSER, false);
        JFXProjectGenerator.logUsage(Action.CREATE);
        return h;
    }

    static void logUsage(@NonNull Action action) {
        assert (action != null);
        Logger logger = Logger.getLogger(METRICS_LOGGER);
        LogRecord logRecord = new LogRecord(Level.INFO, action.getGenericLogMessage());
        logRecord.setLoggerName(logger.getName());
        logRecord.setParameters(new Object[]{PROJECT_TYPE});
        logger.log(logRecord);
        logger = Logger.getLogger(JFX_METRICS_LOGGER);
        logRecord = new LogRecord(Level.INFO, action.getSpecificLogMessage());
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }

    private static boolean isDefaultPlatform(@NonNull String platformName) {
        Parameters.notNull((CharSequence)"platformName", (Object)platformName);
        return platformName.equals(JavaPlatform.getDefault().getProperties().get("platform.ant.name"));
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        if (rh.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (rh.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        if (rh.getProjectLibraryManager().getLibrary("CopyLibs") == null && LibraryManager.getDefault().getLibrary("CopyLibs") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("CopyLibs"));
        }
        if (rh.getProjectLibraryManager().getLibrary("JavaFX2Runtime") == null && LibraryManager.getDefault().getLibrary("JavaFX2Runtime") != null) {
            File mainPropertiesFile = h.resolveFile(h.getLibrariesLocation());
            JFXProjectGenerator.referenceLibrary(LibraryManager.getDefault().getLibrary("JavaFX2Runtime"), mainPropertiesFile.toURI().toURL(), true);
        }
    }

    private static String getJarFolder(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1 && index + 2 < u.length()) {
            return u.substring(index + 2);
        }
        return null;
    }

    private static URI appendJarFolder(URI u, String jarFolder) {
        try {
            if (u.isAbsolute()) {
                return new URI("jar:" + u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
            }
            return new URI(u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Library referenceLibrary(final Library lib, URL location, final boolean generateLibraryUniqueName) throws IOException {
        String[] volumes;
        File libBaseFolder = new File(URI.create(location.toExternalForm())).getParentFile();
        final HashMap content = new HashMap();
        for (String volume : volumes = LibrariesSupport.getLibraryTypeProvider((String)lib.getType()).getSupportedVolumeTypes()) {
            ArrayList<URI> volumeContent = new ArrayList<URI>();
            Iterator iterator = lib.getContent(volume).iterator();
            while (iterator.hasNext()) {
                FileObject libEntryFO;
                URL origlibEntry;
                URL libEntry = origlibEntry = (URL)iterator.next();
                String jarFolder = null;
                if ("jar".equals(libEntry.getProtocol())) {
                    jarFolder = JFXProjectGenerator.getJarFolder(URI.create(libEntry.toExternalForm()));
                    libEntry = FileUtil.getArchiveFile((URL)libEntry);
                }
                if ((libEntryFO = URLMapper.findFileObject((URL)libEntry)) == null) {
                    if (!"file".equals(libEntry.getProtocol()) && !"nbinst".equals(libEntry.getProtocol())) {
                        Logger.getLogger(JFXProjectGenerator.class.getName()).log(Level.INFO, "referenceLibrary is ignoring entry {0}", libEntry);
                        continue;
                    }
                    Logger.getLogger(JFXProjectGenerator.class.getName()).log(Level.WARNING, "Library ''{0}'' contains entry ({1}) which does not exist. This entry is ignored and will not be refernced from sharable libraries.", new Object[]{lib.getDisplayName(), libEntry});
                    continue;
                }
                String name = PropertyUtils.relativizeFile((File)libBaseFolder, (File)FileUtil.toFile((FileObject)libEntryFO));
                if (name == null) {
                    Logger.getLogger(JFXProjectGenerator.class.getName()).log(Level.WARNING, "Can not relativize file: {0}", libEntryFO.getPath());
                    continue;
                }
                URI u = LibrariesSupport.convertFilePathToURI((String)name);
                if (FileUtil.isArchiveFile((FileObject)libEntryFO)) {
                    u = JFXProjectGenerator.appendJarFolder(u, jarFolder);
                }
                volumeContent.add(u);
            }
            content.put(volume, volumeContent);
        }
        final LibraryManager man = LibraryManager.forLocation((URL)location);
        try {
            return (Library)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Library>(){

                public Library run() throws IOException {
                    String name = lib.getName();
                    if (generateLibraryUniqueName) {
                        int index = 2;
                        while (man.getLibrary(name) != null) {
                            name = lib.getName() + "-" + index;
                            ++index;
                        }
                    }
                    return man.createURILibrary(lib.getType(), name, content);
                }
            });
        }
        catch (MutexException ex) {
            throw (IOException)ex.getException();
        }
    }

    private static void createFiles(String mainClassName, String fxmlName, FileObject srcFolder, JavaFXProjectWizardIterator.WizardType type) throws IOException {
        DataFolder pDf = DataFolder.findFolder((FileObject)srcFolder);
        if (mainClassName != null && mainClassName.length() > 0) {
            String pName;
            String mName;
            int lastDotIdx = mainClassName.lastIndexOf(46);
            if (lastDotIdx == -1) {
                mName = mainClassName.trim();
                pName = null;
            } else {
                mName = mainClassName.substring(lastDotIdx + 1).trim();
                pName = mainClassName.substring(0, lastDotIdx).trim();
            }
            if (mName.length() > 0) {
                HashMap<String, String> params = null;
                FileObject template = null;
                switch (type) {
                    case APPLICATION: {
                        template = FileUtil.getConfigFile((String)"Templates/javafx/FXMain.java");
                        break;
                    }
                    case PRELOADER: {
                        template = FileUtil.getConfigFile((String)"Templates/javafx/FXPreloader.java");
                        break;
                    }
                    case SWING: {
                        template = FileUtil.getConfigFile((String)"Templates/javafx/FXSwingMain.java");
                        break;
                    }
                    case FXML: {
                        template = FileUtil.getConfigFile((String)"Templates/javafx/FXML.java");
                        params = new HashMap<String, String>(1);
                        params.put("fxmlname", fxmlName);
                    }
                }
                if (template == null) {
                    return;
                }
                DataObject mt = DataObject.find((FileObject)template);
                if (pName != null) {
                    String fName = pName.replace('.', '/');
                    FileObject pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
                    pDf = DataFolder.findFolder((FileObject)pkgFolder);
                }
                if (params != null) {
                    mt.createFromTemplate(pDf, mName, params);
                } else {
                    mt.createFromTemplate(pDf, mName);
                }
            }
        }
        if (type == JavaFXProjectWizardIterator.WizardType.FXML) {
            FileObject xmlTemplate = FileUtil.getConfigFile((String)"Templates/javafx/NewProjectFXML.fxml");
            if (xmlTemplate == null) {
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("postfix", NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"TXT_FileNameControllerPostfix"));
            DataObject dXMLTemplate = DataObject.find((FileObject)xmlTemplate);
            dXMLTemplate.createFromTemplate(pDf, fxmlName, params);
            FileObject javaTemplate = FileUtil.getConfigFile((String)"Templates/javafx/FXML2.java");
            if (javaTemplate == null) {
                return;
            }
            DataObject dJavaTemplate = DataObject.find((FileObject)javaTemplate);
            dJavaTemplate.createFromTemplate(pDf, fxmlName + NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"TXT_FileNameControllerPostfix"));
        }
    }

    private static void createPreloaderClass(String preloaderClassName, FileObject srcFolder) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = preloaderClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = preloaderClassName.trim();
            pName = null;
        } else {
            mName = preloaderClassName.substring(lastDotIdx + 1).trim();
            pName = preloaderClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        FileObject template = FileUtil.getConfigFile((String)"Templates/javafx/FXPreloader.java");
        if (template == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)template);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mt.createFromTemplate(pDf, mName);
    }

    private static SpecificationVersion getPlatformSourceLevel(String fxPlatformName) {
        JavaPlatform[] platforms;
        JavaPlatform platform = null;
        for (JavaPlatform javaPlatform : platforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String platformName = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!JFXProjectProperties.isEqual(platformName, fxPlatformName)) continue;
            platform = javaPlatform;
            break;
        }
        if (platform == null) {
            return new SpecificationVersion("1.6");
        }
        SpecificationVersion v = platform.getSpecification().getVersion();
        return v;
    }

    private static SpecificationVersion getDefaultSourceLevel() {
        if (defaultSourceLevel != null) {
            return defaultSourceLevel;
        }
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion v = defaultPlatform.getSpecification().getVersion();
        return v;
    }

    private static String validatePropertyValue(String value) {
        Matcher m = INVALID_NAME.matcher(value);
        if (m.find()) {
            value = m.replaceAll("_");
        }
        return value;
    }

    public static void setDefaultSourceLevel(SpecificationVersion version) {
        defaultSourceLevel = version;
    }

    static {
        INVALID_NAME = Pattern.compile("[$/\\\\\\p{Cntrl}]");
    }

    static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action CREATE = new Action("USG_PROJECT_CREATE", "USG_PROJECT_CREATE_JFX");
        public static final /* enum */ Action OPEN = new Action("USG_PROJECT_OPEN", "USG_PROJECT_OPEN_JFX");
        public static final /* enum */ Action CLOSE = new Action("USG_PROJECT_CLOSE", "USG_PROJECT_CLOSE_JFX");
        public static final /* enum */ Action BUILD_NATIVE = new Action("USG_PROJECT_BUILD_NATIVE", "USG_PROJECT_BUILD_NATIVE_JFX");
        private final String genericLogMessage;
        private final String specificLogMessage;
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String name) {
            return Enum.valueOf(Action.class, name);
        }

        private Action(String genericLogMessage, String specificLogMessage) {
            assert (genericLogMessage != null);
            assert (specificLogMessage != null);
            this.genericLogMessage = genericLogMessage;
            this.specificLogMessage = specificLogMessage;
        }

        @NonNull
        public String getGenericLogMessage() {
            return this.genericLogMessage;
        }

        @NonNull
        public String getSpecificLogMessage() {
            return this.specificLogMessage;
        }

        static {
            $VALUES = new Action[]{CREATE, OPEN, CLOSE, BUILD_NATIVE};
        }
    }
}

