/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXPlatformUpdater;
import org.netbeans.modules.javafx2.project.JFXProjectGenerator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.windows.WindowManager;

public final class JFXProjectOpenedHook
extends ProjectOpenedHook {
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private final Project prj;
    private final J2SEPropertyEvaluator eval;
    private ConfigChangeListener chl = null;
    private static final Map<String, List<Notification>> projectNotifications = new HashMap<String, List<Notification>>();

    public JFXProjectOpenedHook(Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        this.prj = (Project)lkp.lookup(Project.class);
        Parameters.notNull((CharSequence)"prj", (Object)this.prj);
        this.eval = (J2SEPropertyEvaluator)lkp.lookup(J2SEPropertyEvaluator.class);
        Parameters.notNull((CharSequence)"eval", (Object)this.eval);
    }

    protected synchronized void projectOpened() {
        if (!JFXProjectOpenedHook.isFXProject(this.eval)) {
            Runnable runUpdateJFXPlatform;
            final JFXPlatformUpdater updater = (JFXPlatformUpdater)this.prj.getLookup().lookup(JFXPlatformUpdater.class);
            Runnable runnable = runUpdateJFXPlatform = updater != null ? new Runnable(){

                @Override
                public void run() {
                    updater.updateFXPlatform();
                }
            } : null;
            if (runUpdateJFXPlatform != null) {
                this.switchBusy();
                runUpdateJFXPlatform.run();
                this.switchDefault();
            }
        } else {
            Runnable runUpdateJFXImpl;
            JFXProjectGenerator.logUsage(JFXProjectGenerator.Action.OPEN);
            Preferences prefs = ProjectUtils.getPreferences((Project)this.prj, Project.class, (boolean)false);
            prefs.put("issue214819_fx_enabled", "true");
            ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)this.prj.getLookup().lookup(ProjectConfigurationProvider.class);
            assert (pcp != null);
            LOGGER.log(Level.INFO, "FX PCP: " + pcp.toString());
            this.chl = new ConfigChangeListener(this.prj);
            pcp.addPropertyChangeListener((PropertyChangeListener)this.chl);
            final JFXPlatformUpdater updater = (JFXPlatformUpdater)this.prj.getLookup().lookup(JFXPlatformUpdater.class);
            Runnable runUpdateJFXPlatform = updater != null ? new Runnable(){

                @Override
                public void run() {
                    updater.updateFXPlatform();
                }
            } : null;
            Runnable runnable = runUpdateJFXImpl = this.isEnabledJFXUpdate() ? new Runnable(){

                @Override
                public void run() {
                    JFXProjectOpenedHook.this.updateDefaultConfigs();
                    FileObject readmeFO = JFXProjectOpenedHook.this.updateJfxImpl();
                    if (readmeFO != null && JFXProjectOpenedHook.this.isEnabledJFXUpdateNotification()) {
                        String headerTemplate = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_README_FILE_CONTENT_HEADER");
                        String header = MessageFormat.format(headerTemplate, ProjectUtils.getInformation((Project)JFXProjectOpenedHook.this.prj).getDisplayName());
                        String content = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_NOTIFICATION_CONTENT");
                        Notification noteUpdate = NotificationDisplayer.getDefault().notify(header, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javafx2/project/ui/resources/jfx_project.png", (boolean)true), content, null, NotificationDisplayer.Priority.LOW, NotificationDisplayer.Category.INFO);
                        JFXProjectOpenedHook.addNotification(JFXProjectOpenedHook.this.prj, noteUpdate);
                    }
                }
            } : null;
            if (runUpdateJFXPlatform != null || runUpdateJFXImpl != null) {
                this.switchBusy();
                if (runUpdateJFXPlatform != null) {
                    runUpdateJFXPlatform.run();
                }
                if (runUpdateJFXImpl != null) {
                    runUpdateJFXImpl.run();
                }
                this.switchDefault();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNotification(@NonNull Project project, @NonNull Notification notification) {
        Map<String, List<Notification>> map = projectNotifications;
        synchronized (map) {
            String path = project.getProjectDirectory().getPath();
            List<Notification> notifications = projectNotifications.get(path);
            if (notifications == null) {
                notifications = new ArrayList<Notification>();
                projectNotifications.put(path, notifications);
            }
            notifications.add(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void projectClosed() {
        JFXPlatformUpdater updater;
        List<Notification> notifications;
        if (JFXProjectOpenedHook.isFXProject(this.eval)) {
            JFXProjectGenerator.logUsage(JFXProjectGenerator.Action.CLOSE);
            if (this.chl != null) {
                ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)this.prj.getLookup().lookup(ProjectConfigurationProvider.class);
                assert (pcp != null);
                pcp.removePropertyChangeListener((PropertyChangeListener)this.chl);
                this.chl = null;
            }
        }
        String path = this.prj.getProjectDirectory().getPath();
        Map<String, List<Notification>> map = projectNotifications;
        synchronized (map) {
            notifications = projectNotifications.get(path);
            projectNotifications.remove(path);
        }
        if (notifications != null) {
            for (Notification n : notifications) {
                n.clear();
            }
        }
        if ((updater = (JFXPlatformUpdater)this.prj.getLookup().lookup(JFXPlatformUpdater.class)) != null) {
            updater.resetUpdated();
        }
    }

    private boolean isEnabledJFXUpdate() {
        PropertyEvaluator evaluator = this.eval.evaluator();
        if (evaluator != null) {
            return !JFXProjectProperties.isTrue(evaluator.getProperty("javafx.disable.autoupdate"));
        }
        LOGGER.log(Level.WARNING, "PropertyEvaluator instantiation failed, disabling jfx-impl.xml auto-update.");
        return false;
    }

    private boolean isEnabledJFXUpdateNotification() {
        PropertyEvaluator evaluator = this.eval.evaluator();
        if (evaluator != null) {
            return !JFXProjectProperties.isTrue(evaluator.getProperty("javafx.disable.autoupdate.notification"));
        }
        LOGGER.log(Level.WARNING, "PropertyEvaluator instantiation failed, disabling jfx-impl.xml auto-update notification.");
        return false;
    }

    private FileObject updateJfxImpl() {
        FileObject readmeFO = null;
        try {
            AntBuildExtender extender = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
            if (extender == null) {
                LOGGER.log(Level.WARNING, "The project {0} ({1}) does not support AntBuildExtender.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            } else if (extender.getExtension(JFXProjectUtils.getCurrentExtensionName()) != null) {
                readmeFO = JFXProjectUtils.updateJfxImpl(this.prj);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't update JavaFX specific build script jfx-impl.xml: {0}", ex);
        }
        return readmeFO;
    }

    private boolean updateDefaultConfigs() {
        boolean updated = false;
        PropertyEvaluator evaluator = this.eval.evaluator();
        if (evaluator != null) {
            try {
                updated |= JFXProjectUtils.updateDefaultRunAsConfigFile(this.prj.getProjectDirectory(), JFXProjectProperties.RunAsType.ASWEBSTART, false);
                updated |= JFXProjectUtils.updateDefaultRunAsConfigFile(this.prj.getProjectDirectory(), JFXProjectProperties.RunAsType.INBROWSER, !JFXProjectProperties.isNonEmpty(evaluator.getProperty("javafx.run.inbrowser")) || !JFXProjectProperties.isNonEmpty(evaluator.getProperty("javafx.run.inbrowser.path")));
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't update JavaFX specific RunAs configuration files: {0}", ex);
            }
        } else {
            LOGGER.log(Level.WARNING, "PropertyEvaluator instantiation failed, disabling jfx-impl.xml auto-update.");
        }
        return updated;
    }

    private void switchBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    private void switchDefault() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    private static boolean isFXProject(@NonNull J2SEPropertyEvaluator eval) {
        if (eval == null) {
            return false;
        }
        return JFXProjectOpenedHook.isTrue(eval.evaluator().getProperty("javafx.enabled"));
    }

    private static boolean isTrue(@NullAllowed String value) {
        return value != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value));
    }

    private static final class ConfigChangeListener
    implements PropertyChangeListener {
        private final Project prj;

        public ConfigChangeListener(Project p) {
            this.prj = p;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("activeConfiguration")) {
                LOGGER.log(Level.FINE, "FX config change: " + evt.toString());
                Lookup look = this.prj.getLookup();
                JFXProjectProperties props = JFXProjectProperties.getInstanceIfExists(look);
                if (props == null || props.hasPreloaderInAnyConfig()) {
                    boolean propsDidNotExist = props == null;
                    JFXProjectProperties.cleanup(look);
                    props = JFXProjectProperties.getInstance(look);
                    props.updatePreloaderDependencies();
                    if (propsDidNotExist) {
                        JFXProjectProperties.cleanup(look);
                    }
                }
            }
        }
    }
}

