/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class JavadocGenerator {
    private final SourceVersion srcVersion;
    private String author = System.getProperty("user.name");

    public void updateSettings(FileObject file) {
        DataObject dobj = null;
        DataFolder folder = null;
        try {
            dobj = DataObject.find((FileObject)file);
            folder = dobj.getFolder();
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (dobj == null || folder == null) {
            return;
        }
        for (CreateFromTemplateAttributesProvider provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
            Object aName;
            Map attrs = provider.attributesFor(dobj, folder, "XXX");
            if (attrs == null || (aName = attrs.get("user")) == null) continue;
            this.author = aName.toString();
            break;
        }
    }

    public JavadocGenerator(SourceVersion version) {
        this.srcVersion = version;
    }

    public String generateComment(TypeElement clazz, CompilationInfo javac) {
        StringBuilder builder = new StringBuilder("\n");
        if (clazz.getNestingKind() == NestingKind.TOP_LEVEL) {
            builder.append("@author ").append(this.author).append("\n");
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0) {
            for (TypeParameterElement typeParameterElement : clazz.getTypeParameters()) {
                builder.append("@param <").append(typeParameterElement.getSimpleName().toString()).append("> \n");
            }
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, clazz)) {
            builder.append("@deprecated\n");
        }
        return builder.toString();
    }

    public String generateComment(ExecutableElement method, CompilationInfo javac) {
        MethodTree tree;
        StringBuilder builder = new StringBuilder("\n");
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            builder.append("@param <").append(typeParameterElement.getSimpleName().toString()).append("> \n");
        }
        for (VariableElement variableElement : method.getParameters()) {
            builder.append("@param ").append(variableElement.getSimpleName().toString()).append(" \n");
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            builder.append("@return \n");
        }
        List<? extends ExpressionTree> list = (tree = javac.getTrees().getTree(method)) != null ? tree.getThrows() : null;
        int i = 0;
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            CharSequence name;
            if (TypeKind.DECLARED == typeMirror.getKind() || TypeKind.ERROR == typeMirror.getKind()) {
                exception = (TypeElement)((DeclaredType)typeMirror).asElement();
                name = exception.getQualifiedName();
                if (list != null) {
                    name = JavadocGenerator.resolveThrowsName(exception, name.toString(), list.get(i));
                }
            } else if (TypeKind.TYPEVAR == typeMirror.getKind()) {
                exception = (TypeParameterElement)((TypeVariable)typeMirror).asElement();
                name = exception.getSimpleName();
            } else {
                throw new IllegalStateException("Illegal kind: " + typeMirror.getKind());
            }
            builder.append("@throws ").append(name).append(" \n");
            ++i;
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, method)) {
            builder.append("@deprecated\n");
        }
        return builder.toString();
    }

    public String generateComment(VariableElement field, CompilationInfo javac) {
        StringBuilder builder = new StringBuilder("\n");
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, field)) {
            builder.append("@deprecated\n");
        }
        return builder.toString();
    }

    public String generateComment(Element elm, CompilationInfo javac) {
        switch (elm.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return this.generateComment((TypeElement)elm, javac);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return this.generateComment((ExecutableElement)elm, javac);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                return this.generateComment((VariableElement)elm, javac);
            }
        }
        return null;
    }

    public DocCommentTree generateComment(Element elm, final CompilationInfo javac, TreeMaker make) {
        LinkedList firstSentence = new LinkedList();
        LinkedList body = new LinkedList();
        LinkedList<BlockTagTree> tags = new LinkedList<BlockTagTree>();
        switch (elm.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                TypeElement clazz = (TypeElement)elm;
                if (clazz.getNestingKind() == NestingKind.TOP_LEVEL) {
                    tags.add(make.Author(Collections.singletonList(make.Text(this.author))));
                }
                if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) > 0) break;
                for (TypeParameterElement typeParameterElement : clazz.getTypeParameters()) {
                    tags.add(make.Param(true, make.DocIdentifier((CharSequence)typeParameterElement.getSimpleName()), Collections.emptyList()));
                }
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                ExecutableElement method = (ExecutableElement)elm;
                for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
                    tags.add(make.Param(true, make.DocIdentifier((CharSequence)typeParameterElement.getSimpleName()), Collections.emptyList()));
                }
                for (VariableElement variableElement : method.getParameters()) {
                    tags.add(make.Param(false, make.DocIdentifier((CharSequence)variableElement.getSimpleName()), Collections.emptyList()));
                }
                if (method.getReturnType().getKind() != TypeKind.VOID) {
                    tags.add(make.DocReturn(Collections.emptyList()));
                }
                for (TypeMirror typeMirror : method.getThrownTypes()) {
                    Element exception;
                    if (TypeKind.DECLARED == typeMirror.getKind() || TypeKind.ERROR == typeMirror.getKind()) {
                        exception = (TypeElement)((DeclaredType)typeMirror).asElement();
                    } else if (TypeKind.TYPEVAR == typeMirror.getKind()) {
                        exception = (TypeParameterElement)((TypeVariable)typeMirror).asElement();
                    } else {
                        throw new IllegalStateException("Illegal kind: " + typeMirror.getKind());
                    }
                    ExpressionTree ident = make.QualIdent(exception);
                    tags.add(make.Throws(make.Reference(ident, null, null), Collections.emptyList()));
                }
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(elm.getKind() + ", " + elm.getClass() + ": " + elm.toString());
            }
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, elm)) {
            tags.add(make.Deprecated(Collections.emptyList()));
        }
        final boolean[] useMarkdown = new boolean[1];
        TreePath tp = javac.getTrees().getPath(elm);
        if (tp != null) {
            new TreePathScanner<Void, Void>(){
                private boolean seenJavadoc;

                @Override
                public Void scan(Tree tree, Void p) {
                    if (this.seenJavadoc) {
                        return null;
                    }
                    return (Void)super.scan(tree, p);
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    this.checkJavadoc();
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                public Void visitMethod(MethodTree node, Void p) {
                    this.checkJavadoc();
                    return (Void)super.visitMethod(node, p);
                }

                @Override
                public Void visitClass(ClassTree node, Void p) {
                    this.checkJavadoc();
                    return (Void)super.visitClass(node, p);
                }

                private void checkJavadoc() {
                    Elements.DocCommentKind kind = javac.getDocTrees().getDocCommentKind(this.getCurrentPath());
                    if (kind != null) {
                        useMarkdown[0] = kind == Elements.DocCommentKind.END_OF_LINE;
                        this.seenJavadoc |= useMarkdown[0];
                    }
                }
            }.scan((Tree)tp.getCompilationUnit(), null);
        }
        if (useMarkdown[0]) {
            return make.MarkdownDocComment(firstSentence, body, tags);
        }
        return make.DocComment(firstSentence, body, tags);
    }

    private static String resolveThrowsName(Element el, String fqn, ExpressionTree throwTree) {
        boolean nestedClass = ElementKind.CLASS == el.getKind() && NestingKind.TOP_LEVEL != ((TypeElement)el).getNestingKind();
        String insertName = nestedClass ? fqn : throwTree.toString();
        return insertName;
    }
}

