/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.java.navigation.Bundle;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ClassMemberPanel;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.ElementScanningTask;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.netbeans.modules.java.navigation.NoBorderToolBar;
import org.netbeans.modules.java.navigation.ToolTipManagerEx;
import org.netbeans.modules.java.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.java.navigation.actions.SortActions;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.netbeans.modules.java.navigation.base.HistorySupport;
import org.netbeans.modules.java.navigation.base.Resolvers;
import org.netbeans.modules.java.navigation.base.SelectJavadocTask;
import org.netbeans.modules.java.navigation.base.TapPanel;
import org.netbeans.modules.java.navigation.base.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
FiltersManager.FilterChangeListener,
PropertyChangeListener {
    private static final String JDOC_ICON = "org/netbeans/modules/java/navigation/resources/javadoc_open.png";
    private static final String CMD_JDOC = "jdoc";
    private static final String CMD_HISTORY = "history";
    private static final int MIN_HISTORY_WIDTH = 50;
    private static final int HISTORY_HEIGHT = 20;
    private static final ThreadLocal<Boolean> ignoreJavaDoc = new ThreadLocal();
    private final ExplorerManager manager = new ExplorerManager();
    private final MyBeanTreeView elementView;
    private final TapPanel filtersPanel;
    private final InstanceContent selectedNodes = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);
    private final ClassMemberFilters filters;
    private final AtomicReference<State> state = new AtomicReference();
    private final Action[] actions;
    private final SelectJavadocTask jdocFinder;
    private final RequestProcessor.Task watcherTask = WATCHER_RP.create(new Runnable(){

        @Override
        public void run() {
            State current = (State)((Object)ClassMemberPanelUI.this.state.get());
            if (current != State.DONE) {
                LOG.log(Level.WARNING, "No scheduled navigator update in {0}ms, current state: {1}", new Object[]{30000, ClassMemberPanelUI.this.state.get()});
            }
        }
    });
    private final RequestProcessor.Task jdocTask;
    private final HistorySupport history;
    private long lastShowWaitNodeTime = -1L;
    private Toolbar toolbar;
    private volatile boolean auto;
    private static final int JDOC_TIME = 500;
    private static final Logger LOG = Logger.getLogger(ClassMemberPanelUI.class.getName());
    private static final Logger PERF_LOG = Logger.getLogger(ClassMemberPanelUI.class.getName() + ".perf");
    private static final RequestProcessor RP = new RequestProcessor(ClassMemberPanelUI.class.getName(), 1);
    private static final RequestProcessor WATCHER_RP = new RequestProcessor(ClassMemberPanelUI.class.getName() + ".watcher", 1, false, false);
    private static final int WATCHER_TIME = 30000;
    private static final String INHERITED_COLOR_KEY = "nb.navigator.inherited.color";
    private static final String TYPE_COLOR_KEY = "nb.navigator.type.color";
    private static final Color DEFAULT_TYPE_COLOR = new Color(112, 112, 112);
    private static final Color DEFAULT_INHERITED_COLOR = new Color(125, 105, 74);
    private final Color inheritedColor = UIManager.getColor("nb.navigator.inherited.color");
    private final Color typeColor = UIManager.getColor("nb.navigator.type.color");

    public ClassMemberPanelUI() {
        this.history = HistorySupport.getInstnace(this.getClass());
        this.jdocFinder = SelectJavadocTask.create(this);
        this.jdocTask = RP.create((Runnable)this.jdocFinder);
        this.initComponents();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String keyText = Utilities.keyToString((KeyStroke)toggleKey);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)keyText));
        this.filters = new ClassMemberFilters(this);
        this.filters.getFiltersManager().hookChangeListener(this);
        JComponent buttons = this.filters.getComponent();
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(buttons);
        Utils.updateBackground(this.filtersPanel);
        this.actions = new Action[]{SortActions.createSortByNameAction(this.filters), SortActions.createSortBySourceAction(this.filters), null, new FilterSubmenuAction(this.filters.getFiltersManager())};
        this.add((Component)this.filtersPanel, "South");
        boolean expanded = NbPreferences.forModule(ClassMemberPanelUI.class).getBoolean("filtersPanelTap.expanded", true);
        this.filtersPanel.setExpanded(expanded);
        this.filtersPanel.addPropertyChangeListener(this);
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return result;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.elementView.requestFocus();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(this);
    }

    @NonNull
    String getInheritedColor() {
        return ClassMemberPanelUI.getHtmlColor(this.inheritedColor == null ? DEFAULT_INHERITED_COLOR : this.inheritedColor);
    }

    @NonNull
    String getTypeColor() {
        return ClassMemberPanelUI.getHtmlColor(this.typeColor == null ? DEFAULT_TYPE_COLOR : this.typeColor);
    }

    @NonNull
    private static String getHtmlColor(@NonNull Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        StringBuilder result = new StringBuilder();
        result.append("#");
        String rs = Integer.toHexString(r);
        String gs = Integer.toHexString(g);
        String bs = Integer.toHexString(b);
        if (r < 16) {
            result.append('0');
        }
        result.append(rs);
        if (g < 16) {
            result.append('0');
        }
        result.append(gs);
        if (b < 16) {
            result.append('0');
        }
        result.append(bs);
        return result.toString();
    }

    void showWaitNode() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
                ClassMemberPanelUI.this.lastShowWaitNodeTime = System.currentTimeMillis();
                ClassMemberPanelUI.this.scheduled();
            }
        });
    }

    void clearNodes(boolean resetAutoRefresh) {
        ClassMemberPanel.compareAndSetLastUsedFile(null);
        if (resetAutoRefresh) {
            this.auto = false;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(false);
                ClassMemberPanelUI.this.manager.setRootContext((Node)new AbstractNode(Children.LEAF));
            }
        });
    }

    private void scheduled() {
        this.state.set(State.SCHEDULED);
        boolean ae = false;
        if (!$assertionsDisabled) {
            ae = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (ae) {
            this.watcherTask.schedule(30000);
        }
    }

    void start() {
        this.state.set(State.INVOKED);
    }

    private void done() {
        this.state.set(State.DONE);
        boolean ae = false;
        if (!$assertionsDisabled) {
            ae = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (ae) {
            this.watcherTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNode(Pair<ElementHandle<Element>, TreePathHandle> pattern) {
        ElementNode root = this.getRootNode();
        if (root == null) {
            return;
        }
        ElementNode node = root.stream().filter(n -> {
            ElementNode.Description d = n.getDescription();
            boolean match = true;
            if (pattern.first() != null) {
                match &= ((ElementHandle)pattern.first()).equals(d.getElementHandle());
            }
            if (pattern.second() != null) {
                match &= ((TreePathHandle)pattern.second()).equals((Object)d.getTreePathHandle());
            }
            return match;
        }).findFirst().orElse(null);
        ignoreJavaDoc.set(true);
        try {
            this.manager.setSelectedNodes(new Node[]{node == null ? root : node});
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
        finally {
            ignoreJavaDoc.remove();
        }
    }

    public void setContext(@NonNull JavaSource js, @NullAllowed JTextComponent target) {
        Callable<Pair<URI, ElementHandle<TypeElement>>> resolver = target == null ? Resolvers.createFileResolver(js) : Resolvers.createEditorResolver(js, target.getCaret().getDot());
        this.schedule(resolver);
    }

    synchronized JComponent getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
        }
        return this.toolbar;
    }

    void refresh() {
        RP.execute(new Runnable(){

            @Override
            public void run() {
                JavaSource js;
                FileObject fo;
                ElementNode rootNode = ClassMemberPanelUI.this.getRootNode();
                if (rootNode != null && (fo = rootNode.getDescription().fileObject) != null && (js = JavaSource.forFileObject((FileObject)fo)) != null) {
                    try {
                        js.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController parameter) throws Exception {
                                parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                ClassMemberPanelUI.this.getTask().runImpl((CompilationInfo)parameter, true);
                            }
                        }, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }

    void refresh(final @NonNull ElementNode.Description description, final boolean userAction) {
        this.auto = !userAction;
        final ElementNode rootNode = this.getRootNode();
        if (rootNode != null && rootNode.getDescription().fileObject.equals(description.fileObject)) {
            this.jdocTask.cancel();
            this.jdocFinder.cancel();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    rootNode.updateRecursively(description);
                    if (!userAction) {
                        ClassMemberPanelUI.this.toolbar.setAuto();
                    }
                    ClassMemberPanelUI.this.done();
                }
            });
        } else {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    ClassMemberPanelUI.this.elementView.setRootVisible(false);
                    ClassMemberPanelUI.this.manager.setRootContext((Node)new ElementNode(description));
                    if (!userAction) {
                        ClassMemberPanelUI.this.toolbar.setAuto();
                    }
                    ClassMemberPanelUI.this.done();
                    boolean scrollOnExpand = ClassMemberPanelUI.this.getScrollOnExpand();
                    ClassMemberPanelUI.this.setScrollOnExpand(false);
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(false);
                    ClassMemberPanelUI.this.elementView.expandAll();
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(true);
                    ClassMemberPanelUI.this.setScrollOnExpand(scrollOnExpand);
                    if (PERF_LOG.isLoggable(Level.FINE)) {
                        long tm2 = System.currentTimeMillis();
                        long tm1 = ClassMemberPanelUI.this.lastShowWaitNodeTime;
                        if (tm1 != -1L) {
                            ClassMemberPanelUI.this.lastShowWaitNodeTime = -1L;
                            PERF_LOG.log(Level.FINE, String.format("ClassMemberPanelUI refresh took: %d ms", tm2 - tm1), new Object[]{description.getFileObject().getName(), tm2 - tm1});
                        }
                    }
                }
            });
        }
    }

    boolean isAutomaticRefresh() {
        return this.auto;
    }

    public void sort() {
        ElementNode root = this.getRootNode();
        if (null != root) {
            root.refreshRecursively();
        }
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node n) {
        this.elementView.expandNode(n);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        ElementNode root = this.getRootNode();
        if (root != null) {
            return root.getDescription().fileObject;
        }
        return null;
    }

    @Override
    public void filterStateChanged(ChangeEvent e) {
        ElementNode root = this.getRootNode();
        if (root != null) {
            root.refreshRecursively();
        }
    }

    boolean getScrollOnExpand() {
        return null == this.elementView ? true : this.elementView.getScrollOnExpand();
    }

    void setScrollOnExpand(boolean scroll) {
        if (null != this.elementView) {
            this.elementView.setScrollOnExpand(scroll);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node n = this.manager.getRootContext();
        if (n instanceof ElementNode) {
            return (ElementNode)n;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        return new MyBeanTreeView();
    }

    private void scheduleJavadocRefresh(int time) {
        this.jdocFinder.cancel();
        this.jdocTask.schedule(time);
    }

    private void schedule(@NonNull Callable<Pair<URI, ElementHandle<TypeElement>>> resolver) {
        this.showWaitNode();
        Future becomesHandle = RP.submit(resolver);
        RefreshTask refresh = new RefreshTask(becomesHandle);
        RP.execute((Runnable)refresh);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private ElementJavadoc getJavaDocFor(@NonNull ElementNode node, @NullAllowed Callable<Boolean> cancel) {
        ElementNode root = this.getRootNode();
        if (root == null) {
            return null;
        }
        ElementHandle<?> eh = node.getDescription().getElementHandle();
        if (eh == null) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)root.getDescription().fileObject);
        if (js == null) {
            return null;
        }
        JavaDocCalculator calculator = new JavaDocCalculator(eh, cancel);
        try {
            js.runUserActionTask((Task)calculator, true);
        }
        catch (IOException ioE) {
            Exceptions.printStackTrace((Throwable)ioE);
            return null;
        }
        return calculator.doc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] oldNodes = (Node[])evt.getOldValue();
            Node[] newNodes = (Node[])evt.getNewValue();
            for (Node n : oldNodes) {
                this.selectedNodes.remove((Object)n);
            }
            for (Node n : newNodes) {
                this.selectedNodes.add((Object)n);
            }
            boolean javadocDone = ignoreJavaDoc.get() == Boolean.TRUE;
            RP.execute(() -> {
                if (newNodes.length > 0 && !javadocDone && JavadocTopComponent.shouldUpdate()) {
                    this.scheduleJavadocRefresh(500);
                }
            });
        } else if ("TapPanel.expanded".equals(evt.getPropertyName())) {
            NbPreferences.forModule(ClassMemberPanelUI.class).putBoolean("filtersPanelTap.expanded", this.filtersPanel.isExpanded());
        }
    }

    private class Toolbar
    extends JPanel
    implements ActionListener,
    ListDataListener {
        private final JComboBox historyCombo;
        private boolean ignoreEvents;

        Toolbar() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            NoBorderToolBar toolbar = new NoBorderToolBar(0);
            toolbar.setFloatable(false);
            toolbar.setRollover(true);
            toolbar.setBorderPainted(false);
            toolbar.setBorder(BorderFactory.createEmptyBorder());
            toolbar.setOpaque(false);
            toolbar.setFocusable(false);
            this.historyCombo = new JComboBox(HistorySupport.createModel(ClassMemberPanelUI.this.history, Bundle.TXT_InspectMembersHistoryEmpty()));
            this.historyCombo.setMinimumSize(new Dimension(50, 20));
            this.historyCombo.setRenderer(HistorySupport.createRenderer(ClassMemberPanelUI.this.history));
            this.historyCombo.setActionCommand(ClassMemberPanelUI.CMD_HISTORY);
            this.historyCombo.addActionListener(this);
            this.historyCombo.getModel().addListDataListener(this);
            this.historyCombo.setEnabled(false);
            this.historyCombo.setToolTipText(Bundle.TOOLTIP_InspectMembersHistory());
            JButton jdocButton = new JButton(ImageUtilities.loadImageIcon((String)ClassMemberPanelUI.JDOC_ICON, (boolean)true));
            jdocButton.setActionCommand(ClassMemberPanelUI.CMD_JDOC);
            jdocButton.addActionListener(this);
            jdocButton.setFocusable(false);
            jdocButton.setToolTipText(Bundle.TOOLTIP_OpenJDoc());
            toolbar.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.anchor = 17;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            toolbar.add((Component)this.historyCombo, c);
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.anchor = 13;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            toolbar.add((Component)jdocButton, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.anchor = 17;
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.add((Component)toolbar, c);
            Utils.updateBackground(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selItem;
            assert (SwingUtilities.isEventDispatchThread());
            if (ClassMemberPanelUI.CMD_JDOC.equals(e.getActionCommand())) {
                JavadocTopComponent win = JavadocTopComponent.findInstance();
                if (win != null && !win.isShowing()) {
                    win.open();
                    win.requestVisible();
                    ClassMemberPanelUI.this.scheduleJavadocRefresh(0);
                }
            } else if (!this.ignoreEvents && ClassMemberPanelUI.CMD_HISTORY.equals(e.getActionCommand()) && (selItem = this.historyCombo.getSelectedItem()) instanceof Pair) {
                final Pair pair = (Pair)selItem;
                ClassMemberPanelUI.this.schedule(new Callable<Pair<URI, ElementHandle<TypeElement>>>(){

                    @Override
                    public Pair<URI, ElementHandle<TypeElement>> call() throws Exception {
                        return pair;
                    }
                });
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.showHistory();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.showHistory();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.showHistory();
        }

        void select(final @NonNull Pair<URI, ElementHandle<TypeElement>> pair) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    Toolbar.this.ignoreEvents = true;
                    try {
                        Toolbar.this.historyCombo.getModel().setSelectedItem(pair);
                    }
                    finally {
                        Toolbar.this.ignoreEvents = false;
                    }
                }
            });
        }

        void setAuto() {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (Toolbar.this.historyCombo.isEnabled()) {
                        Toolbar.this.historyCombo.getModel().setSelectedItem(Bundle.TXT_InspectMembersHistoryAuto());
                    }
                }
            });
        }

        private void showHistory() {
            if (!ClassMemberPanelUI.this.history.getHistory().isEmpty()) {
                this.historyCombo.setEnabled(true);
            }
        }
    }

    private class MyBeanTreeView
    extends BeanTreeView
    implements ToolTipManagerEx.ToolTipProvider {
        private final ToolTipManagerEx toolTipManager = new ToolTipManagerEx(this);
        private boolean inHierarchy;
        private boolean doExpandAll;

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean scroll) {
            this.tree.setScrollsOnExpand(scroll);
        }

        @Override
        public JComponent getComponent() {
            return this.tree;
        }

        @Override
        public String getToolTipText(@NonNull Node node) {
            ElementJavadoc doc = this.getDocumentation(node);
            return null == doc ? null : doc.getText();
        }

        @Override
        @CheckForNull
        public Node findNode(@NonNull Point loc) {
            TreePath path = this.tree.getPathForLocation(loc.x, loc.y);
            if (null == path) {
                return null;
            }
            Node node = Visualizer.findNode((Object)path.getLastPathComponent());
            if (!(node instanceof ElementNode)) {
                return null;
            }
            ElementNode enode = (ElementNode)node;
            ElementNode.Description desc = enode.getDescription();
            return desc.kind != ElementKind.OTHER && desc.kind != ElementKind.MODULE ? node : null;
        }

        @CheckForNull
        private ElementJavadoc getDocumentation(@NullAllowed Node node) {
            if (node instanceof ElementNode) {
                return ClassMemberPanelUI.this.getJavaDocFor((ElementNode)node, this.toolTipManager);
            }
            return null;
        }

        @Override
        public Rectangle getToolTipSourceBounds(Point loc) {
            ElementNode root = ClassMemberPanelUI.this.getRootNode();
            if (root == null) {
                return null;
            }
            TreePath path = this.tree.getPathForLocation(loc.x, loc.y);
            return null == path ? null : this.tree.getPathBounds(path);
        }

        @Override
        public Point getToolTipLocation(Point mouseLocation, Dimension tipSize) {
            Point screenLocation = this.getLocationOnScreen();
            Rectangle sBounds = this.getGraphicsConfiguration().getBounds();
            Dimension compSize = this.getSize();
            Point res = new Point();
            Rectangle tooltipSrcRect = this.getToolTipSourceBounds(mouseLocation);
            if (tooltipSrcRect == null) {
                tooltipSrcRect = new Rectangle();
            }
            Point viewPosition = this.getViewport().getViewPosition();
            screenLocation.x -= viewPosition.x;
            screenLocation.y -= viewPosition.y;
            res.x = screenLocation.x + compSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height;
            if (res.x + tipSize.width <= sBounds.x + sBounds.width && res.y + tipSize.height <= sBounds.y + sBounds.height) {
                return res;
            }
            res.x = screenLocation.x + compSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y - tipSize.height;
            if (res.x + tipSize.width <= sBounds.x + sBounds.width && res.y >= sBounds.y) {
                return res;
            }
            res.x = screenLocation.x - tipSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y;
            if (res.x >= sBounds.x && res.y + tipSize.height <= sBounds.y + sBounds.height) {
                return res;
            }
            res.x = screenLocation.x - tipSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height - tipSize.height;
            if (res.x >= sBounds.x && res.y >= sBounds.y) {
                return res;
            }
            res.x = screenLocation.x + tooltipSrcRect.x;
            res.y = sBounds.y + sBounds.height - (screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height) > screenLocation.y + tooltipSrcRect.y - sBounds.y ? screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height : screenLocation.y + tooltipSrcRect.y - tipSize.height;
            return res;
        }

        @Override
        public void invokeUserAction(final MouseEvent me) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    Node node;
                    if (null != me && (node = MyBeanTreeView.this.findNode(me.getPoint())) != null) {
                        ElementJavadoc doc = MyBeanTreeView.this.getDocumentation(node);
                        ElementNode root = ClassMemberPanelUI.this.getRootNode();
                        FileObject owner = root == null ? null : root.getDescription().fileObject;
                        JavadocTopComponent tc = JavadocTopComponent.findInstance();
                        if (null != tc) {
                            tc.open();
                            tc.setJavadoc(owner, doc);
                            tc.requestActive();
                        }
                    }
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.inHierarchy = true;
            if (this.doExpandAll) {
                super.expandAll();
                this.doExpandAll = false;
            }
        }

        public void removeNotify() {
            super.removeNotify();
            this.inHierarchy = false;
            this.toolTipManager.hideTipWindow();
        }

        public void expandAll() {
            super.expandAll();
            if (!this.inHierarchy) {
                this.doExpandAll = true;
            }
        }
    }

    private static enum State {
        SCHEDULED,
        INVOKED,
        DONE;

    }

    private class RefreshTask
    implements Runnable,
    Task<CompilationController> {
        private final Future<Pair<URI, ElementHandle<TypeElement>>> becomesHandle;

        RefreshTask(Future<Pair<URI, ElementHandle<TypeElement>>> becomesHandle) {
            assert (becomesHandle != null);
            this.becomesHandle = becomesHandle;
        }

        @Override
        public void run() {
            try {
                Pair<URI, ElementHandle<TypeElement>> handlePair = this.becomesHandle.get();
                if (handlePair != null) {
                    FileObject target = URLMapper.findFileObject((URL)((URI)handlePair.first()).toURL());
                    if (target != null) {
                        JavaSource targetJs = JavaSource.forFileObject((FileObject)target);
                        if (targetJs != null) {
                            ClassMemberPanelUI.this.history.addToHistory(handlePair);
                            targetJs.runUserActionTask((Task)this, true);
                            ((Toolbar)ClassMemberPanelUI.this.getToolbar()).select(handlePair);
                        } else {
                            ClassMemberPanelUI.this.clearNodes(true);
                            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_Cannot_Resolve_File(((ElementHandle)handlePair.second()).getQualifiedName()));
                        }
                    } else {
                        ClassMemberPanelUI.this.clearNodes(true);
                        StatusDisplayer.getDefault().setStatusText(Bundle.ERR_Cannot_Resolve_File(((ElementHandle)handlePair.second()).getQualifiedName()));
                    }
                } else {
                    ClassMemberPanelUI.this.clearNodes(true);
                    StatusDisplayer.getDefault().setStatusText(Bundle.ERR_Not_Declared_Type());
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void run(@NonNull CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            ClassMemberPanelUI.this.getTask().runImpl((CompilationInfo)cc, true);
        }
    }

    private static class JavaDocCalculator
    implements Task<CompilationController> {
        private final ElementHandle<? extends Element> handle;
        private final Callable<Boolean> cancel;
        private ElementJavadoc doc;

        public JavaDocCalculator(@NonNull ElementHandle<? extends Element> handle, @NullAllowed Callable<Boolean> cancel) {
            this.handle = handle;
            this.cancel = cancel;
        }

        public void run(CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.UP_TO_DATE);
            Element e = this.handle.resolve((CompilationInfo)cc);
            this.doc = ElementJavadoc.create((CompilationInfo)cc, (Element)e, this.cancel);
        }
    }
}

