/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.actions.Bundle;
import org.netbeans.spi.navigator.NavigatorHandler;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ShowMembersAction
extends AbstractAction {
    private static final String FORM_VIEW_ID = "form";

    public ShowMembersAction() {
        this.putValue("Name", Bundle.CTL_ShowMembersAction());
        this.putValue("ShortDescription", this.getValue("Name"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public boolean isEnabled() {
        return this.getContext() != null;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JavaSource context = this.getContext();
        if (context != null) {
            ShowMembersAction.missingNavigatorAPIHack(ev, context, null);
        }
    }

    static void missingNavigatorAPIHack(@NonNull ActionEvent ev, final @NonNull JavaSource context, final @NullAllowed JTextComponent target) {
        Action openNavigator = (Action)FileUtil.getConfigObject((String)"Actions/Window/org-netbeans-modules-navigator-ShowNavigatorAction.instance", Action.class);
        if (openNavigator != null) {
            openNavigator.actionPerformed(ev);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorHandler.activateNavigator();
                    Collection panels = ShowMembersAction.getPanels(context);
                    NavigatorPanel cmp = null;
                    for (NavigatorPanel panel : panels) {
                        if (panel.getComponent().getClass() != ClassMemberPanelUI.class) continue;
                        cmp = panel;
                        break;
                    }
                    if (cmp != null) {
                        NavigatorHandler.activatePanel(cmp);
                        ((ClassMemberPanelUI)cmp.getComponent()).setContext(context, target);
                    }
                }
            });
        }
    }

    private static Collection<? extends NavigatorPanel> getPanels(@NonNull JavaSource context) {
        Collection files = context.getFileObjects();
        assert (files.size() == 1);
        return Lookups.forPath((String)String.format("Navigator/Panels/%s/", ((FileObject)files.iterator().next()).getMIMEType())).lookupAll(NavigatorPanel.class);
    }

    private JavaSource getContext() {
        MultiViewHandler h;
        DataObject dobj;
        FileObject fo = (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
        if (fo == null && (dobj = (DataObject)Utilities.actionsGlobalContext().lookup(DataObject.class)) != null) {
            fo = dobj.getPrimaryFile();
        }
        if (fo == null) {
            return null;
        }
        TopComponent.Registry regs = WindowManager.getDefault().getRegistry();
        TopComponent tc = regs.getActivated();
        MultiViewHandler multiViewHandler = h = tc == null ? null : MultiViews.findMultiViewHandler((TopComponent)tc);
        if (h != null && FORM_VIEW_ID.equals(h.getSelectedPerspective().preferredID())) {
            return null;
        }
        return JavaSource.forFileObject((FileObject)fo);
    }
}

