/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.stackanalyzer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.java.stackanalyzer.StackLineAnalyser;

class AnalyserCellRenderer
extends DefaultListCellRenderer {
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    private Border getNoFocusBorder() {
        Border border = UIManager.getBorder("List.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        Color bg = null;
        Color fg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            fg = UIManager.getColor("List.dropCellForeground");
            isSelected = true;
        }
        String line = (String)value;
        StackLineAnalyser.Link link = StackLineAnalyser.analyse(line);
        if (isSelected) {
            this.setBackground(bg == null ? list.getSelectionBackground() : bg);
            this.setForeground(fg == null ? list.getSelectionForeground() : fg);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (link != null) {
            String prefix;
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (isSelected) {
                sb.append("<style> a.val {text-decoration: underline; color: " + this.toRgbText(this.getForeground()) + "} </style><body>");
            }
            if ((prefix = line.substring(0, link.getStartOffset())).startsWith("at ")) {
                prefix = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + prefix;
            }
            sb.append(prefix);
            sb.append("<a class=\"val\" href=\"\">");
            sb.append(line.substring(link.getStartOffset(), link.getEndOffset()));
            sb.append("</a>");
            sb.append(line.substring(link.getEndOffset()));
            sb.append("</body></html>");
            this.setText(sb.toString());
        } else {
            this.setText(line.trim());
        }
        this.setEnabled(list.isEnabled());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = this.getNoFocusBorder();
        }
        this.setBorder(border);
        return this;
    }

    private String toRgbText(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }
}

