/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.text;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.completion.JavaCompletionTask;
import org.netbeans.modules.java.editor.base.semantic.MarkOccurrencesHighlighterBase;
import org.netbeans.modules.java.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.source.ui.ElementOpenAccessor;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.Places;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class TextDocumentServiceImpl
implements TextDocumentService,
LanguageClientAware {
    private static final RequestProcessor BACKGROUND_TASKS = new RequestProcessor(TextDocumentServiceImpl.class.getName(), 1, false, false);
    private final Map<String, Document> openedDocuments = new HashMap<String, Document>();
    private final Map<String, RequestProcessor.Task> diagnosticTasks = new HashMap<String, RequestProcessor.Task>();
    private LanguageClient client;
    private static final int DELAY = 500;
    private static final String[] ERROR_KEYS = new String[]{"errors", "hints"};

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        try {
            String uri = params.getTextDocument().getUri();
            FileObject file = TextDocumentServiceImpl.fromUri(uri);
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            int caret = TextDocumentServiceImpl.getOffset(doc, params.getPosition());
            JavaCompletionTask task = JavaCompletionTask.create((int)caret, (JavaCompletionTask.ItemFactory)new ItemFactoryImpl(), EnumSet.noneOf(JavaCompletionTask.Options.class), () -> false);
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)task);
            List result = task.getResults();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                CompletionItem item = (CompletionItem)it.next();
                if (item != null) continue;
                it.remove();
            }
            return CompletableFuture.completedFuture(Either.forRight((Object)new CompletionList(result)));
        }
        catch (IOException | ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        JavaSource js = this.getSource(params.getTextDocument().getUri());
        GoToSupport.GoToTarget[] target = new GoToSupport.GoToTarget[1];
        LineMap[] lm = new LineMap[1];
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int offset = TextDocumentServiceImpl.getOffset(doc, params.getPosition());
                GoToSupport.Context context = GoToSupport.resolveContext((CompilationInfo)cc, (Document)doc, (int)offset, (boolean)false, (boolean)false);
                if (context == null) {
                    return;
                }
                target[0] = GoToSupport.computeGoToTarget((CompilationController)cc, (GoToSupport.Context)context, (int)offset);
                lm[0] = cc.getCompilationUnit().getLineMap();
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        ArrayList<Location> result = new ArrayList<Location>();
        if (target[0] != null && target[0].success) {
            if (target[0].offsetToOpen < 0) {
                Object[] openInfo = ElementOpenAccessor.getInstance().getOpenInfo(target[0].cpInfo, target[0].elementToOpen, new AtomicBoolean());
                if (openInfo != null) {
                    FileObject file = (FileObject)openInfo[0];
                    int start = (Integer)openInfo[1];
                    int end = (Integer)openInfo[2];
                    result.add(new Location(TextDocumentServiceImpl.toUri(file), new Range(TextDocumentServiceImpl.createPosition(lm[0], start), TextDocumentServiceImpl.createPosition(lm[0], end))));
                }
            } else {
                Position pos = TextDocumentServiceImpl.createPosition((FileObject)js.getFileObjects().iterator().next(), target[0].offsetToOpen);
                result.add(new Location(params.getTextDocument().getUri(), new Range(pos, pos)));
            }
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        JavaSource js = this.getSource(params.getTextDocument().getUri());
        ArrayList result = new ArrayList();
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int offset = TextDocumentServiceImpl.getOffset(doc, params.getPosition());
                class MOHighligther
                extends MarkOccurrencesHighlighterBase {
                    MOHighligther() {
                    }

                    protected void process(CompilationInfo arg0, Document arg1, SchedulerEvent arg2) {
                        throw new UnsupportedOperationException("Should not be called.");
                    }

                    public List<int[]> processImpl(CompilationInfo info, Preferences node, Document doc, int caretPosition) {
                        return super.processImpl(info, node, doc, caretPosition);
                    }
                }
                List<int[]> spans = new MOHighligther().processImpl((CompilationInfo)cc, node, doc, offset);
                if (spans != null) {
                    for (int[] span : spans) {
                        result.add(new DocumentHighlight(new Range(TextDocumentServiceImpl.createPosition(cc.getCompilationUnit(), span[0]), TextDocumentServiceImpl.createPosition(cc.getCompilationUnit(), span[1]))));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        JavaSource js = this.getSource(params.getTextDocument().getUri());
        ArrayList result = new ArrayList();
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                for (Element tel : cc.getTopLevelElements()) {
                    DocumentSymbol ds = this.element2DocumentSymbol((CompilationInfo)cc, tel);
                    if (ds == null) continue;
                    result.add(Either.forRight((Object)ds));
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    private DocumentSymbol element2DocumentSymbol(CompilationInfo info, Element el) throws BadLocationException {
        TreePath path = info.getTrees().getPath(el);
        if (path == null) {
            return null;
        }
        long start = info.getTrees().getSourcePositions().getStartPosition(path.getCompilationUnit(), path.getLeaf());
        long end = info.getTrees().getSourcePositions().getEndPosition(path.getCompilationUnit(), path.getLeaf());
        if (end == -1L) {
            return null;
        }
        Range range = new Range(TextDocumentServiceImpl.createPosition(info.getCompilationUnit(), (int)start), TextDocumentServiceImpl.createPosition(info.getCompilationUnit(), (int)end));
        ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
        for (Element element : el.getEnclosedElements()) {
            DocumentSymbol ds = this.element2DocumentSymbol(info, element);
            if (ds == null) continue;
            children.add(ds);
        }
        return new DocumentSymbol(el.getSimpleName().toString(), TextDocumentServiceImpl.elementKind2SymbolKind(el.getKind()), range, range, null, children);
    }

    private static SymbolKind elementKind2SymbolKind(ElementKind kind) {
        switch (kind) {
            case PACKAGE: {
                return SymbolKind.Package;
            }
            case ENUM: {
                return SymbolKind.Enum;
            }
            case CLASS: {
                return SymbolKind.Class;
            }
            case ANNOTATION_TYPE: {
                return SymbolKind.Interface;
            }
            case INTERFACE: {
                return SymbolKind.Interface;
            }
            case ENUM_CONSTANT: {
                return SymbolKind.EnumMember;
            }
            case FIELD: {
                return SymbolKind.Field;
            }
            case PARAMETER: {
                return SymbolKind.Variable;
            }
            case LOCAL_VARIABLE: {
                return SymbolKind.Variable;
            }
            case EXCEPTION_PARAMETER: {
                return SymbolKind.Variable;
            }
            case METHOD: {
                return SymbolKind.Method;
            }
            case CONSTRUCTOR: {
                return SymbolKind.Constructor;
            }
            case TYPE_PARAMETER: {
                return SymbolKind.TypeParameter;
            }
            case RESOURCE_VARIABLE: {
                return SymbolKind.Variable;
            }
            case MODULE: {
                return SymbolKind.Module;
            }
        }
        return SymbolKind.File;
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        Document doc = this.openedDocuments.get(params.getTextDocument().getUri());
        if (doc == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        Map id2Errors = (Map)doc.getProperty("lsp-errors");
        if (id2Errors == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        JavaSource js = JavaSource.forDocument((Document)doc);
        ArrayList<Either> result = new ArrayList<Either>();
        for (Diagnostic diag : params.getContext().getDiagnostics()) {
            ErrorDescription err = (ErrorDescription)id2Errors.get(diag.getCode());
            if (err == null) {
                this.client.logMessage(new MessageParams(MessageType.Log, "Cannot resolve error, code: " + diag.getCode()));
                continue;
            }
            LazyFixList lfl = err.getFixes();
            if (lfl instanceof CreatorBasedLazyFixList) {
                try {
                    js.runUserActionTask(cc -> {
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        ((CreatorBasedLazyFixList)lfl).compute((CompilationInfo)cc, new AtomicBoolean());
                    }, true);
                }
                catch (IOException ex) {
                    this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                }
            }
            List fixes = lfl.getFixes();
            for (Fix f : fixes) {
                if (!(f instanceof JavaFixImpl)) continue;
                try {
                    LineMap[] lm = new LineMap[1];
                    ModificationResult changes = js.runModificationTask(wc -> {
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        HashMap resourceContentChanges = new HashMap();
                        JavaFix jf = ((JavaFixImpl)f).jf;
                        JavaFixImpl.Accessor.INSTANCE.process(jf, wc, true, resourceContentChanges, new ArrayList());
                        lm[0] = wc.getCompilationUnit().getLineMap();
                    });
                    List diffs = changes.getDifferences((FileObject)changes.getModifiedFileObjects().iterator().next());
                    ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                    for (ModificationResult.Difference diff : diffs) {
                        edits.add(new TextEdit(new Range(TextDocumentServiceImpl.createPosition(lm[0], diff.getStartPosition().getOffset()), TextDocumentServiceImpl.createPosition(lm[0], diff.getEndPosition().getOffset())), diff.getNewText()));
                    }
                    TextDocumentEdit te = new TextDocumentEdit(new VersionedTextDocumentIdentifier(params.getTextDocument().getUri(), Integer.valueOf(-1)), edits);
                    CodeAction action = new CodeAction(f.getText());
                    action.setDiagnostics(Collections.singletonList(diag));
                    action.setKind("quickfix");
                    action.setEdit(new WorkspaceEdit(Collections.singletonList(te)));
                    result.add(Either.forRight((Object)action));
                }
                catch (IOException ex) {
                    this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                }
            }
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        try {
            FileObject file = TextDocumentServiceImpl.fromUri(params.getTextDocument().getUri());
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            this.openedDocuments.put(params.getTextDocument().getUri(), doc);
            String text = params.getTextDocument().getText();
            try {
                doc.remove(0, doc.getLength());
                doc.insertString(0, text, null);
            }
            catch (BadLocationException ex) {
                this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
            }
            this.runDiagnoticTasks(params.getTextDocument().getUri());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        Document doc = this.openedDocuments.get(params.getTextDocument().getUri());
        NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
            for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
                try {
                    int start = TextDocumentServiceImpl.getOffset(doc, change.getRange().getStart());
                    int end = TextDocumentServiceImpl.getOffset(doc, change.getRange().getEnd());
                    doc.remove(start, end - start);
                    doc.insertString(start, change.getText(), null);
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        });
        this.runDiagnoticTasks(params.getTextDocument().getUri());
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.openedDocuments.remove(params.getTextDocument().getUri());
    }

    public void didSave(DidSaveTextDocumentParams arg0) {
    }

    private void runDiagnoticTasks(String uri) {
        this.diagnosticTasks.computeIfAbsent(uri, u -> BACKGROUND_TASKS.create(() -> {
            this.computeDiags((String)u, (info, doc) -> {
                ErrorHintsProvider ehp = new ErrorHintsProvider();
                return ehp.computeErrors(info, doc, "text/x-java");
            }, "errors", false);
            BACKGROUND_TASKS.create(() -> this.computeDiags((String)u, (info, doc) -> new HintsInvoker(HintsSettings.getGlobalSettings(), new AtomicBoolean()).computeHints(info), "hints", true)).schedule(500);
        })).schedule(500);
    }

    private void computeDiags(final String uri, final ProduceErrors produceErrors, final String keyPrefix, boolean update) {
        try {
            FileObject file = TextDocumentServiceImpl.fromUri(uri);
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            final StyledDocument doc = ec.openDocument();
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator it) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)it.getParserResult());
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    HashMap<String, ErrorDescription> id2Errors = new HashMap<String, ErrorDescription>();
                    ArrayList<Diagnostic> diags = new ArrayList<Diagnostic>();
                    int idx = 0;
                    List<Object> errors = produceErrors.computeErrors((CompilationInfo)cc, doc);
                    if (errors == null) {
                        errors = Collections.emptyList();
                    }
                    for (ErrorDescription err : errors) {
                        Diagnostic diag = new Diagnostic(new Range(TextDocumentServiceImpl.createPosition(cc.getCompilationUnit(), err.getRange().getBegin().getOffset()), TextDocumentServiceImpl.createPosition(cc.getCompilationUnit(), err.getRange().getEnd().getOffset())), err.getDescription());
                        switch (err.getSeverity()) {
                            case ERROR: {
                                diag.setSeverity(DiagnosticSeverity.Error);
                                break;
                            }
                            case VERIFIER: 
                            case WARNING: {
                                diag.setSeverity(DiagnosticSeverity.Warning);
                                break;
                            }
                            case HINT: {
                                diag.setSeverity(DiagnosticSeverity.Hint);
                                break;
                            }
                            default: {
                                diag.setSeverity(DiagnosticSeverity.Information);
                            }
                        }
                        String id = keyPrefix + ":" + idx + "-" + err.getId();
                        diag.setCode(id);
                        id2Errors.put(id, err);
                        diags.add(diag);
                    }
                    doc.putProperty("lsp-errors-" + keyPrefix, id2Errors);
                    doc.putProperty("lsp-errors-diags-" + keyPrefix, diags);
                    HashMap mergedId2Errors = new HashMap();
                    ArrayList mergedDiags = new ArrayList();
                    for (String k : ERROR_KEYS) {
                        List prevDiags;
                        Map prevErrors = (Map)doc.getProperty("lsp-errors-" + k);
                        if (prevErrors != null) {
                            mergedId2Errors.putAll(prevErrors);
                        }
                        if ((prevDiags = (List)doc.getProperty("lsp-errors-diags-" + k)) == null) continue;
                        mergedDiags.addAll(prevDiags);
                    }
                    doc.putProperty("lsp-errors", mergedId2Errors);
                    doc.putProperty("lsp-errors-diags", mergedDiags);
                    TextDocumentServiceImpl.this.client.publishDiagnostics(new PublishDiagnosticsParams(uri, mergedDiags));
                }
            });
        }
        catch (IOException | ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private JavaSource getSource(String fileUri) {
        Document doc = this.openedDocuments.get(fileUri);
        if (doc == null) {
            try {
                FileObject file = TextDocumentServiceImpl.fromUri(fileUri);
                return JavaSource.forFileObject((FileObject)file);
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return JavaSource.forDocument((Document)doc);
    }

    public static Position createPosition(CompilationUnitTree cut, int offset) {
        return TextDocumentServiceImpl.createPosition(cut.getLineMap(), offset);
    }

    public static Position createPosition(LineMap lm, int offset) {
        return new Position((int)lm.getLineNumber(offset) - 1, (int)lm.getColumnNumber(offset) - 1);
    }

    public static Position createPosition(FileObject file, int offset) {
        try {
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
            int column = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
            return new Position(line, column);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static int getOffset(Document doc, Position pos) {
        return LineDocumentUtils.getLineStartFromIndex((LineDocument)((LineDocument)doc), (int)pos.getLine()) + pos.getCharacter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String toUri(FileObject file) {
        Throwable throwable;
        if (!FileUtil.isArchiveArtifact((FileObject)file)) return file.toURI().toString();
        File cacheDir = Places.getCacheSubfile((String)"java-server");
        File segments = new File(cacheDir, "segments");
        Properties props = new Properties();
        try (FileInputStream in2222 = new FileInputStream(segments);){
            props.load(in2222);
        }
        catch (IOException in2222) {
            // empty catch block
        }
        FileObject archive = FileUtil.getArchiveFile((FileObject)file);
        String archiveString = archive.toURL().toString();
        File foundSegment = null;
        for (String segment : props.stringPropertyNames()) {
            if (!archiveString.equals(props.getProperty(segment))) continue;
            foundSegment = new File(cacheDir, segment);
            break;
        }
        if (foundSegment == null) {
            int i = 0;
            while (props.getProperty("s" + i) != null) {
                ++i;
            }
            foundSegment = new File(cacheDir, "s" + i);
            props.put("s" + i, archiveString);
            try {
                throwable = null;
                try (FileOutputStream in = new FileOutputStream(segments);){
                    props.store(in, "");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        File cache = new File(foundSegment, FileUtil.getRelativePath((FileObject)FileUtil.getArchiveRoot((FileObject)archive), (FileObject)file));
        cache.getParentFile().mkdirs();
        try {
            throwable = null;
            try (FileOutputStream out = new FileOutputStream(cache);){
                ((OutputStream)out).write(file.asBytes());
                String string = cache.toURI().toString();
                return string;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return file.toURI().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileObject fromUri(String uri) throws MalformedURLException {
        File cacheDir = Places.getCacheSubfile((String)"java-server");
        URI uriUri = URI.create(uri);
        URI relative = cacheDir.toURI().relativize(uriUri);
        if (relative == null) return URLMapper.findFileObject((URL)URI.create(uri).toURL());
        if (!new File(cacheDir, relative.toString()).canRead()) return URLMapper.findFileObject((URL)URI.create(uri).toURL());
        String segmentAndPath = relative.toString();
        int slash = segmentAndPath.indexOf(47);
        String segment = segmentAndPath.substring(0, slash);
        String path = segmentAndPath.substring(slash + 1);
        File segments = new File(cacheDir, "segments");
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(segments);){
            props.load(in);
            String archiveUri = props.getProperty(segment);
            FileObject archive = URLMapper.findFileObject((URL)URI.create(archiveUri).toURL());
            archive = archive != null ? FileUtil.getArchiveRoot((FileObject)archive) : null;
            FileObject file = archive != null ? archive.getFileObject(path) : null;
            if (file == null) return URLMapper.findFileObject((URL)URI.create(uri).toURL());
            FileObject fileObject = file;
            return fileObject;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return URLMapper.findFileObject((URL)URI.create(uri).toURL());
    }

    private static interface ProduceErrors {
        public List<ErrorDescription> computeErrors(CompilationInfo var1, Document var2) throws IOException;
    }

    private static class ItemFactoryImpl
    implements JavaCompletionTask.ItemFactory<CompletionItem> {
        public CompletionItem createKeywordItem(String kwd, String postfix, int substitutionOffset, boolean smartType) {
            CompletionItem item = new CompletionItem(kwd);
            item.setKind(CompletionItemKind.Keyword);
            return item;
        }

        public CompletionItem createPackageItem(String pkgFQN, int substitutionOffset, boolean inPackageStatement) {
            return null;
        }

        public CompletionItem createTypeItem(CompilationInfo info, TypeElement elem, DeclaredType type, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean insideNew, boolean addTypeVars, boolean addSimpleName, boolean smartType, boolean autoImportEnclosingType) {
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            return item;
        }

        public CompletionItem createTypeItem(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, ReferencesCount referencesCount, Source source, boolean insideNew, boolean addTypeVars, boolean afterExtends) {
            return null;
        }

        public CompletionItem createArrayItem(CompilationInfo info, ArrayType type, int substitutionOffset, ReferencesCount referencesCount, Elements elements) {
            return null;
        }

        public CompletionItem createTypeParameterItem(TypeParameterElement elem, int substitutionOffset) {
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            return item;
        }

        public CompletionItem createVariableItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean smartType, int assignToVarOffset) {
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            return item;
        }

        public CompletionItem createVariableItem(CompilationInfo info, String varName, int substitutionOffset, boolean newVarName, boolean smartType) {
            CompletionItem item = new CompletionItem(varName);
            item.setKind(CompletionItemKind.Variable);
            return item;
        }

        public CompletionItem createExecutableItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean inImport, boolean addSemicolon, boolean smartType, int assignToVarOffset, boolean memberRef) {
            TypeMirror tm;
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            StringBuilder label = new StringBuilder();
            String sep = "";
            label.append(elem.getSimpleName().toString());
            label.append("(");
            while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                label.append(sep);
                label.append(Utilities.getTypeName((CompilationInfo)info, (TypeMirror)tm, (boolean)false, (elem.isVarArgs() && !tIt.hasNext() ? 1 : 0) != 0).toString());
                label.append(' ');
                label.append(it.next().getSimpleName().toString());
                sep = ", ";
            }
            label.append(") : ");
            TypeMirror retType = type.getReturnType();
            label.append(Utilities.getTypeName((CompilationInfo)info, (TypeMirror)retType, (boolean)false).toString());
            CompletionItem item = new CompletionItem(label.toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            item.setInsertText(elem.getSimpleName().toString());
            return item;
        }

        public CompletionItem createThisOrSuperConstructorItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, String name) {
            CompletionItem item = new CompletionItem(name);
            item.setKind(CompletionItemKind.Field);
            return item;
        }

        public CompletionItem createOverrideMethodItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean implement) {
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString() + " - override");
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            return item;
        }

        public CompletionItem createGetterSetterMethodItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, String name, boolean setter) {
            return null;
        }

        public CompletionItem createDefaultConstructorItem(TypeElement elem, int substitutionOffset, boolean smartType) {
            return null;
        }

        public CompletionItem createParametersItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, int activeParamIndex, String name) {
            return null;
        }

        public CompletionItem createAnnotationItem(CompilationInfo info, TypeElement elem, DeclaredType type, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated) {
            return null;
        }

        public CompletionItem createAttributeItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated) {
            return null;
        }

        public CompletionItem createAttributeValueItem(CompilationInfo info, String value, String documentation, TypeElement element, int substitutionOffset, ReferencesCount referencesCount) {
            return null;
        }

        public CompletionItem createStaticMemberItem(CompilationInfo info, DeclaredType type, Element memberElem, TypeMirror memberType, boolean multipleVersions, int substitutionOffset, boolean isDeprecated, boolean addSemicolon) {
            return null;
        }

        public CompletionItem createStaticMemberItem(ElementHandle<TypeElement> handle, String name, int substitutionOffset, boolean addSemicolon, ReferencesCount referencesCount, Source source) {
            return null;
        }

        public CompletionItem createChainedMembersItem(CompilationInfo info, List<? extends Element> chainedElems, List<? extends TypeMirror> chainedTypes, int substitutionOffset, boolean isDeprecated, boolean addSemicolon) {
            return null;
        }

        public CompletionItem createInitializeAllConstructorItem(CompilationInfo info, boolean isDefault, Iterable<? extends VariableElement> fields, ExecutableElement superConstructor, TypeElement parent, int substitutionOffset) {
            return null;
        }

        private static CompletionItemKind elementKind2CompletionItemKind(ElementKind kind) {
            switch (kind) {
                case PACKAGE: {
                    return CompletionItemKind.Folder;
                }
                case ENUM: {
                    return CompletionItemKind.Enum;
                }
                case CLASS: {
                    return CompletionItemKind.Class;
                }
                case ANNOTATION_TYPE: {
                    return CompletionItemKind.Interface;
                }
                case INTERFACE: {
                    return CompletionItemKind.Interface;
                }
                case ENUM_CONSTANT: {
                    return CompletionItemKind.EnumMember;
                }
                case FIELD: {
                    return CompletionItemKind.Field;
                }
                case PARAMETER: {
                    return CompletionItemKind.Variable;
                }
                case LOCAL_VARIABLE: {
                    return CompletionItemKind.Variable;
                }
                case EXCEPTION_PARAMETER: {
                    return CompletionItemKind.Variable;
                }
                case METHOD: {
                    return CompletionItemKind.Method;
                }
                case CONSTRUCTOR: {
                    return CompletionItemKind.Constructor;
                }
                case TYPE_PARAMETER: {
                    return CompletionItemKind.TypeParameter;
                }
                case RESOURCE_VARIABLE: {
                    return CompletionItemKind.Variable;
                }
                case MODULE: {
                    return CompletionItemKind.Module;
                }
            }
            return CompletionItemKind.Text;
        }
    }
}

