/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ConvertVarToExplicitType {
    public static ErrorDescription convertVarToExplicitType(HintContext ctx) {
        if (!ConvertVarToExplicitType.isLocalVarType(ctx)) {
            return null;
        }
        TreePath treePath = ctx.getPath();
        if (ConvertVarToExplicitType.hasDiagnosticErrors(ctx.getInfo(), treePath.getLeaf())) {
            return null;
        }
        if (!ConvertVarToExplicitType.isValidType(ctx)) {
            return null;
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.MSG_ConvertibleToExplicitType(), (Fix[])new Fix[]{new JavaFixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    private static boolean isLocalVarType(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        if (info.getSourceVersion().compareTo(SourceVersion.RELEASE_9) < 1) {
            return false;
        }
        TreePath treePath = ctx.getPath();
        if (info.getTrees().getElement(treePath).getKind() != ElementKind.LOCAL_VARIABLE) {
            return false;
        }
        return info.getTreeUtilities().isVarType(treePath);
    }

    private static boolean hasDiagnosticErrors(CompilationInfo info, Tree tree) {
        long startPos = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree);
        long endPos = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree);
        for (Diagnostic d : info.getDiagnostics()) {
            if (d.getKind() != Diagnostic.Kind.ERROR || d.getPosition() < startPos || d.getPosition() > endPos) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidType(HintContext ctx) {
        DeclaredType dt;
        TreePath treePath = ctx.getPath();
        TypeMirror variableTypeMirror = ctx.getInfo().getTrees().getElement(treePath).asType();
        if (Utilities.isAnonymousType(variableTypeMirror)) {
            return false;
        }
        if (variableTypeMirror.getKind() == TypeKind.DECLARED && (dt = (DeclaredType)variableTypeMirror).getTypeArguments().size() > 0) {
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                if (!Utilities.isAnonymousType(typeMirror)) continue;
                return false;
            }
        }
        return Utilities.isValidType(variableTypeMirror) && variableTypeMirror.getKind() != TypeKind.INTERSECTION;
    }

    private static final class JavaFixImpl
    extends JavaFix {
        public JavaFixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_convertVarToExplicitType();
        }

        protected void performRewrite(JavaFix.TransformationContext tc) throws Exception {
            WorkingCopy wc = tc.getWorkingCopy();
            CompilationUnitTree cut = wc.getCompilationUnit();
            TreePath statementPath = tc.getPath();
            TreeMaker make = wc.getTreeMaker();
            if (statementPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                VariableTree oldVariableTree = (VariableTree)statementPath.getLeaf();
                TypeMirror type = wc.getTrees().getTypeMirror(statementPath);
                VariableTree newVariableTree = make.Variable(oldVariableTree.getModifiers(), (CharSequence)oldVariableTree.getName(), make.Type(type), oldVariableTree.getInitializer());
                wc.rewrite((Tree)oldVariableTree, (Tree)newVariableTree);
            }
        }
    }
}

