/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.hints.OrganizeImports;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.preprocessorbridge.spi.ImportProcessor;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ImportClass
implements ErrorRule<Void> {
    static RequestProcessor WORKER = new RequestProcessor("ImportClassEnabler", 1);
    private boolean cancelled;
    private ComputeImports compImports;

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.doesnt.exist", "compiler.err.not.stmt", "compiler.err.not.def.public.cant.access", "compiler.err.expected"));
    }

    /*
     * WARNING - void declaration
     */
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        String simpleName;
        ComputeImports imps;
        this.resume();
        int errorPosition = offset;
        boolean expectedErr = "compiler.err.expected".equals(diagnosticKey);
        if (!expectedErr) {
            ++errorPosition;
        }
        if (!ErrorFixesFakeHint.enabled(info.getFileObject(), ErrorFixesFakeHint.FixKind.IMPORT_CLASS)) {
            return Collections.emptyList();
        }
        if (errorPosition == -1) {
            ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create errorPosition=-1");
            return Collections.emptyList();
        }
        TreePath path = info.getTreeUtilities().pathFor(errorPosition);
        Token ident = null;
        try {
            TokenHierarchy th;
            TokenSequence ts;
            ident = ErrorHintsProvider.findUnresolvedElementToken(info, offset);
            if (ident == null && expectedErr && (ts = (th = info.getTokenHierarchy()).tokenSequence(JavaTokenId.language())) != null) {
                Token check;
                ts.move(offset);
                if (ts.movePrevious() && (check = ts.token()).id() == JavaTokenId.DOT) {
                    boolean hasToken = false;
                    while ((hasToken = ts.movePrevious()) && ts.token().id() == JavaTokenId.WHITESPACE) {
                    }
                    if (hasToken && ts.token().id() == JavaTokenId.IDENTIFIER) {
                        ident = ts.token();
                    }
                }
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create ident={0}", ident);
        if (ident == null) {
            return Collections.emptyList();
        }
        FileObject file = info.getFileObject();
        boolean useFQN = false;
        if (file != null) {
            CodeStyle cs = CodeStyle.getDefault((FileObject)file);
            useFQN = cs.useFQNs();
        }
        if ((imps = this.getCandidateFQNs(info, file, simpleName = ident.text().toString(), data)) == null) {
            return Collections.emptyList();
        }
        List cands = imps.getCandidates(simpleName);
        List<? extends ImportTree> imports = info.getCompilationUnit().getImports();
        for (ImportTree importTree : imports) {
            List a;
            Element el = info.getTrees().getElement(new TreePath(new TreePath(new TreePath(info.getCompilationUnit()), importTree), importTree.getQualifiedIdentifier()));
            if (el == null || cands == null || (a = cands) == null || !a.contains(el)) continue;
            return Collections.emptyList();
        }
        if (this.isCancelled()) {
            ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancelled.");
            return CreatorBasedLazyFixList.CANCELLED;
        }
        String replaceSuffix = null;
        Object var17_21 = null;
        if (useFQN) {
            TreePath treePath2 = path;
            replaceSuffix = "";
        } else if (path.getLeaf().getKind() == Tree.Kind.IMPORT) {
            MemberSelectTree mst;
            Tree star = ((ImportTree)path.getLeaf()).getQualifiedIdentifier();
            if (star.getKind() == Tree.Kind.MEMBER_SELECT && (mst = (MemberSelectTree)star).getIdentifier().contentEquals("*")) {
                replaceSuffix = ".*";
                TreePath treePath3 = new TreePath(new TreePath(path, star), mst.getExpression());
            }
        } else {
            TreePath imp;
            StringBuilder replaceSuffixBuilder = new StringBuilder();
            for (imp = path.getParentPath(); imp != null && imp.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT; imp = imp.getParentPath()) {
                replaceSuffixBuilder.append(".");
                replaceSuffixBuilder.append(((MemberSelectTree)imp.getLeaf()).getIdentifier());
            }
            if (imp != null && imp.getLeaf().getKind() == Tree.Kind.IMPORT) {
                replaceSuffix = replaceSuffixBuilder.toString();
                TreePath treePath4 = path;
            }
        }
        Preferences prefs = ErrorFixesFakeHint.getPreferences(info.getFileObject(), ErrorFixesFakeHint.FixKind.IMPORT_CLASS);
        boolean doOrganize = ErrorFixesFakeHint.isOrganizeAfterImportClass(prefs);
        List filtered = cands;
        List unfiltered = imps.getRawCandidates(simpleName);
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        if (unfiltered != null && filtered != null) {
            ReferencesCount referencesCount = ReferencesCount.get((ClasspathInfo)info.getClasspathInfo());
            HashSet<String> uniq = new HashSet<String>();
            for (Element element : unfiltered) {
                void var17_26;
                String fqn = imps.displayNameForImport(element);
                if (!uniq.add(fqn) || org.netbeans.modules.java.completion.Utilities.isExcluded((CharSequence)fqn)) continue;
                StringBuilder sort = new StringBuilder();
                sort.append("0001#");
                boolean prefered = filtered.contains(element);
                if (prefered) {
                    sort.append("A#");
                } else {
                    sort.append("Z#");
                }
                int order = org.netbeans.modules.editor.java.Utilities.getImportanceLevel((CompilationInfo)info, (ReferencesCount)referencesCount, (Element)element);
                String orderString = Integer.toHexString(order);
                sort.append("00000000".substring(0, 8 - orderString.length()));
                sort.append(orderString);
                sort.append('#');
                sort.append(fqn);
                ElementHandle eh = ElementHandle.create((Element)element);
                if (useFQN) {
                    fixes.add((Fix)new UseFQN(info, file, fqn, (ElementHandle<Element>)eh, "Z#" + fqn, treePath, prefered, false));
                    fixes.add((Fix)UseFQN.createShared(info, file, fqn, (ElementHandle<Element>)eh, fqn, treePath, prefered));
                    continue;
                }
                fixes.add((Fix)new FixImport(file, fqn, (ElementHandle<Element>)eh, sort.toString(), prefered, info, (TreePath)var17_26, replaceSuffix, doOrganize));
            }
        }
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create finished.");
        return fixes;
    }

    public synchronized void cancel() {
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancel called.");
        this.cancelled = true;
        if (this.compImports != null) {
            this.compImports.cancel();
        }
    }

    public String getId() {
        return ImportClass.class.getName();
    }

    public String getDisplayName() {
        return "Add Import Fix";
    }

    public String getDescription() {
        return "Add Import Fix";
    }

    private synchronized void resume() {
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.resume called.");
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void setComputeImports(ComputeImports compImports) {
        this.compImports = compImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputeImports getCandidateFQNs(CompilationInfo info, FileObject file, String simpleName, ErrorRule.Data<Void> data) {
        ComputeImports imp = new ComputeImports(info);
        this.setComputeImports(imp);
        try {
            imp = imp.computeCandidatesEx();
        }
        finally {
            this.setComputeImports(null);
        }
        if (this.isCancelled()) {
            ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.getCandidateFQNs cancelled, returning.");
            return null;
        }
        return imp;
    }

    static final class UseFQN
    extends FixBase {
        private final boolean all;
        private final TreePathHandle replacePathHandle;
        private final Collection<TreePathHandle> additionalLocations = new ArrayList<TreePathHandle>();
        private final String sn;

        static UseFQN createShared(CompilationInfo info, FileObject file, String fqn, ElementHandle<Element> toImport, String sortText, TreePath replacePath, boolean isValid) {
            UseFQN inst;
            String k = UseFQN.class.getName() + "#" + fqn;
            Object o = info.getCachedValue((Object)k);
            if (o instanceof UseFQN) {
                inst = (UseFQN)o;
                inst.addTreePath(TreePathHandle.create((TreePath)replacePath, (CompilationInfo)info));
            } else {
                inst = new UseFQN(info, file, fqn, toImport, sortText, replacePath, isValid, true);
                info.putCachedValue((Object)k, (Object)inst, CompilationInfo.CacheClearPolicy.ON_TASK_END);
            }
            return inst;
        }

        public UseFQN(CompilationInfo info, FileObject file, String fqn, ElementHandle<Element> toImport, String sortText, TreePath replacePath, boolean isValid, boolean all) {
            super(file, fqn, toImport, sortText, isValid);
            this.sn = replacePath.getLeaf().toString();
            this.replacePathHandle = TreePathHandle.create((TreePath)replacePath, (CompilationInfo)info);
            this.all = all;
        }

        void addTreePath(TreePathHandle toReplace) {
            this.additionalLocations.add(toReplace);
        }

        @Override
        protected boolean perform() {
            TreePath replacePath = this.replacePathHandle.resolve((CompilationInfo)this.copy);
            if (replacePath == null) {
                Logger.getAnonymousLogger().warning(String.format("Attempt to change import for FQN: %s, but the import cannot be resolved in the current context", this.fqn));
                return false;
            }
            Element el = this.toImport.resolve((CompilationInfo)this.copy);
            if (el == null) {
                return false;
            }
            CharSequence elFQN = this.copy.getElementUtilities().getElementName(el, true);
            IdentifierTree id = this.copy.getTreeMaker().Identifier(elFQN);
            this.copy.rewrite(replacePath.getLeaf(), (Tree)id);
            for (TreePathHandle tph : this.additionalLocations) {
                replacePath = tph.resolve((CompilationInfo)this.copy);
                if (replacePath == null) continue;
                this.copy.rewrite(replacePath.getLeaf(), (Tree)id);
            }
            return false;
        }

        @Override
        protected void performDoc(Document doc) {
        }

        public String getText() {
            String displayName;
            String string = displayName = this.all ? NbBundle.getMessage(ImportClass.class, (String)"Use_FQN_for_All_X", (Object)this.fqn, (Object)this.sn) : NbBundle.getMessage(ImportClass.class, (String)"Use_FQN_for_X", (Object)this.fqn);
            if (this.isValid) {
                return displayName;
            }
            return JavaFixAllImports.NOT_VALID_IMPORT_HTML + displayName;
        }

        @Override
        public boolean equals(Object o) {
            boolean x = super.equals(o);
            if (x) {
                x = ((UseFQN)o).all == this.all;
            }
            return x;
        }
    }

    public static final class FixImport
    extends FixBase {
        @NullAllowed
        private final TreePathHandle replacePathHandle;
        @NullAllowed
        private final String suffix;
        private final boolean statik;
        private final boolean doOrganize;
        String requiresModName;
        boolean moduleAdded;
        int round;

        public FixImport(FileObject file, String fqn, ElementHandle<Element> toImport, String sortText, boolean isValid, CompilationInfo info, @NullAllowed TreePath replacePath, @NullAllowed String replaceSuffix, boolean doOrganize) {
            super(file, fqn, toImport, sortText, isValid);
            if (replacePath != null) {
                this.replacePathHandle = TreePathHandle.create((TreePath)replacePath, (CompilationInfo)info);
                this.suffix = replaceSuffix;
                while (replacePath != null && replacePath.getLeaf().getKind() != Tree.Kind.IMPORT) {
                    replacePath = replacePath.getParentPath();
                }
                this.statik = replacePath != null ? ((ImportTree)replacePath.getLeaf()).isStatic() : false;
            } else {
                this.replacePathHandle = null;
                this.suffix = null;
                this.statik = false;
            }
            this.doOrganize = doOrganize;
        }

        public String getText() {
            String displayName;
            String string = this.replacePathHandle == null ? NbBundle.getMessage(ImportClass.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn}) : (displayName = Bundle.Change_to_import_X(this.fqn + this.suffix, this.statik ? "static " : ""));
            if (this.isValid) {
                return displayName;
            }
            return JavaFixAllImports.NOT_VALID_IMPORT_HTML + displayName;
        }

        @Override
        protected void performDoc(Document doc) {
            String topLevelLanguageMIMEType;
            String string = topLevelLanguageMIMEType = doc != null ? NbEditorUtilities.getMimeType((Document)doc) : null;
            if (topLevelLanguageMIMEType != null) {
                Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)topLevelLanguageMIMEType));
                Collection instances = lookup.lookupAll(ImportProcessor.class);
                for (ImportProcessor importsProcesor : instances) {
                    importsProcesor.addImport(doc, this.fqn);
                }
            }
        }

        @Override
        protected boolean perform() {
            FileObject modInfo;
            ++this.round;
            if (this.replacePathHandle != null) {
                TreePath replacePath = this.replacePathHandle.resolve((CompilationInfo)this.copy);
                if (replacePath == null) {
                    Logger.getAnonymousLogger().warning(String.format("Attempt to change import for FQN: %s, but the import cannot be resolved in the current context", this.fqn));
                    return false;
                }
                this.copy.rewrite(replacePath.getLeaf(), (Tree)this.copy.getTreeMaker().Identifier((CharSequence)this.fqn));
                return false;
            }
            Element te = this.toImport.resolve((CompilationInfo)this.copy);
            JavaSource modInfoSrc = null;
            if (te == null && this.round < 2 && (modInfo = Utilities.getModuleInfo((CompilationInfo)this.copy)) != null) {
                ClasspathInfo cpInfo = this.copy.getClasspathInfo();
                final ClasspathInfo extraInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT)}), (ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_CLASS)}), (ClassPath)cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
                modInfoSrc = JavaSource.create((ClasspathInfo)extraInfo, (FileObject[])new FileObject[]{modInfo});
                try {
                    modInfoSrc.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController parameter) throws Exception {
                            parameter.toPhase(JavaSource.Phase.RESOLVED);
                            Element x = toImport.resolve((CompilationInfo)parameter);
                            if (x == null) {
                                return;
                            }
                            while (x.getEnclosingElement() != null && x.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                                x = x.getEnclosingElement();
                            }
                            if (x == null || !x.getKind().isClass() && !x.getKind().isInterface()) {
                                return;
                            }
                            TypeElement tel = (TypeElement)x;
                            String res = tel.getQualifiedName().toString().replace('.', '/');
                            ClassPath compPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{extraInfo.getClassPath(ClasspathInfo.PathKind.BOOT), extraInfo.getClassPath(ClasspathInfo.PathKind.COMPILE)});
                            FileObject f = compPath.findResource(res + ".class");
                            if (f == null) {
                                return;
                            }
                            FileObject rf = compPath.findOwnerRoot(f);
                            URL u = URLMapper.findURL((FileObject)rf, (int)0);
                            if (u == null) {
                                return;
                            }
                            requiresModName = SourceUtils.getModuleName((URL)u);
                        }
                    }, true);
                    if (this.requiresModName == null) {
                        Logger.getAnonymousLogger().warning(String.format("Attempt to fix import for FQN: %s, which does not have a TypeElement in currect context", this.fqn));
                        return false;
                    }
                    HashSet<String> modules = new HashSet<String>();
                    modules.add(this.requiresModName);
                    this.addRequiredModules(modInfo, modInfoSrc, modules);
                    if (this.moduleAdded) {
                        te = this.toImport.resolve((CompilationInfo)this.copy);
                        return true;
                    }
                    Logger.getAnonymousLogger().warning(String.format("Could not add module %s for fqn %s", this.requiresModName, this.fqn));
                    return false;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (te == null) {
                Logger.getAnonymousLogger().warning(String.format("Attempt to fix import for FQN: %s, which does not have a TypeElement in currect context", this.fqn));
                return false;
            }
            if (this.doOrganize) {
                OrganizeImports.doOrganizeImports(this.copy, Collections.singleton(te), false);
            } else {
                CompilationUnitTree cut = GeneratorUtilities.get((WorkingCopy)this.copy).addImports(this.copy.getCompilationUnit(), Collections.singleton(te));
                this.copy.rewrite((Tree)this.copy.getCompilationUnit(), (Tree)cut);
            }
            return false;
        }

        private void addRequiredModules(FileObject fo, JavaSource js, Set<String> moduleNames) throws IOException {
            js.runModificationTask(wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree cu = wc.getCompilationUnit();
                final HashSet knownModules = new HashSet();
                final ModuleTree[] module = new ModuleTree[1];
                final RequiresTree[] lastRequires = new RequiresTree[1];
                cu.accept(new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitModule(ModuleTree m, Void p) {
                        module[0] = m;
                        return (Void)super.visitModule(m, p);
                    }

                    @Override
                    public Void visitRequires(RequiresTree r, Void p) {
                        lastRequires[0] = r;
                        knownModules.add(r.getModuleName().toString());
                        return (Void)super.visitRequires(r, p);
                    }
                }, null);
                if (module[0] != null) {
                    moduleNames.removeAll(knownModules);
                    this.moduleAdded = !moduleNames.isEmpty();
                    TreeMaker tm = wc.getTreeMaker();
                    List newRequires = moduleNames.stream().map(name -> tm.Requires(false, false, tm.QualIdent(name))).collect(Collectors.toList());
                    ArrayList<Object> newDirectives = new ArrayList<Object>(module[0].getDirectives().size() + newRequires.size());
                    if (lastRequires[0] == null) {
                        newDirectives.addAll(newRequires);
                    }
                    for (DirectiveTree directiveTree : module[0].getDirectives()) {
                        newDirectives.add(directiveTree);
                        if (directiveTree != lastRequires[0]) continue;
                        newDirectives.addAll(newRequires);
                    }
                    ModuleTree newModule = tm.Module(tm.Modifiers(0L, module[0].getAnnotations()), module[0].getModuleType(), module[0].getName(), newDirectives);
                    wc.rewrite((Tree)module[0], (Tree)newModule);
                }
            }).commit();
            SaveCookie s = (SaveCookie)fo.getLookup().lookup(SaveCookie.class);
            if (s != null) {
                s.save();
            }
        }

        public ElementHandle<Element> getToImport() {
            return this.toImport;
        }
    }

    static abstract class FixBase
    implements EnhancedFix {
        static final Logger LOG = Logger.getLogger(FixImport.class.getName());
        protected final String fqn;
        protected final ElementHandle<Element> toImport;
        protected final boolean isValid;
        private final FileObject file;
        private final String sortText;
        protected WorkingCopy copy;
        private boolean needsChange;

        private FixBase(FileObject file, String fqn, ElementHandle<Element> toImport, String sortText, boolean isValid) {
            this.isValid = isValid;
            this.file = file;
            this.fqn = fqn;
            this.toImport = toImport;
            this.sortText = sortText;
        }

        protected abstract boolean perform();

        protected abstract void performDoc(Document var1);

        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            Task<WorkingCopy> task = new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    if (copy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    copy = copy;
                    try {
                        needsChange = false;
                        needsChange = this.perform();
                    }
                    finally {
                        copy = null;
                    }
                }
            };
            if (js != null) {
                do {
                    js.runModificationTask((Task)task).commit();
                } while (this.needsChange);
            } else {
                StyledDocument doc;
                DataObject od;
                try {
                    od = DataObject.find((FileObject)this.file);
                }
                catch (DataObjectNotFoundException donfe) {
                    LOG.log(Level.INFO, null, donfe);
                    StatusDisplayer.getDefault().setStatusText(Bundle.WRN_FileInvalid());
                    return null;
                }
                EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
                StyledDocument styledDocument = doc = ec != null ? ec.openDocument() : null;
                if (doc != null) {
                    this.performDoc(doc);
                }
            }
            return null;
        }

        public int hashCode() {
            return this.fqn.hashCode();
        }

        public boolean equals(Object o) {
            if (this.getClass().isInstance(o)) {
                return this.fqn.equals(((FixBase)o).fqn);
            }
            return false;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }
    }
}

