/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreeScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.java.hints.HintContext;

public class Flow {
    private static final Object KEY_FLOW = new Object();
    private static final Set<ElementKind> SUPPORTED_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.FIELD);
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
    private static final State UNASSIGNED = State.create(null, false);

    public static FlowResult assignmentsForUse(CompilationInfo info, AtomicBoolean cancel) {
        return Flow.assignmentsForUse(info, new AtomicBooleanCancel(cancel));
    }

    public static FlowResult assignmentsForUse(CompilationInfo info, TreePath from, AtomicBoolean cancel) {
        return Flow.assignmentsForUse(info, from, new AtomicBooleanCancel(cancel));
    }

    public static FlowResult assignmentsForUse(final HintContext ctx) {
        return Flow.assignmentsForUse(ctx.getInfo(), new Cancel(){

            @Override
            public boolean isCanceled() {
                return ctx.isCanceled();
            }
        });
    }

    public static FlowResult assignmentsForUse(CompilationInfo info, Cancel cancel) {
        FlowResult result = (FlowResult)info.getCachedValue(KEY_FLOW);
        if (result == null && (result = Flow.assignmentsForUse(info, new TreePath(info.getCompilationUnit()), cancel)) != null && !cancel.isCanceled()) {
            info.putCachedValue(KEY_FLOW, (Object)result, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        }
        return result;
    }

    public static FlowResult assignmentsForUse(CompilationInfo info, TreePath from, Cancel cancel) {
        VisitorImpl v = new VisitorImpl(info, null, cancel);
        v.scan(from, null);
        if (cancel.isCanceled()) {
            return null;
        }
        return new FlowResult(v);
    }

    public static boolean definitellyAssigned(CompilationInfo info, VariableElement var, Iterable<? extends TreePath> trees, AtomicBoolean cancel) {
        return Flow.definitellyAssigned(info, var, trees, new AtomicBooleanCancel(cancel));
    }

    public static boolean unknownSymbolFinalCandidate(CompilationInfo info, Element var, TypeElement scope, Iterable<? extends TreePath> trees, AtomicBoolean cancel) {
        return Flow.definitellyAssignedImpl(info, var, scope, trees, false, new AtomicBooleanCancel(cancel));
    }

    private static boolean definitellyAssignedImpl(CompilationInfo info, Element var, TypeElement scope, Iterable<? extends TreePath> trees, boolean reassignAllowed, Cancel cancel) {
        VisitorImpl v = new VisitorImpl(info, scope, cancel);
        if (scope != null) {
            v.canonicalUndefined(var);
        }
        v.variable2State.put(var, State.create(null, false));
        for (TreePath treePath : trees) {
            if (cancel.isCanceled()) {
                return false;
            }
            v.scan(treePath, null);
            for (TreePath toResume = treePath; toResume != null; toResume = toResume.getParentPath()) {
                v.resume(toResume.getLeaf(), v.resumeAfter);
            }
            State s = (State)v.variable2State.get(var);
            if (s == null) {
                s = (State)v.variable2StateFinal.get(var);
            }
            if (s == null || s.assignments.contains(null)) continue;
            return reassignAllowed || !s.reassigned;
        }
        return false;
    }

    public static boolean definitellyAssigned(CompilationInfo info, VariableElement var, Iterable<? extends TreePath> trees, Cancel cancel) {
        return Flow.definitellyAssignedImpl(info, var, null, trees, true, cancel);
    }

    private static final class ReluctantSet<T>
    implements Set<T> {
        private final Set<T> included = new HashSet<T>();
        private final Set<Object> removed = new HashSet<Object>();

        private ReluctantSet() {
        }

        @Override
        public int size() {
            return this.included.size();
        }

        @Override
        public boolean isEmpty() {
            return this.included.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.included.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.synchronizedSet(this.included).iterator();
        }

        @Override
        public Object[] toArray() {
            return this.included.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.included.toArray(a);
        }

        @Override
        public boolean add(T e) {
            if (this.removed.contains(e)) {
                return false;
            }
            return this.included.add(e);
        }

        @Override
        public boolean remove(Object o) {
            this.removed.add(o);
            return this.included.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.included.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean result = false;
            for (T t : c) {
                result |= this.add(t);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.included.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            for (Object o : c) {
                result |= this.remove(o);
            }
            return result;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class ConstructorData {
        final boolean first;
        final List<Tree> initializers;

        public ConstructorData(boolean first, List<Tree> initializers) {
            this.first = first;
            this.initializers = initializers;
        }
    }

    static class State {
        private final Set<TreePath> assignments;
        private final boolean reassigned;

        private State(Set<TreePath> assignments, boolean reassigned) {
            this.assignments = assignments;
            this.reassigned = reassigned;
        }

        public static State create(TreePath assignment, boolean reassigned) {
            return new State(Collections.singleton(assignment), reassigned);
        }

        public static State create(TreePath assignment, State previous) {
            return new State(Collections.singleton(assignment), previous != null && (previous.assignments.size() > 1 || !previous.assignments.contains(null)));
        }

        public State merge(State value) {
            HashSet<TreePath> assignments = new HashSet<TreePath>(this.assignments);
            assignments.addAll(value.assignments);
            return new State(assignments, this.reassigned || value.reassigned);
        }

        public boolean hasUnassigned() {
            return this.assignments.contains(null);
        }
    }

    private static final class VisitorImpl
    extends CancellableTreeScanner<Boolean, ConstructorData> {
        private final CompilationInfo info;
        private final TypeElement undefinedSymbolScope;
        private final Name thisName;
        private Map<Name, Element> undefinedVariables = new HashMap<Name, Element>();
        private Map<Element, State> variable2State = new HashMap<Element, State>();
        private Map<Element, State> variable2StateFinal = new HashMap<Element, State>();
        private Map<Tree, State> use2Values = new IdentityHashMap<Tree, State>();
        private Map<Tree, Collection<Map<Element, State>>> resumeBefore = new IdentityHashMap<Tree, Collection<Map<Element, State>>>();
        private Map<Tree, Collection<Map<Element, State>>> resumeAfter = new IdentityHashMap<Tree, Collection<Map<Element, State>>>();
        private Map<TypeMirror, Map<Element, State>> resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Map<Element, State>>();
        private boolean inParameters;
        private Tree nearestMethod;
        private Set<Element> currentMethodVariables = Collections.newSetFromMap(new IdentityHashMap());
        private final Set<Tree> deadBranches = new HashSet<Tree>();
        private final List<TreePath> pendingFinally = new LinkedList<TreePath>();
        private final Cancel cancel;
        private boolean doNotRecord;
        private Set<Element> finalCandidates = new ReluctantSet<Element>();
        private final Set<Element> usedWhileUndefined = new HashSet<Element>();
        private final Map<Element, Collection<Element>> finalFieldConstructors = new HashMap<Element, Collection<Element>>();
        private TypeElement referenceTarget;
        private boolean lValueDereference;
        private final TypeElement throwableEl;
        private final TypeMirror runtimeExceptionType;
        private final TypeMirror errorType;
        private final Map<Tree, Collection<Element>> scopedVariables = new IdentityHashMap<Tree, Collection<Element>>();
        private TreePath currentPath;

        public VisitorImpl(CompilationInfo info, TypeElement undefinedSymbolScope, Cancel cancel) {
            this.info = info;
            this.cancel = cancel;
            this.undefinedSymbolScope = undefinedSymbolScope;
            this.thisName = info.getElements().getName("this");
            this.throwableEl = info.getElements().getTypeElement("java.lang.Throwable");
            TypeElement tel = info.getElements().getTypeElement("java.lang.RuntimeException");
            this.runtimeExceptionType = tel != null ? tel.asType() : null;
            tel = info.getElements().getTypeElement("java.lang.Error");
            this.errorType = tel != null ? tel.asType() : null;
        }

        protected boolean isCanceled() {
            return this.cancel.isCanceled();
        }

        public TreePath getCurrentPath() {
            return this.currentPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean scan(TreePath path, ConstructorData p) {
            TreePath oldPath = this.currentPath;
            try {
                this.currentPath = path;
                Boolean bl = (Boolean)super.scan(path.getLeaf(), (Object)p);
                return bl;
            }
            finally {
                this.currentPath = oldPath;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean scan(Tree tree, ConstructorData p) {
            Boolean result;
            this.resume(tree, this.resumeBefore);
            if (tree != null) {
                TreePath oldPath = this.currentPath;
                try {
                    this.currentPath = new TreePath(this.currentPath, tree);
                    result = (Boolean)super.scan(tree, (Object)p);
                }
                finally {
                    this.currentPath = oldPath;
                }
            } else {
                result = null;
            }
            this.resume(tree, this.resumeAfter);
            Collection<Element> varsOutScope = this.scopedVariables.get(tree);
            if (varsOutScope != null) {
                for (Element ve : varsOutScope) {
                    State s = this.variable2State.get(ve);
                    if (s == null) continue;
                    this.variable2StateFinal.put(ve, s);
                }
                this.variable2State.keySet().removeAll(varsOutScope);
            }
            return result;
        }

        private void resume(Tree tree, Map<Tree, Collection<Map<Element, State>>> resume) {
            Collection<Map<Element, State>> toResume = resume.remove(tree);
            if (toResume != null) {
                for (Map<Element, State> s : toResume) {
                    this.variable2State = this.mergeOr(this.variable2State, s);
                }
            }
        }

        public Boolean visitAssignment(AssignmentTree node, ConstructorData p) {
            TypeElement oldQName = this.referenceTarget;
            this.referenceTarget = null;
            this.lValueDereference = true;
            this.scan((Tree)node.getVariable(), null);
            this.lValueDereference = false;
            Boolean constVal = this.scan((Tree)node.getExpression(), p);
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
            if (e != null) {
                if (SUPPORTED_VARIABLES.contains((Object)e.getKind())) {
                    this.recordVariableState(e, new TreePath(this.getCurrentPath(), node.getExpression()));
                } else if (this.shouldProcessUndefined(e)) {
                    Element cv = this.canonicalUndefined(e);
                    this.recordVariableState(e, new TreePath(this.getCurrentPath(), node.getExpression()));
                }
            }
            this.referenceTarget = oldQName;
            return constVal;
        }

        private void recordVariableState(Element ve, TreePath tp) {
            State prevState = this.variable2State.get(ve);
            this.variable2State.put(ve, State.create(tp, prevState));
        }

        private Element canonicalUndefined(Element e) {
            Name n = e.getSimpleName();
            Element prev = this.undefinedVariables.get(n);
            if (prev != null) {
                return prev;
            }
            this.undefinedVariables.put(n, e);
            return e;
        }

        private boolean isUndefinedVariable(Element e) {
            Name n = e.getSimpleName();
            return this.undefinedVariables.containsKey(n);
        }

        private boolean shouldProcessUndefined(Element e) {
            if (e == null || this.undefinedSymbolScope == null || e.asType().getKind() != TypeKind.ERROR) {
                return false;
            }
            if (e.getKind() == ElementKind.CLASS) {
                return this.referenceTarget == null || this.referenceTarget == this.undefinedSymbolScope;
            }
            return false;
        }

        private void addUse2Values(Tree place, State prevState) {
            State s = this.use2Values.get(place);
            if (s == null) {
                this.use2Values.put(place, prevState);
            } else {
                this.use2Values.put(place, s.merge(prevState));
            }
        }

        public Boolean visitCompoundAssignment(CompoundAssignmentTree node, ConstructorData p) {
            TypeElement oldQName = this.referenceTarget;
            this.referenceTarget = null;
            this.lValueDereference = true;
            this.scan((Tree)node.getVariable(), null);
            this.lValueDereference = false;
            Boolean constVal = this.scan((Tree)node.getExpression(), p);
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
            if (e != null) {
                if (SUPPORTED_VARIABLES.contains((Object)e.getKind())) {
                    VariableElement ve = (VariableElement)e;
                    State prevState = this.variable2State.get(ve);
                    if (LOCAL_VARIABLES.contains((Object)e.getKind())) {
                        this.addUse2Values(node.getVariable(), prevState);
                    } else if (e.getKind() == ElementKind.FIELD && prevState != null && prevState.hasUnassigned() && !this.finalCandidates.contains(ve)) {
                        this.usedWhileUndefined.add(ve);
                    }
                    this.recordVariableState(ve, this.getCurrentPath());
                } else if (this.shouldProcessUndefined(e)) {
                    Element cv = this.canonicalUndefined(e);
                    this.recordVariableState(cv, this.getCurrentPath());
                }
            }
            this.referenceTarget = oldQName;
            boolean retain = false;
            switch (node.getKind()) {
                case OR_ASSIGNMENT: {
                    retain = constVal == Boolean.TRUE;
                    break;
                }
                case AND_ASSIGNMENT: {
                    retain = constVal == Boolean.FALSE;
                }
            }
            return retain ? constVal : null;
        }

        private void addScopedVariable(Tree t, Element ve) {
            Collection<Element> c = this.scopedVariables.get(t);
            if (c == null) {
                c = new ArrayList<Element>(3);
                this.scopedVariables.put(t, c);
            }
            c.add(ve);
        }

        public Boolean visitVariable(VariableTree node, ConstructorData p) {
            super.visitVariable(node, (Object)p);
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && SUPPORTED_VARIABLES.contains((Object)e.getKind())) {
                TreePath tp = node.getInitializer() != null ? new TreePath(this.getCurrentPath(), node.getInitializer()) : (this.inParameters ? this.getCurrentPath() : null);
                this.recordVariableState(e, tp);
                this.currentMethodVariables.add(e);
                TreePath pp = this.getCurrentPath().getParentPath();
                if (pp != null) {
                    this.addScopedVariable(pp.getLeaf(), e);
                }
            }
            return null;
        }

        public Boolean visitMemberSelect(MemberSelectTree node, ConstructorData p) {
            boolean lVal = this.lValueDereference;
            if (node.getExpression().getKind() != Tree.Kind.MEMBER_SELECT) {
                this.lValueDereference = false;
            }
            if (lVal) {
                this.referenceTarget = null;
            }
            super.visitMemberSelect(node, (Object)p);
            this.lValueDereference = lVal;
            if (lVal && this.referenceTarget == null) {
                Element e = null;
                if (node.getIdentifier() == this.thisName) {
                    e = this.info.getTrees().getElement(this.getCurrentPath());
                } else if (node.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                    e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
                    if (((IdentifierTree)node.getExpression()).getName() == this.thisName && e != null) {
                        e = e.getEnclosingElement();
                    }
                }
                if (e != null && (e.getKind().isClass() || e.getKind().isInterface())) {
                    this.referenceTarget = (TypeElement)e;
                }
            }
            this.handleCurrentAccess();
            return null;
        }

        private void handleCurrentAccess() {
            if (this.lValueDereference) {
                return;
            }
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && SUPPORTED_VARIABLES.contains((Object)e.getKind())) {
                VariableElement ve = (VariableElement)e;
                State prevState = this.variable2State.get(ve);
                if (LOCAL_VARIABLES.contains((Object)e.getKind())) {
                    this.addUse2Values(this.getCurrentPath().getLeaf(), prevState);
                } else if (e.getKind() == ElementKind.FIELD && (prevState == null || prevState.hasUnassigned()) && !this.finalCandidates.contains(ve)) {
                    this.usedWhileUndefined.add(ve);
                }
            }
        }

        public Boolean visitLiteral(LiteralTree node, ConstructorData p) {
            Object val = node.getValue();
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return null;
        }

        public Boolean visitIf(IfTree node, ConstructorData p) {
            this.generalizedIf(node.getCondition(), node.getThenStatement(), node.getElseStatement() != null ? Collections.singletonList(node.getElseStatement()) : Collections.emptyList(), true);
            return null;
        }

        public void generalizedIf(Tree condition, Tree thenSection, Iterable<? extends Tree> elseSection, boolean realElse) {
            Boolean result = this.scan(condition, null);
            if (result != null) {
                if (result.booleanValue()) {
                    this.scan(thenSection, null);
                    if (realElse && elseSection.iterator().hasNext()) {
                        this.deadBranches.add(elseSection.iterator().next());
                    }
                } else {
                    this.scan(elseSection, null);
                    this.deadBranches.add(thenSection);
                }
                return;
            }
            Map<Element, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<Element, State>(oldVariable2State);
            this.scan(thenSection, null);
            HashMap<Element, State> variableStatesAfterThen = new HashMap<Element, State>(this.variable2State);
            this.variable2State = new HashMap<Element, State>(oldVariable2State);
            this.scan(elseSection, null);
            this.variable2State = this.mergeOr(this.variable2State, variableStatesAfterThen);
        }

        public Boolean visitBinary(BinaryTree node, ConstructorData p) {
            Boolean left = this.scan((Tree)node.getLeftOperand(), p);
            if (left != null && (node.getKind() == Tree.Kind.CONDITIONAL_AND || node.getKind() == Tree.Kind.CONDITIONAL_OR)) {
                if (left.booleanValue()) {
                    if (node.getKind() == Tree.Kind.CONDITIONAL_AND) {
                        return this.scan((Tree)node.getRightOperand(), p);
                    }
                    return true;
                }
                if (node.getKind() == Tree.Kind.CONDITIONAL_AND) {
                    return false;
                }
                return this.scan((Tree)node.getRightOperand(), p);
            }
            Map<Element, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<Element, State>(oldVariable2State);
            Boolean right = this.scan((Tree)node.getRightOperand(), p);
            this.variable2State = this.mergeOr(this.variable2State, oldVariable2State);
            if (left == null || right == null) {
                return null;
            }
            switch (node.getKind()) {
                case AND: 
                case CONDITIONAL_AND: {
                    return left != false && right != false;
                }
                case OR: 
                case CONDITIONAL_OR: {
                    return left != false || right != false;
                }
                case EQUAL_TO: {
                    return left == right;
                }
                case NOT_EQUAL_TO: {
                    return left != right;
                }
            }
            return null;
        }

        public Boolean visitConditionalExpression(ConditionalExpressionTree node, ConstructorData p) {
            Boolean result = this.scan((Tree)node.getCondition(), p);
            if (result != null) {
                if (result.booleanValue()) {
                    this.scan((Tree)node.getTrueExpression(), null);
                } else {
                    this.scan((Tree)node.getFalseExpression(), null);
                }
                return null;
            }
            Map<Element, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<Element, State>(oldVariable2State);
            this.scan((Tree)node.getTrueExpression(), null);
            if (node.getFalseExpression() != null) {
                HashMap<Element, State> variableStatesAfterThen = new HashMap<Element, State>(this.variable2State);
                this.variable2State = new HashMap<Element, State>(oldVariable2State);
                this.scan((Tree)node.getFalseExpression(), null);
                this.variable2State = this.mergeOr(this.variable2State, variableStatesAfterThen);
            } else {
                this.variable2State = this.mergeOr(this.variable2State, oldVariable2State);
            }
            return null;
        }

        public Boolean visitIdentifier(IdentifierTree node, ConstructorData p) {
            super.visitIdentifier(node, (Object)p);
            this.handleCurrentAccess();
            return null;
        }

        public Boolean visitUnary(UnaryTree node, ConstructorData p) {
            Element e;
            Boolean val = (Boolean)super.visitUnary(node, (Object)p);
            if (val != null && node.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
                return val == false;
            }
            if ((node.getKind() == Tree.Kind.PREFIX_DECREMENT || node.getKind() == Tree.Kind.PREFIX_INCREMENT || node.getKind() == Tree.Kind.POSTFIX_DECREMENT || node.getKind() == Tree.Kind.POSTFIX_INCREMENT) && (e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()))) != null) {
                if (SUPPORTED_VARIABLES.contains((Object)e.getKind())) {
                    VariableElement ve = (VariableElement)e;
                    State prevState = this.variable2State.get(ve);
                    if (LOCAL_VARIABLES.contains((Object)e.getKind())) {
                        this.addUse2Values(node.getExpression(), prevState);
                    } else if (e.getKind() == ElementKind.FIELD && prevState != null && prevState.hasUnassigned() && !this.finalCandidates.contains(ve)) {
                        this.usedWhileUndefined.add(ve);
                    }
                    this.variable2State.put(ve, State.create(this.getCurrentPath(), prevState));
                } else if (this.shouldProcessUndefined(e)) {
                    Element cv = this.canonicalUndefined(e);
                    State prevState = this.variable2State.get(cv);
                    this.variable2State.put(cv, State.create(this.getCurrentPath(), prevState));
                }
            }
            return null;
        }

        private void addFieldConstructor(Element field, Element ctor) {
            Collection<Element> ctors = this.finalFieldConstructors.get(field);
            if (ctors == null) {
                ctors = new HashSet<Element>();
                this.finalFieldConstructors.put(field, ctors);
            }
            ctors.add(ctor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean visitMethod(MethodTree node, ConstructorData p) {
            Tree oldNearestMethod = this.nearestMethod;
            Set<Element> oldCurrentMethodVariables = this.currentMethodVariables;
            Map<TypeMirror, Map<Element, State>> oldResumeOnExceptionHandler = this.resumeOnExceptionHandler;
            Map<Element, State> oldVariable2State = this.variable2State;
            this.nearestMethod = node;
            this.currentMethodVariables = Collections.newSetFromMap(new IdentityHashMap());
            this.resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Map<Element, State>>();
            this.variable2State = new HashMap<Element, State>(this.variable2State);
            Iterator<Map.Entry<Element, State>> it = this.variable2State.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Element, State> e = it.next();
                if (!e.getKey().getKind().isField()) continue;
                it.remove();
            }
            try {
                this.scan((Tree)node.getModifiers(), null);
                this.scan(node.getReturnType(), null);
                this.scan(node.getTypeParameters(), null);
                this.inParameters = true;
                try {
                    this.scan(node.getParameters(), null);
                }
                finally {
                    this.inParameters = false;
                }
                this.scan(node.getThrows(), null);
                List<Tree> additionalTrees = p != null ? p.initializers : Collections.emptyList();
                this.handleInitializers(additionalTrees);
                this.scan((Tree)node.getBody(), null);
                this.scan(node.getDefaultValue(), null);
                boolean isConstructor = this.isConstructor(this.getCurrentPath());
                HashSet<Element> definitellyAssignedOnce = new HashSet<Element>();
                HashSet<Element> assigned = new HashSet<Element>();
                Element methodEl = this.info.getTrees().getElement(this.getCurrentPath());
                Element classEl = methodEl != null ? methodEl.getEnclosingElement() : null;
                Iterator<Map.Entry<Element, State>> it2 = this.variable2State.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry<Element, State> entry = it2.next();
                    if (entry.getKey().getKind() != ElementKind.FIELD) continue;
                    if (isConstructor && !entry.getValue().hasUnassigned() && !entry.getValue().reassigned && !entry.getKey().getModifiers().contains((Object)Modifier.STATIC) && entry.getKey().getEnclosingElement().equals(classEl)) {
                        definitellyAssignedOnce.add(entry.getKey());
                    }
                    assigned.add(entry.getKey());
                    it2.remove();
                }
                if (isConstructor && p != null) {
                    if (p.first) {
                        this.finalCandidates.addAll(definitellyAssignedOnce);
                    } else {
                        this.finalCandidates.retainAll(definitellyAssignedOnce);
                    }
                    if (methodEl != null) {
                        for (Element element : definitellyAssignedOnce) {
                            this.addFieldConstructor(element, methodEl);
                        }
                    }
                    for (Element element : assigned) {
                        if (!element.getModifiers().contains((Object)Modifier.STATIC) && definitellyAssignedOnce.contains(element)) continue;
                        this.finalCandidates.remove(element);
                    }
                } else {
                    this.finalCandidates.removeAll(assigned);
                }
            }
            finally {
                this.nearestMethod = oldNearestMethod;
                this.currentMethodVariables = oldCurrentMethodVariables;
                this.resumeOnExceptionHandler = oldResumeOnExceptionHandler;
                this.variable2State = this.mergeOr(this.variable2State, oldVariable2State, false);
            }
            return null;
        }

        private boolean isConstructor(TreePath what) {
            return what.getLeaf().getKind() == Tree.Kind.METHOD && ((MethodTree)what.getLeaf()).getName().contentEquals("<init>");
        }

        public Boolean visitWhileLoop(WhileLoopTree node, ConstructorData p) {
            return this.handleGeneralizedForLoop(null, node.getCondition(), null, node.getStatement(), node.getCondition(), p);
        }

        public Boolean visitDoWhileLoop(DoWhileLoopTree node, ConstructorData p) {
            Map<Element, State> beforeLoop = this.variable2State;
            this.variable2State = new HashMap<Element, State>(beforeLoop);
            this.scan((Tree)node.getStatement(), null);
            Boolean condValue = this.scan((Tree)node.getCondition(), null);
            if (condValue != null && !condValue.booleanValue()) {
                return null;
            }
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            if (!this.doNotRecord) {
                boolean oldDoNotRecord = this.doNotRecord;
                this.doNotRecord = true;
                beforeLoop = new HashMap<Element, State>(this.variable2State);
                this.scan((Tree)node.getStatement(), null);
                this.scan((Tree)node.getCondition(), null);
                this.doNotRecord = oldDoNotRecord;
                this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            }
            return null;
        }

        public Boolean visitForLoop(ForLoopTree node, ConstructorData p) {
            return this.handleGeneralizedForLoop(node.getInitializer(), node.getCondition(), node.getUpdate(), node.getStatement(), node.getCondition(), p);
        }

        private Boolean handleGeneralizedForLoop(Iterable<? extends Tree> initializer, Tree condition, Iterable<? extends Tree> update, Tree statement, Tree resumeOn, ConstructorData p) {
            this.scan(initializer, null);
            Map<Element, State> beforeLoop = this.variable2State;
            this.variable2State = new HashMap<Element, State>(beforeLoop);
            Boolean condValue = this.scan(condition, null);
            if (condValue != null && !condValue.booleanValue()) {
                return null;
            }
            if (!this.doNotRecord) {
                boolean oldDoNotRecord = this.doNotRecord;
                this.doNotRecord = true;
                this.scan(statement, null);
                this.scan(update, null);
                this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
                this.resume(resumeOn, this.resumeBefore);
                beforeLoop = new HashMap<Element, State>(this.variable2State);
                this.scan(condition, null);
                this.doNotRecord = oldDoNotRecord;
            }
            this.scan(statement, null);
            this.scan(update, null);
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            return null;
        }

        public Boolean visitTry(TryTree node, ConstructorData p) {
            Map<Element, State> data;
            if (node.getFinallyBlock() != null) {
                this.pendingFinally.add(0, new TreePath(this.getCurrentPath(), node.getFinallyBlock()));
            }
            this.scan(node.getResources(), null);
            Map<Element, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<Element, State>(oldVariable2State);
            IdentityHashMap<TypeMirror, Map<Element, State>> resumeOnEx = null;
            ArrayList<TypeMirror> caughtTypes = null;
            if (node.getCatches() != null && !node.getCatches().isEmpty()) {
                caughtTypes = new ArrayList<TypeMirror>(node.getCatches().size());
                resumeOnEx = new IdentityHashMap<TypeMirror, Map<Element, State>>(caughtTypes.size());
                for (CatchTree catchTree : node.getCatches()) {
                    for (TypeMirror typeMirror : Utilities.getUnionExceptions(this.info, this.getCurrentPath(), catchTree)) {
                        data = this.resumeOnExceptionHandler.get(typeMirror);
                        if (data != null) {
                            resumeOnEx.put(typeMirror, data);
                        }
                        this.resumeOnExceptionHandler.put(typeMirror, new HashMap());
                        caughtTypes.add(typeMirror);
                    }
                }
                this.recordResumeOnExceptionHandler(this.runtimeExceptionType);
                this.recordResumeOnExceptionHandler(this.errorType);
            }
            this.scan((Tree)node.getBlock(), null);
            if (caughtTypes != null) {
                this.recordResumeOnExceptionHandler(this.runtimeExceptionType);
                this.recordResumeOnExceptionHandler(this.errorType);
            }
            HashMap<Element, State> afterBlockVariable2State = new HashMap<Element, State>(this.variable2State);
            if (caughtTypes != null) {
                for (TypeMirror typeMirror : caughtTypes) {
                    Map map = (Map)resumeOnEx.remove(typeMirror);
                    data = this.resumeOnExceptionHandler.remove(typeMirror);
                    if (data != null) {
                        resumeOnEx.put(typeMirror, data);
                    }
                    if (map == null) continue;
                    this.resumeOnExceptionHandler.put(typeMirror, map);
                }
            }
            for (CatchTree catchTree : node.getCatches()) {
                Map<Element, State> map = this.variable2State;
                this.variable2State = new HashMap<Element, State>(oldVariable2State);
                for (TypeMirror typeMirror : Utilities.getUnionExceptions(this.info, this.getCurrentPath(), catchTree)) {
                    Map data2 = (Map)resumeOnEx.get(typeMirror);
                    if (data2 == null) continue;
                    this.variable2State = this.mergeOr(this.variable2State, data2);
                }
                this.scan((Tree)catchTree, null);
                this.variable2State = this.mergeOr(map, this.variable2State);
            }
            if (node.getFinallyBlock() != null) {
                this.pendingFinally.remove(0);
                this.variable2State = this.mergeOr(this.mergeOr(oldVariable2State, this.variable2State), afterBlockVariable2State);
                this.scan((Tree)node.getFinallyBlock(), null);
            }
            return null;
        }

        private void removeAllDefinitions() {
            this.variable2State = new HashMap<Element, State>(this.variable2State);
            Iterator<Element> it = this.variable2State.keySet().iterator();
            while (it.hasNext()) {
                Element k = it.next();
                if (k.getKind().isField() || this.isUndefinedVariable(k)) continue;
                it.remove();
            }
        }

        public Boolean visitReturn(ReturnTree node, ConstructorData p) {
            super.visitReturn(node, (Object)p);
            this.variable2State = new HashMap<Element, State>(this.variable2State);
            if (this.pendingFinally.isEmpty()) {
                for (Element ve : this.currentMethodVariables) {
                    this.variable2State.remove(ve);
                }
            }
            this.resumeAfter(this.nearestMethod, this.variable2State);
            this.removeAllDefinitions();
            return null;
        }

        public Boolean visitBreak(BreakTree node, ConstructorData p) {
            super.visitBreak(node, (Object)p);
            Tree target = this.info.getTreeUtilities().getBreakContinueTargetTree(this.getCurrentPath());
            this.breakTo(target);
            return null;
        }

        public Boolean visitYield(YieldTree node, ConstructorData p) {
            this.scan((Tree)node.getValue(), p);
            Tree target = this.info.getTreeUtilities().getBreakContinueTargetTree(this.getCurrentPath());
            this.breakTo(target);
            return null;
        }

        private void breakTo(Tree target) {
            this.resumeAfter(target, this.variable2State);
            this.variable2State = new HashMap<Element, State>();
        }

        public Boolean visitSwitch(SwitchTree node, ConstructorData p) {
            this.generalizedSwitch(node, node.getExpression(), node.getCases());
            return null;
        }

        public Boolean visitSwitchExpression(SwitchExpressionTree node, ConstructorData p) {
            this.generalizedSwitch(node, node.getExpression(), node.getCases());
            return null;
        }

        private void generalizedSwitch(Tree switchTree, ExpressionTree expression, List<? extends CaseTree> cases) {
            this.scan((Tree)expression, null);
            HashMap<Element, State> origVariable2State = new HashMap<Element, State>(this.variable2State);
            this.variable2State = new HashMap<Element, State>();
            boolean exhaustive = false;
            for (CaseTree caseTree : cases) {
                this.variable2State = this.mergeOr(this.variable2State, origVariable2State);
                if (caseTree.getExpression() == null) {
                    exhaustive = true;
                }
                this.scan((Tree)caseTree, null);
                if (caseTree.getCaseKind() != CaseTree.CaseKind.RULE) continue;
                this.breakTo(switchTree);
            }
            if (!exhaustive) {
                this.variable2State = this.mergeOr(this.variable2State, origVariable2State);
            }
        }

        public Boolean visitEnhancedForLoop(EnhancedForLoopTree node, ConstructorData p) {
            return this.handleGeneralizedForLoop(Arrays.asList(node.getVariable(), node.getExpression()), null, null, node.getStatement(), node.getStatement(), p);
        }

        public Boolean visitAssert(AssertTree node, ConstructorData p) {
            Map<Element, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<Element, State>(oldVariable2State);
            this.scan((Tree)node.getCondition(), null);
            if (node.getDetail() != null) {
                HashMap<Element, State> beforeDetailState = new HashMap<Element, State>(this.variable2State);
                this.scan((Tree)node.getDetail(), null);
                this.variable2State = this.mergeOr(this.variable2State, beforeDetailState);
            }
            this.variable2State = this.mergeOr(this.variable2State, oldVariable2State);
            this.recordResumeOnExceptionHandler("java.lang.AssertionError");
            return null;
        }

        public Boolean visitContinue(ContinueTree node, ConstructorData p) {
            Tree resumePoint;
            StatementTree loop = this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            if (loop == null) {
                super.visitContinue(node, (Object)p);
                return null;
            }
            if (loop.getKind() == Tree.Kind.LABELED_STATEMENT) {
                loop = ((LabeledStatementTree)loop).getStatement();
            }
            switch (loop.getKind()) {
                case WHILE_LOOP: {
                    resumePoint = ((WhileLoopTree)loop).getCondition();
                    break;
                }
                case FOR_LOOP: {
                    ForLoopTree flt = (ForLoopTree)loop;
                    resumePoint = null;
                    if (flt.getUpdate() != null && !flt.getUpdate().isEmpty()) {
                        resumePoint = flt.getUpdate().get(0);
                    }
                    if (resumePoint == null) {
                        resumePoint = flt.getCondition();
                    }
                    if (resumePoint != null) break;
                    resumePoint = flt.getStatement();
                    break;
                }
                case DO_WHILE_LOOP: {
                    resumePoint = ((DoWhileLoopTree)loop).getCondition();
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    resumePoint = ((EnhancedForLoopTree)loop).getStatement();
                    break;
                }
                default: {
                    resumePoint = null;
                }
            }
            if (resumePoint != null) {
                VisitorImpl.recordResume(this.resumeBefore, resumePoint, this.variable2State);
            }
            this.variable2State = new HashMap<Element, State>();
            super.visitContinue(node, (Object)p);
            return null;
        }

        public Boolean visitThrow(ThrowTree node, ConstructorData p) {
            super.visitThrow(node, (Object)p);
            if (node.getExpression() != null) {
                TypeMirror thrown = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
                this.recordResumeOnExceptionHandler(thrown);
            }
            return null;
        }

        public Boolean visitMethodInvocation(MethodInvocationTree node, ConstructorData p) {
            super.visitMethodInvocation(node, (Object)p);
            Element invoked = this.info.getTrees().getElement(this.getCurrentPath());
            if (invoked != null && invoked.getKind() == ElementKind.METHOD) {
                if (Utilities.isSystemExit(this.info, invoked)) {
                    this.removeAllDefinitions();
                    return null;
                }
                this.recordResumeOnExceptionHandler((ExecutableElement)invoked);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean visitLambdaExpression(LambdaExpressionTree node, ConstructorData p) {
            Boolean b;
            TypeElement oldTarget = this.referenceTarget;
            this.referenceTarget = null;
            Tree oldNearestMethod = this.nearestMethod;
            Set<Element> oldCurrentMethodVariables = this.currentMethodVariables;
            Map<TypeMirror, Map<Element, State>> oldResumeOnExceptionHandler = this.resumeOnExceptionHandler;
            Map<Element, State> oldVariable2State = this.variable2State;
            this.nearestMethod = node;
            this.currentMethodVariables = Collections.newSetFromMap(new IdentityHashMap());
            this.resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Map<Element, State>>();
            this.variable2State = new HashMap<Element, State>(this.variable2State);
            Iterator<Map.Entry<Element, State>> it = this.variable2State.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Element, State> e = it.next();
                if (!e.getKey().getKind().isField()) continue;
                it.remove();
            }
            try {
                this.inParameters = true;
                try {
                    this.scan(node.getParameters(), null);
                }
                finally {
                    this.inParameters = false;
                }
                b = this.scan(node.getBody(), p);
                HashSet<Element> assigned = new HashSet<Element>();
                Iterator<Map.Entry<Element, State>> it2 = this.variable2State.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry<Element, State> e = it2.next();
                    if (e.getKey().getKind() != ElementKind.FIELD) continue;
                    assigned.add(e.getKey());
                    it2.remove();
                }
                this.finalCandidates.removeAll(assigned);
            }
            finally {
                this.referenceTarget = oldTarget;
                this.nearestMethod = oldNearestMethod;
                this.currentMethodVariables = oldCurrentMethodVariables;
                this.resumeOnExceptionHandler = oldResumeOnExceptionHandler;
                this.variable2State = this.mergeOr(this.variable2State, oldVariable2State, false);
            }
            return b;
        }

        public Boolean visitNewClass(NewClassTree node, ConstructorData p) {
            TypeElement oldTarget = this.referenceTarget;
            super.visitNewClass(node, (Object)p);
            Element invoked = this.info.getTrees().getElement(this.getCurrentPath());
            if (invoked != null && invoked.getKind() == ElementKind.CONSTRUCTOR) {
                this.recordResumeOnExceptionHandler((ExecutableElement)invoked);
            }
            this.referenceTarget = oldTarget;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean visitClass(ClassTree node, ConstructorData p) {
            Map.Entry<Element, State> e;
            TypeElement oldTarget = this.referenceTarget;
            ArrayList<Tree> staticInitializers = new ArrayList<Tree>(node.getMembers().size());
            ArrayList<Tree> instanceInitializers = new ArrayList<Tree>(node.getMembers().size());
            ArrayList<MethodTree> constructors = new ArrayList<MethodTree>(node.getMembers().size());
            ArrayList<Tree> others = new ArrayList<Tree>(node.getMembers().size());
            for (Tree tree : node.getMembers()) {
                if (tree.getKind() == Tree.Kind.BLOCK) {
                    if (((BlockTree)tree).isStatic()) {
                        staticInitializers.add(tree);
                        continue;
                    }
                    instanceInitializers.add(tree);
                    continue;
                }
                if (tree.getKind() == Tree.Kind.VARIABLE && ((VariableTree)tree).getInitializer() != null) {
                    if (node.getKind() == Tree.Kind.INTERFACE || ((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                        assert ((e = this.info.getTrees().getElement(TreePath.getPath(this.getCurrentPath(), tree))) == null || e.getModifiers().contains((Object)Modifier.STATIC));
                        staticInitializers.add(tree);
                        continue;
                    }
                    assert ((e = this.info.getTrees().getElement(TreePath.getPath(this.getCurrentPath(), tree))) == null || !e.getModifiers().contains((Object)Modifier.STATIC));
                    instanceInitializers.add(tree);
                    continue;
                }
                if (this.isConstructor(new TreePath(this.getCurrentPath(), tree))) {
                    constructors.add((MethodTree)tree);
                    continue;
                }
                others.add(tree);
            }
            Map<Element, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<Element, State>(this.variable2State);
            Iterator<Map.Entry<Element, State>> iterator = this.variable2State.entrySet().iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!e.getKey().getKind().isField()) continue;
                iterator.remove();
            }
            try {
                this.handleInitializers(staticInitializers);
                HashSet<Element> hashSet = new HashSet<Element>();
                HashSet<Element> assigned = new HashSet<Element>();
                Iterator<Map.Entry<Element, State>> it2 = this.variable2State.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry<Element, State> e2 = it2.next();
                    if (e2.getKey().getKind() != ElementKind.FIELD) continue;
                    if (!e2.getValue().hasUnassigned() && !e2.getValue().reassigned && e2.getKey().getModifiers().contains((Object)Modifier.STATIC)) {
                        hashSet.add(e2.getKey());
                    }
                    assigned.add(e2.getKey());
                    it2.remove();
                }
                this.finalCandidates.addAll(hashSet);
            }
            finally {
                this.variable2State = this.mergeOr(this.variable2State, oldVariable2State, false);
            }
            boolean bl = true;
            for (MethodTree constructor : constructors) {
                boolean bl2;
                this.scan((Tree)constructor, new ConstructorData(bl2, instanceInitializers));
                bl2 = false;
            }
            this.scan(others, p);
            this.referenceTarget = oldTarget;
            return null;
        }

        public Boolean visitBlock(BlockTree node, ConstructorData p) {
            ArrayList<? extends StatementTree> statements = new ArrayList<StatementTree>(node.getStatements());
            for (int i = 0; i < statements.size(); ++i) {
                IfTree it;
                StatementTree st = (StatementTree)statements.get(i);
                if (st.getKind() == Tree.Kind.IF && (it = (IfTree)st).getElseStatement() == null && Utilities.exitsFromAllBranchers(this.info, new TreePath(new TreePath(this.getCurrentPath(), it), it.getThenStatement()))) {
                    this.generalizedIf(it.getCondition(), it.getThenStatement(), statements.subList(i + 1, statements.size()), false);
                    break;
                }
                this.scan((Tree)st, null);
            }
            return null;
        }

        private void recordResumeOnExceptionHandler(ExecutableElement invoked) {
            for (TypeMirror typeMirror : invoked.getThrownTypes()) {
                this.recordResumeOnExceptionHandler(typeMirror);
            }
        }

        private void recordResumeOnExceptionHandler(String exceptionTypeFQN) {
            TypeElement exc = this.info.getElements().getTypeElement(exceptionTypeFQN);
            if (exc == null) {
                return;
            }
            this.recordResumeOnExceptionHandler(exc.asType());
        }

        private void recordResumeOnExceptionHandler(TypeMirror thrown) {
            TypeMirror sup;
            TypeElement tel;
            if (thrown == null || thrown.getKind() != TypeKind.DECLARED) {
                return;
            }
            DeclaredType dtt = (DeclaredType)thrown;
            do {
                Map<Element, State> r;
                if ((r = this.resumeOnExceptionHandler.get(thrown = dtt.asElement().asType())) == null) continue;
                this.mergeOr(r, this.variable2State);
                break;
            } while ((tel = (TypeElement)dtt.asElement()) != this.throwableEl && (sup = tel.getSuperclass()).getKind() == TypeKind.DECLARED && (dtt = (DeclaredType)tel.getSuperclass()) != null);
        }

        public Boolean visitParenthesized(ParenthesizedTree node, ConstructorData p) {
            return (Boolean)super.visitParenthesized(node, (Object)p);
        }

        private void resumeAfter(Tree target, Map<Element, State> state) {
            for (TreePath tp : this.pendingFinally) {
                boolean shouldBeRun = false;
                for (Tree t : tp) {
                    if (t != target) continue;
                    shouldBeRun = true;
                    break;
                }
                if (!shouldBeRun) break;
                VisitorImpl.recordResume(this.resumeBefore, tp.getLeaf(), state);
            }
            VisitorImpl.recordResume(this.resumeAfter, target, state);
        }

        private static void recordResume(Map<Tree, Collection<Map<Element, State>>> resume, Tree target, Map<Element, State> state) {
            Collection<Map<Element, State>> r = resume.get(target);
            if (r == null) {
                r = new ArrayList<Map<Element, State>>();
                resume.put(target, r);
            }
            r.add(new HashMap<Element, State>(state));
        }

        public Boolean visitWildcard(WildcardTree node, ConstructorData p) {
            super.visitWildcard(node, (Object)p);
            return null;
        }

        public Boolean visitUnionType(UnionTypeTree node, ConstructorData p) {
            super.visitUnionType(node, (Object)p);
            return null;
        }

        public Boolean visitTypeParameter(TypeParameterTree node, ConstructorData p) {
            super.visitTypeParameter(node, (Object)p);
            return null;
        }

        public Boolean visitTypeCast(TypeCastTree node, ConstructorData p) {
            super.visitTypeCast(node, (Object)p);
            return null;
        }

        public Boolean visitSynchronized(SynchronizedTree node, ConstructorData p) {
            super.visitSynchronized(node, (Object)p);
            return null;
        }

        public Boolean visitPrimitiveType(PrimitiveTypeTree node, ConstructorData p) {
            super.visitPrimitiveType(node, (Object)p);
            return null;
        }

        public Boolean visitParameterizedType(ParameterizedTypeTree node, ConstructorData p) {
            super.visitParameterizedType(node, (Object)p);
            return null;
        }

        public Boolean visitOther(Tree node, ConstructorData p) {
            super.visitOther(node, (Object)p);
            return null;
        }

        public Boolean visitNewArray(NewArrayTree node, ConstructorData p) {
            super.visitNewArray(node, (Object)p);
            return null;
        }

        public Boolean visitModifiers(ModifiersTree node, ConstructorData p) {
            super.visitModifiers(node, (Object)p);
            return null;
        }

        public Boolean visitLabeledStatement(LabeledStatementTree node, ConstructorData p) {
            super.visitLabeledStatement(node, (Object)p);
            return null;
        }

        public Boolean visitInstanceOf(InstanceOfTree node, ConstructorData p) {
            super.visitInstanceOf(node, (Object)p);
            return null;
        }

        public Boolean visitImport(ImportTree node, ConstructorData p) {
            super.visitImport(node, (Object)p);
            return null;
        }

        public Boolean visitExpressionStatement(ExpressionStatementTree node, ConstructorData p) {
            super.visitExpressionStatement(node, (Object)p);
            return null;
        }

        public Boolean visitErroneous(ErroneousTree node, ConstructorData p) {
            super.visitErroneous(node, (Object)p);
            return null;
        }

        public Boolean visitEmptyStatement(EmptyStatementTree node, ConstructorData p) {
            super.visitEmptyStatement(node, (Object)p);
            return null;
        }

        public Boolean visitCompilationUnit(CompilationUnitTree node, ConstructorData p) {
            super.visitCompilationUnit(node, (Object)p);
            return null;
        }

        public Boolean visitCatch(CatchTree node, ConstructorData p) {
            this.inParameters = true;
            this.scan((Tree)node.getParameter(), p);
            this.inParameters = false;
            this.scan((Tree)node.getBlock(), p);
            return null;
        }

        public Boolean visitCase(CaseTree node, ConstructorData p) {
            super.visitCase(node, (Object)p);
            return null;
        }

        public Boolean visitArrayType(ArrayTypeTree node, ConstructorData p) {
            super.visitArrayType(node, (Object)p);
            return null;
        }

        public Boolean visitArrayAccess(ArrayAccessTree node, ConstructorData p) {
            boolean lv = this.lValueDereference;
            this.lValueDereference = false;
            this.scan((Tree)node.getExpression(), p);
            this.scan((Tree)node.getIndex(), p);
            this.lValueDereference = lv;
            return null;
        }

        public Boolean visitAnnotation(AnnotationTree node, ConstructorData p) {
            super.visitAnnotation(node, (Object)p);
            return null;
        }

        private Map<Element, State> mergeOr(Map<Element, State> into, Map<Element, State> what) {
            return this.mergeOr(into, what, true);
        }

        private Map<Element, State> mergeOr(Map<Element, State> into, Map<Element, State> what, boolean markMissingAsUnassigned) {
            for (Map.Entry<Element, State> e : what.entrySet()) {
                State stt = into.get(e.getKey());
                if (stt != null) {
                    into.put(e.getKey(), stt.merge(e.getValue()));
                    continue;
                }
                if (e.getKey().getKind() == ElementKind.FIELD && markMissingAsUnassigned) {
                    into.put(e.getKey(), e.getValue().merge(UNASSIGNED));
                    continue;
                }
                into.put(e.getKey(), e.getValue());
            }
            if (markMissingAsUnassigned) {
                for (Map.Entry<Element, State> e : into.entrySet()) {
                    if (e.getKey().getKind() != ElementKind.FIELD || what.containsKey(e.getKey())) continue;
                    into.put(e.getKey(), e.getValue().merge(UNASSIGNED));
                }
            }
            return into;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInitializers(List<Tree> additionalTrees) {
            block7: for (Tree additionalTree : additionalTrees) {
                switch (additionalTree.getKind()) {
                    case BLOCK: {
                        Tree oldNearestMethod = this.nearestMethod;
                        Set<Element> oldCurrentMethodVariables = this.currentMethodVariables;
                        Map<TypeMirror, Map<Element, State>> oldResumeOnExceptionHandler = this.resumeOnExceptionHandler;
                        this.nearestMethod = additionalTree;
                        this.currentMethodVariables = Collections.newSetFromMap(new IdentityHashMap());
                        this.resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Map<Element, State>>();
                        try {
                            this.scan(((BlockTree)additionalTree).getStatements(), null);
                            continue block7;
                        }
                        finally {
                            this.nearestMethod = oldNearestMethod;
                            this.currentMethodVariables = oldCurrentMethodVariables;
                            this.resumeOnExceptionHandler = oldResumeOnExceptionHandler;
                            continue block7;
                        }
                    }
                    case VARIABLE: {
                        this.scan(additionalTree, null);
                        break;
                    }
                    default: {
                        assert (false) : additionalTree.getKind();
                        continue block7;
                    }
                }
            }
        }
    }

    private static class AV {
        final TreePath path;
        final State state;

        public AV(TreePath path, State state) {
            this.path = path;
            this.state = state;
        }
    }

    public static final class AtomicBooleanCancel
    implements Cancel {
        private final AtomicBoolean cancel;

        public AtomicBooleanCancel(AtomicBoolean cancel) {
            this.cancel = cancel;
        }

        @Override
        public boolean isCanceled() {
            return this.cancel.get();
        }
    }

    public static interface Cancel {
        public boolean isCanceled();
    }

    private static class PathFinder
    extends ErrorAwareTreePathScanner {
        final Map<Tree, TreePath> node2Path;
        final Set<Tree> interestingNodes;

        public PathFinder(Map<Tree, TreePath> node2Path, Set<Tree> interestingNodes) {
            this.node2Path = node2Path;
            this.interestingNodes = interestingNodes;
        }

        public Object scan(Tree tree, Object p) {
            if (this.interestingNodes.contains(tree)) {
                this.node2Path.put(tree, new TreePath(this.getCurrentPath(), tree));
            }
            return super.scan(tree, p);
        }
    }

    public static final class FlowResult {
        private final Map<Tree, Iterable<? extends TreePath>> assignmentsForUse;
        private final Set<? extends Tree> deadBranches;
        private final Set<VariableElement> finalCandidates;
        private Map<Tree, TreePath> locations;
        private volatile Map<Tree, Collection<Tree>> dataFlow;
        private final Map<Element, Collection<Element>> finalFieldConstructors;

        private FlowResult(VisitorImpl v) {
            HashMap result = new HashMap();
            for (Map.Entry e : v.use2Values.entrySet()) {
                result.put((Tree)e.getKey(), e.getValue() != null ? ((State)e.getValue()).assignments : Collections.emptyList());
            }
            Set fc = v.finalCandidates;
            HashSet<VariableElement> finalCandidates = new HashSet<VariableElement>(fc.size());
            for (Element e : fc) {
                if (!SUPPORTED_VARIABLES.contains((Object)e.getKind())) continue;
                finalCandidates.add((VariableElement)e);
            }
            v.deadBranches.remove(null);
            finalCandidates.removeAll(v.usedWhileUndefined);
            v.finalFieldConstructors.keySet().retainAll(finalCandidates);
            this.assignmentsForUse = Collections.unmodifiableMap(result);
            this.deadBranches = Collections.unmodifiableSet(v.deadBranches);
            this.finalCandidates = Collections.unmodifiableSet(finalCandidates);
            this.finalFieldConstructors = v.finalFieldConstructors;
        }

        public Collection<Element> getFieldInitConstructors(Element var) {
            Collection<Element> els = this.finalFieldConstructors.get(var);
            return els == null ? Collections.emptyList() : Collections.unmodifiableCollection(els);
        }

        public Map<Tree, Iterable<? extends TreePath>> getAssignmentsForUse() {
            return this.assignmentsForUse;
        }

        public Set<? extends Tree> getDeadBranches() {
            return this.deadBranches;
        }

        public Set<VariableElement> getFinalCandidates() {
            return this.finalCandidates;
        }

        public Collection<Tree> getValueUsers(Tree val) {
            Collection<Tree> c;
            if (this.dataFlow == null) {
                this.computeDataFlow();
            }
            return (c = this.dataFlow.get(val)) == null ? Collections.emptyList() : c;
        }

        public TreePath findPath(Tree node, CompilationUnitTree cut) {
            if (this.locations == null) {
                IdentityHashMap<Tree, TreePath> locs = new IdentityHashMap<Tree, TreePath>(this.assignmentsForUse.size());
                PathFinder pf = new PathFinder(locs, this.assignmentsForUse.keySet());
                pf.scan(new TreePath(cut), null);
                this.locations = locs;
            }
            return this.locations.get(node);
        }

        private void computeDataFlow() {
            IdentityHashMap<Tree, Collection<Tree>> res = new IdentityHashMap<Tree, Collection<Tree>>(7);
            for (Map.Entry<Tree, Iterable<? extends TreePath>> e : this.assignmentsForUse.entrySet()) {
                Tree k = e.getKey();
                for (TreePath treePath : e.getValue()) {
                    if (treePath == null) continue;
                    Tree l = treePath.getLeaf();
                    ArrayList<Tree> users = (ArrayList<Tree>)res.get(l);
                    if (users == null) {
                        users = new ArrayList<Tree>(2);
                        res.put(l, users);
                    }
                    users.add(k);
                }
            }
            this.dataFlow = res;
        }
    }
}

