/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.util.TreePath;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.editor.base.semantic.UnusedDetector;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;

public class Unused {
    public static List<ErrorDescription> unused(HintContext ctx) {
        return UnusedDetector.findUnused((CompilationInfo)ctx.getInfo()).stream().map(ud -> Unused.convertUnused(ctx, ud)).filter(err -> err != null).collect(Collectors.toList());
    }

    private static ErrorDescription convertUnused(HintContext ctx, UnusedDetector.UnusedDescription ud) {
        String message;
        String name = ud.unusedElement.getSimpleName().toString();
        Fix fix = null;
        switch (ud.reason) {
            case NOT_WRITTEN_READ: {
                message = Bundle.ERR_NeitherReadOrWritten(name);
                fix = JavaFixUtilities.removeFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedElement(name), (TreePath)ud.unusedElementPath);
                break;
            }
            case NOT_WRITTEN: {
                message = Bundle.ERR_NotWritten(name);
                break;
            }
            case NOT_READ: {
                message = Bundle.ERR_NotRead(name);
                fix = JavaFixUtilities.safelyRemoveFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedElement(name), (TreePath)ud.unusedElementPath);
                break;
            }
            case NOT_USED: {
                if (ud.unusedElement.getKind() == ElementKind.CONSTRUCTOR) {
                    message = Bundle.ERR_NotUsedConstructor();
                    fix = JavaFixUtilities.removeFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedConstructor(), (TreePath)ud.unusedElementPath);
                    break;
                }
                message = Bundle.ERR_NotUsed(name);
                fix = JavaFixUtilities.removeFromParent((HintContext)ctx, (String)Bundle.FIX_RemoveUsedElement(name), (TreePath)ud.unusedElementPath);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown unused type: " + ud.reason);
            }
        }
        return fix != null ? ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ud.unusedElementPath, (String)message, (Fix[])new Fix[]{fix}) : ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ud.unusedElementPath, (String)message, (Fix[])new Fix[0]);
    }
}

