/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.impl.model;

import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.jakarta.web.beans.impl.model.BindingQualifier;
import org.netbeans.modules.jakarta.web.beans.impl.model.QualifierChecker;

public class AnnotationObjectProvider
implements ObjectProvider<BindingQualifier> {
    private static final String SPECILIZES_ANNOTATION = "jakarta.enterprise.inject.Specializes";
    static final Logger LOGGER = Logger.getLogger(AnnotationObjectProvider.class.getName());
    private AnnotationModelHelper myHelper;
    private String myAnnotationName;

    AnnotationObjectProvider(AnnotationModelHelper helper, String annotation) {
        this.myHelper = helper;
        this.myAnnotationName = annotation;
    }

    public List<BindingQualifier> createInitialObjects() throws InterruptedException {
        final LinkedList result = new LinkedList();
        final HashSet set = new HashSet();
        this.getHelper().getAnnotationScanner().findAnnotations(this.getAnnotationName(), AnnotationScanner.TYPE_KINDS, new AnnotationHandler(){

            public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                if (!set.contains(type)) {
                    result.add(new BindingQualifier(AnnotationObjectProvider.this.getHelper(), type, AnnotationObjectProvider.this.getAnnotationName()));
                }
                set.add(type);
                if (!AnnotationObjectProvider.this.getHelper().hasAnnotation(annotation.getAnnotationType().asElement().getAnnotationMirrors(), Inherited.class.getCanonicalName())) {
                    AnnotationObjectProvider.this.collectSpecializedImplementors(type, set, result);
                }
            }
        });
        return new ArrayList<BindingQualifier>(result);
    }

    public List<BindingQualifier> createObjects(TypeElement type) {
        ArrayList<BindingQualifier> result = new ArrayList<BindingQualifier>();
        Map annotationsByType = this.getHelper().getAnnotationsByType(this.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(type));
        AnnotationMirror annotationMirror = (AnnotationMirror)annotationsByType.get(this.getAnnotationName());
        if (annotationMirror != null) {
            result.add(new BindingQualifier(this.getHelper(), type, this.getAnnotationName()));
        }
        if (!(annotationMirror != null && this.getHelper().hasAnnotation(annotationMirror.getAnnotationType().asElement().getAnnotationMirrors(), Inherited.class.getCanonicalName()) || AnnotationObjectProvider.checkSuper(type, this.getAnnotationName(), this.getHelper()) == null)) {
            result.add(new BindingQualifier(this.getHelper(), type, this.getAnnotationName()));
        }
        return result;
    }

    public boolean modifyObjects(TypeElement type, List<BindingQualifier> bindings) {
        assert (bindings.size() == 1);
        BindingQualifier binding = bindings.get(0);
        assert (binding != null);
        if (!binding.refresh(type)) {
            bindings.remove(0);
            return true;
        }
        return false;
    }

    static void visitSpecializes(TypeElement type, AnnotationModelHelper helper, SpecializeVisitor visitor) {
        if (!AnnotationObjectProvider.hasSpecializes(type, helper)) {
            return;
        }
        TypeElement superClass = helper.getSuperclass(type);
        if (superClass != null) {
            if (visitor.visit(superClass)) {
                return;
            }
            AnnotationObjectProvider.visitSpecializes(superClass, helper, visitor);
        }
        List<? extends TypeMirror> interfaces = type.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            Element el = helper.getCompilationController().getTypes().asElement(typeMirror);
            if (!(el instanceof TypeElement)) continue;
            TypeElement interfaceElement = (TypeElement)el;
            AnnotationObjectProvider.visitSpecializes(interfaceElement, helper, visitor);
        }
    }

    static TypeElement checkSuper(TypeElement type, final String annotationName, final AnnotationModelHelper helper) {
        final TypeElement[] result = new TypeElement[1];
        SpecializeVisitor visitor = new SpecializeVisitor(){

            @Override
            public boolean visit(TypeElement element) {
                if ("jakarta.enterprise.inject.Default".equals(annotationName) && AnnotationObjectProvider.checkSpecializedDefault(element, helper)) {
                    result[0] = element;
                    return true;
                }
                if (AnnotationObjectProvider.hasAnnotation(element, annotationName, helper)) {
                    result[0] = element;
                    return true;
                }
                return false;
            }

            @Override
            public boolean visit(ExecutableElement element) {
                return false;
            }
        };
        AnnotationObjectProvider.visitSpecializes(type, helper, visitor);
        return result[0];
    }

    static boolean checkSpecializedDefault(Element element, AnnotationModelHelper helper) {
        return helper.hasAnnotation(helper.getCompilationController().getElements().getAllAnnotationMirrors(element), "jakarta.enterprise.inject.Default");
    }

    static boolean checkDefault(Element element, AnnotationModelHelper helper) {
        Set<String> qualifierNames = AnnotationObjectProvider.getQualifiers(element, helper, false);
        if (qualifierNames.contains("jakarta.enterprise.inject.Default")) {
            return true;
        }
        qualifierNames.remove("jakarta.inject.Named");
        qualifierNames.remove("jakarta.enterprise.inject.Any");
        return qualifierNames.size() == 0;
    }

    static Set<String> getQualifiers(Element element, AnnotationModelHelper helper, boolean event) {
        final HashSet<String> result = new HashSet<String>();
        AnnotationHandleStrategy strategy = new AnnotationHandleStrategy(){

            @Override
            public void handleAnnotation(AnnotationMirror annotationMirror, TypeElement annotationElement) {
                result.add(annotationElement.getQualifiedName().toString());
            }
        };
        AnnotationObjectProvider.findQualifiers(element, helper, event, strategy);
        return result;
    }

    static void findQualifiers(Element element, AnnotationModelHelper helper, boolean event, AnnotationHandleStrategy strategy) {
        List<? extends AnnotationMirror> allAnnotationMirrors = helper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            TypeElement annotationElement;
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (annotationType == null || annotationType.getKind() == TypeKind.ERROR || (annotationElement = (TypeElement)annotationType.asElement()) == null || !AnnotationObjectProvider.isQualifier(annotationElement, helper, event)) continue;
            strategy.handleAnnotation(annotationMirror, annotationElement);
        }
    }

    static boolean isQualifier(TypeElement annotationElement, AnnotationModelHelper helper, boolean event) {
        QualifierChecker checker = QualifierChecker.get(event);
        checker.init(annotationElement, helper);
        return checker.check();
    }

    public static boolean hasSpecializes(Element element, AnnotationModelHelper helper) {
        return AnnotationObjectProvider.hasAnnotation(element, SPECILIZES_ANNOTATION, helper);
    }

    static boolean hasAnnotation(Element element, String annotation, AnnotationModelHelper helper) {
        List<? extends AnnotationMirror> allAnnotationMirrors = helper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        return helper.hasAnnotation(allAnnotationMirrors, annotation);
    }

    private String getAnnotationName() {
        return this.myAnnotationName;
    }

    private AnnotationModelHelper getHelper() {
        return this.myHelper;
    }

    private void collectSpecializedImplementors(TypeElement type, Set<TypeElement> set, List<BindingQualifier> bindings) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        HashSet<TypeElement> toProcess = new HashSet<TypeElement>();
        toProcess.add(type);
        while (toProcess.size() > 0) {
            TypeElement element = (TypeElement)toProcess.iterator().next();
            toProcess.remove(element);
            Set<TypeElement> implementors = this.doCollectSpecializedImplementors(element, bindings);
            if (implementors.size() == 0) continue;
            result.addAll(implementors);
            for (TypeElement impl : implementors) {
                toProcess.add(impl);
            }
        }
        for (TypeElement derivedElement : result) {
            if (!AnnotationObjectProvider.hasSpecializes(derivedElement, this.getHelper())) continue;
            this.handleSuper(type, derivedElement, bindings, set);
        }
    }

    private Set<TypeElement> doCollectSpecializedImplementors(TypeElement type, List<BindingQualifier> bindings) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        ElementHandle handle = ElementHandle.create((Element)type);
        Set handles = this.getHelper().getClasspathInfo().getClassIndex().getElements(handle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (handles == null) {
            LOGGER.log(Level.WARNING, "ClassIndex.getElements() was interrupted");
            return Collections.emptySet();
        }
        for (ElementHandle elementHandle : handles) {
            LOGGER.log(Level.FINE, "found derived element {0}", elementHandle.getQualifiedName());
            TypeElement derivedElement = (TypeElement)elementHandle.resolve((CompilationInfo)this.getHelper().getCompilationController());
            if (derivedElement == null) continue;
            result.add(derivedElement);
        }
        return result;
    }

    private boolean handleInterface(TypeElement element, TypeElement child, Set<TypeElement> collectedElements, Set<TypeElement> bindingTypes) {
        List<? extends TypeMirror> interfaces = child.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (this.getHelper().getCompilationController().getTypes().isSameType(element.asType(), typeMirror)) {
                return true;
            }
            if (!this.getHelper().getCompilationController().getTypes().isAssignable(typeMirror, element.asType())) continue;
            Element el = this.getHelper().getCompilationController().getTypes().asElement(typeMirror);
            if (!(el instanceof TypeElement)) {
                return false;
            }
            TypeElement interfaceElement = (TypeElement)el;
            if (bindingTypes.contains(interfaceElement)) {
                return true;
            }
            collectedElements.add(interfaceElement);
            if (!AnnotationObjectProvider.hasSpecializes(interfaceElement, this.getHelper())) {
                return false;
            }
            return this.handleInterface(element, interfaceElement, collectedElements, bindingTypes);
        }
        return false;
    }

    private void handleSuper(TypeElement type, TypeElement child, List<BindingQualifier> bindings, Set<TypeElement> set) {
        TypeElement superElement2;
        if (!this.getHelper().getCompilationController().getTypes().isAssignable(child.asType(), type.asType())) {
            return;
        }
        List superclasses = this.getHelper().getSuperclasses(child);
        HashSet<TypeElement> collectedSuper = new HashSet<TypeElement>();
        collectedSuper.add(child);
        boolean specializes = true;
        TypeElement previous = child;
        Iterator iterator = superclasses.iterator();
        while (iterator.hasNext() && !(superElement2 = (TypeElement)iterator.next()).equals(type) && !set.contains(superElement2)) {
            if (this.getHelper().getCompilationController().getTypes().isAssignable(superElement2.asType(), type.asType())) {
                previous = superElement2;
                continue;
            }
            if (!AnnotationObjectProvider.hasSpecializes(superElement2, this.getHelper())) {
                specializes = false;
                break;
            }
            collectedSuper.add(superElement2);
            specializes = this.handleInterface(type, previous, collectedSuper, set);
            break;
        }
        if (specializes) {
            for (TypeElement superElement2 : collectedSuper) {
                if (set.contains(superElement2)) continue;
                set.add(superElement2);
                bindings.add(new BindingQualifier(this.getHelper(), superElement2, this.getAnnotationName()));
            }
        }
    }

    static interface SpecializeVisitor {
        public boolean visit(TypeElement var1);

        public boolean visit(ExecutableElement var1);
    }

    static interface AnnotationHandleStrategy {
        public void handleAnnotation(AnnotationMirror var1, TypeElement var2);
    }
}

