/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.hints;

import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class CDIAnnotation
extends Annotation {
    private CDIAnnotaitonType myType;
    private Line.Part myPart;

    CDIAnnotation(CDIAnnotaitonType type, Line.Part part) {
        this.myType = type;
        this.myPart = part;
    }

    public String getAnnotationType() {
        return this.myType.toString();
    }

    public String getShortDescription() {
        switch (this.myType) {
            case INJECTION_POINT: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_InjectionPoint");
            }
            case DELEGATE_POINT: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_DelegatePoint");
            }
            case DECORATED_BEAN: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_DecoratedBean");
            }
            case EVENT: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_Event");
            }
            case OBSERVER: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_Observer");
            }
            case INTERCEPTED_ELEMENT: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_Intercepted");
            }
        }
        assert (false);
        return null;
    }

    public Line.Part getPart() {
        return this.myPart;
    }

    public static enum CDIAnnotaitonType {
        INJECTION_POINT("org-netbeans-modules-jakarta-web-beans-annotations-injection-point"),
        DELEGATE_POINT("org-netbeans-modules-jakarta-web-beans-annotations-delegate-point"),
        DECORATED_BEAN("org-netbeans-modules-jakarta-web-beans-annotations-decorated-bean"),
        EVENT("org-netbeans-modules-jakarta-web-beans-annotations-event"),
        OBSERVER("org-netbeans-modules-jakarta-web-beans-annotations-observer"),
        INTERCEPTED_ELEMENT("org-netbeans-modules-editor-annotations-intercepted");

        private final String myType;

        private CDIAnnotaitonType(String type) {
            this.myType = type;
        }

        public String toString() {
            return this.myType;
        }
    }
}

