/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaElement;
import org.netbeans.modules.jakarta.web.beans.navigation.WebBeansNavigationOptions;

final class Utils {
    Utils() {
    }

    static void firstRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            tree.setSelectionRow(0);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static void scrollTreeToSelectedRow(final JTree tree) {
        final int selectedRow = tree.getLeadSelectionRow();
        if (selectedRow >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tree.scrollRectToVisible(tree.getRowBounds(selectedRow));
                }
            });
        }
    }

    static void previousRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            int selectedRow = tree.getSelectionModel().getMinSelectionRow();
            if (selectedRow == -1) {
                selectedRow = rowCount - 1;
            } else if (--selectedRow < 0) {
                selectedRow = rowCount - 1;
            }
            tree.setSelectionRow(selectedRow);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static void nextRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            int selectedRow = tree.getSelectionModel().getMinSelectionRow();
            if (selectedRow == -1) {
                selectedRow = 0;
                tree.setSelectionRow(selectedRow);
            } else {
                ++selectedRow;
            }
            tree.setSelectionRow(selectedRow % rowCount);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static void lastRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            tree.setSelectionRow(rowCount - 1);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static boolean patternMatch(JavaElement javaToolsJavaElement, String pattern, String patternLowerCase) {
        if (pattern == null) {
            return true;
        }
        String patternRegexpString = pattern;
        patternRegexpString = pattern.trim().length() == 0 ? pattern + ".*" : pattern.replaceAll(Pattern.quote("*"), Matcher.quoteReplacement(".*")).replaceAll(Pattern.quote("?"), Matcher.quoteReplacement(".")) + (pattern.endsWith("$") ? "" : ".*");
        String name = javaToolsJavaElement.getName();
        try {
            Pattern compiledPattern = Pattern.compile(patternRegexpString, WebBeansNavigationOptions.isCaseSensitive() ? 0 : 2);
            Matcher m = compiledPattern.matcher(name);
            return m.matches();
        }
        catch (PatternSyntaxException pse) {
            if (WebBeansNavigationOptions.isCaseSensitive()) {
                return name.startsWith(pattern);
            }
            return name.toLowerCase().startsWith(patternLowerCase);
        }
    }

    static String format(Element element, DeclaredType parent, CompilationInfo compilationInfo) {
        return Utils.format(element, parent, compilationInfo, false, false);
    }

    static String format(Element element, DeclaredType parent, CompilationInfo compilationInfo, boolean forSignature, boolean FQNs) {
        StringBuilder stringBuilder = new StringBuilder();
        Utils.format(element, parent, compilationInfo, stringBuilder, forSignature, FQNs);
        return stringBuilder.toString();
    }

    static void format(Element element, DeclaredType parent, CompilationInfo compilationInfo, StringBuilder stringBuilder, boolean forSignature, boolean FQNs) {
        if (element == null) {
            return;
        }
        Set<javax.lang.model.element.Modifier> modifiers = element.getModifiers();
        switch (element.getKind()) {
            case PACKAGE: {
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                if (forSignature) {
                    stringBuilder.append(Utils.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                }
                if (forSignature) {
                    switch (element.getKind()) {
                        case CLASS: {
                            stringBuilder.append("class ");
                            break;
                        }
                        case INTERFACE: {
                            stringBuilder.append("interface ");
                            break;
                        }
                        case ENUM: {
                            stringBuilder.append("enum ");
                            break;
                        }
                        case ANNOTATION_TYPE: {
                            stringBuilder.append("@interface ");
                        }
                    }
                }
                TypeElement typeElement = (TypeElement)element;
                stringBuilder.append(FQNs ? typeElement.getQualifiedName().toString() : typeElement.getSimpleName().toString());
                Utils.formatTypeParameters(typeElement.getTypeParameters(), compilationInfo, stringBuilder, FQNs);
                break;
            }
            case CONSTRUCTOR: {
                break;
            }
            case METHOD: {
                ExecutableElement methodElement = (ExecutableElement)element;
                ExecutableType methodType = (ExecutableType)compilationInfo.getTypes().asMemberOf(parent, methodElement);
                TypeMirror returnTypeMirror = methodType.getReturnType();
                List<? extends TypeVariable> typeVars = methodType.getTypeVariables();
                if (forSignature) {
                    stringBuilder.append(Utils.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    if (typeVars != null && typeVars.size() > 0) {
                        Utils.formatTypeMirrors(typeVars, stringBuilder, FQNs);
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" ");
                        }
                    }
                    Utils.formatTypeMirror(returnTypeMirror, stringBuilder, FQNs);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(methodElement.getSimpleName().toString());
                stringBuilder.append("(");
                List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
                Utils.formatTypeMirrors(parameterTypes, stringBuilder, FQNs);
                if (methodElement.isVarArgs()) {
                    stringBuilder.append("...");
                }
                stringBuilder.append(")");
                List<? extends TypeMirror> thrownTypesMirrorsByMethod = methodElement.getThrownTypes();
                if (!thrownTypesMirrorsByMethod.isEmpty()) {
                    stringBuilder.append(" throws ");
                    Utils.formatTypeMirrors(thrownTypesMirrorsByMethod, stringBuilder, FQNs);
                }
                if (forSignature) {
                    Object annotationValueValue;
                    AnnotationValue annotationValue = methodElement.getDefaultValue();
                    if (annotationValue == null || (annotationValueValue = annotationValue.getValue()) == null) break;
                    stringBuilder.append(" default ");
                    if (annotationValueValue instanceof String) {
                        stringBuilder.append("\"");
                    } else if (annotationValueValue instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(annotationValueValue));
                    if (annotationValueValue instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(annotationValueValue instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                Utils.formatTypeMirror(returnTypeMirror, stringBuilder, FQNs);
                if (typeVars == null || typeVars.size() <= 0) break;
                stringBuilder.append(":");
                Utils.formatTypeMirrors(typeVars, stringBuilder, FQNs);
                break;
            }
            case TYPE_PARAMETER: {
                break;
            }
            case FIELD: {
                VariableElement fieldElement = (VariableElement)element;
                TypeMirror fieldType = compilationInfo.getTypes().asMemberOf(parent, fieldElement);
                if (forSignature) {
                    stringBuilder.append(Utils.toString(modifiers));
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    Utils.formatTypeMirror(fieldType, stringBuilder, FQNs);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(fieldElement.getSimpleName().toString());
                if (forSignature) {
                    Object fieldValue = fieldElement.getConstantValue();
                    if (fieldValue == null) break;
                    stringBuilder.append(" = ");
                    if (fieldValue instanceof String) {
                        stringBuilder.append("\"");
                    } else if (fieldValue instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(fieldValue));
                    if (fieldValue instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(fieldValue instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                Utils.formatTypeMirror(fieldType, stringBuilder, FQNs);
                break;
            }
            case ENUM_CONSTANT: {
                break;
            }
        }
    }

    static String toString(Set<javax.lang.model.element.Modifier> modifiers) {
        return Modifier.toString(Utils.getIntModifiers(modifiers));
    }

    static int getIntModifiers(Set<javax.lang.model.element.Modifier> modifiers) {
        int intModifiers = 0;
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            intModifiers |= 0x400;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.FINAL)) {
            intModifiers |= 0x10;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.NATIVE)) {
            intModifiers |= 0x100;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PRIVATE)) {
            intModifiers |= 2;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PROTECTED)) {
            intModifiers |= 4;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            intModifiers |= 1;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.STATIC)) {
            intModifiers |= 8;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.STRICTFP)) {
            intModifiers |= 0x800;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.SYNCHRONIZED)) {
            intModifiers |= 0x20;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.TRANSIENT)) {
            intModifiers |= 0x80;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.VOLATILE)) {
            intModifiers |= 0x40;
        }
        return intModifiers;
    }

    static void formatTypeParameters(List<? extends TypeParameterElement> typeParameters, CompilationInfo compilationInfo, StringBuilder stringBuilder, boolean FQNs) {
        if (typeParameters == null || typeParameters.size() == 0) {
            return;
        }
        boolean first = true;
        if (typeParameters.size() > 0) {
            stringBuilder.append("<");
            first = true;
            for (TypeParameterElement typeParameterElement : typeParameters) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                Utils.format(typeParameterElement, null, compilationInfo, stringBuilder, false, FQNs);
            }
            stringBuilder.append(">");
        }
    }

    static void formatTypeMirrors(List<? extends TypeMirror> typeMirros, StringBuilder stringBuilder, boolean FQNs) {
        if (typeMirros == null || typeMirros.size() == 0) {
            return;
        }
        boolean first = true;
        for (TypeMirror typeMirror : typeMirros) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            Utils.formatTypeMirror(typeMirror, stringBuilder, FQNs);
        }
    }

    static void formatTypeMirror(TypeMirror typeMirror, StringBuilder stringBuilder, boolean FQNs) {
        if (typeMirror == null) {
            return;
        }
        switch (typeMirror.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NONE: 
            case NULL: 
            case SHORT: 
            case VOID: {
                stringBuilder.append(typeMirror);
                break;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                stringBuilder.append(typeVariable.asElement().getSimpleName().toString());
                break;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)typeMirror;
                stringBuilder.append("?");
                if (wildcardType.getExtendsBound() != null) {
                    stringBuilder.append(" extends ");
                    Utils.formatTypeMirror(wildcardType.getExtendsBound(), stringBuilder, FQNs);
                }
                if (wildcardType.getSuperBound() == null) break;
                stringBuilder.append(" super ");
                Utils.formatTypeMirror(wildcardType.getSuperBound(), stringBuilder, FQNs);
                break;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                Element element = declaredType.asElement();
                if (element instanceof TypeElement) {
                    stringBuilder.append(FQNs ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString());
                } else {
                    stringBuilder.append(element.getSimpleName().toString());
                }
                List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
                if (typeArgs.isEmpty()) break;
                stringBuilder.append("<");
                Utils.formatTypeMirrors(typeArgs, stringBuilder, FQNs);
                stringBuilder.append(">");
                break;
            }
            case ARRAY: {
                int dims = 0;
                while (typeMirror.getKind() == TypeKind.ARRAY) {
                    ++dims;
                    typeMirror = ((ArrayType)typeMirror).getComponentType();
                }
                Utils.formatTypeMirror(typeMirror, stringBuilder, FQNs);
                for (int i = 0; i < dims; ++i) {
                    stringBuilder.append("[]");
                }
                break;
            }
        }
    }
}

