/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AbstractInterceptedElementAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ClassModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.hints.EditorAnnotationsHelper;
import org.openide.util.NbBundle;

public class InterceptedBeanAnalyzer
extends AbstractInterceptedElementAnalyzer
implements ClassModelAnalyzer.ClassAnalyzer {
    @Override
    public void analyze(TypeElement element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (AnnotationUtil.hasAnnotation(element, "jakarta.interceptor.Interceptor", (CompilationInfo)model.getCompilationController())) {
            result.requireCdiEnabled(element, model);
            return;
        }
        boolean hasIBindings = this.hasInterceptorBindings(element, model);
        if (hasIBindings) {
            result.requireCdiEnabled(element, model);
            EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(result);
            ElementHandle handle = ElementHandle.create((Element)element);
            if (helper != null) {
                helper.addInterceptedBean(result, (TypeElement)handle.resolve(result.getInfo()));
            }
        }
        Set<Modifier> modifiers = element.getModifiers();
        boolean isFinal = modifiers.contains((Object)Modifier.FINAL);
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        ExecutableElement badMethod = null;
        for (ExecutableElement method : methods) {
            if (cancel.get()) {
                return;
            }
            modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) continue;
            badMethod = method;
            break;
        }
        if (badMethod == null && !isFinal) {
            return;
        }
        if (cancel.get()) {
            return;
        }
        if (hasIBindings && isFinal) {
            result.addError((Element)element, model, NbBundle.getMessage(InterceptedBeanAnalyzer.class, (String)"ERR_FinalInterceptedBean"));
        }
        if (hasIBindings && badMethod != null) {
            result.addError((Element)element, model, NbBundle.getMessage(InterceptedBeanAnalyzer.class, (String)"ERR_InterceptedBeanHasFinalMethod", (Object)badMethod.getSimpleName().toString()));
        }
    }
}

