/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ClassElementAnalyzer;
import org.openide.util.NbBundle;

public class CtorsAnalyzer
implements ClassElementAnalyzer.ClassAnalyzer {
    @Override
    public void analyze(TypeElement element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        int injectCtorCount = 0;
        for (ExecutableElement ctor : constructors) {
            if (cancel.get()) {
                return;
            }
            if (!AnnotationUtil.hasAnnotation(ctor, "jakarta.inject.Inject", result.getInfo())) continue;
            result.requireCdiEnabled(ctor);
            ++injectCtorCount;
        }
        if (injectCtorCount > 1) {
            result.addError(element, NbBundle.getMessage(CtorsAnalyzer.class, (String)"ERR_InjectedCtor"));
        }
    }
}

