/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.method;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.MethodElementAnalyzer;
import org.netbeans.modules.jakarta.web.beans.hints.EditorAnnotationsHelper;
import org.openide.util.NbBundle;

public class AnnotationsAnalyzer
implements MethodElementAnalyzer.MethodAnalyzer {
    private static final String EJB = "ejb";

    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        this.checkProductionObserverDisposerInject(element, parent, cancel, result);
        if (cancel.get()) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkProductionObserverDisposerInject(ExecutableElement element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        void var12_20;
        EditorAnnotationsHelper helper;
        CompilationInfo compInfo = result.getInfo();
        boolean isProducer = AnnotationUtil.hasAnnotation(element, "jakarta.enterprise.inject.Produces", compInfo);
        boolean isInitializer = AnnotationUtil.hasAnnotation(element, "jakarta.inject.Inject", compInfo);
        int observesCount = 0;
        int disposesCount = 0;
        List<? extends VariableElement> parameters = element.getParameters();
        for (VariableElement variableElement : parameters) {
            if (cancel.get()) {
                return;
            }
            if (AnnotationUtil.hasAnnotation(variableElement, "jakarta.enterprise.event.Observes", compInfo)) {
                ++observesCount;
            }
            if (!AnnotationUtil.hasAnnotation(variableElement, "jakarta.enterprise.inject.Disposes", compInfo)) continue;
            ++disposesCount;
        }
        if (observesCount > 0 && (helper = EditorAnnotationsHelper.getInstance(result)) != null) {
            helper.addObserver(result, element);
        }
        String firstAnnotation = null;
        Object var12_13 = null;
        if (isProducer) {
            firstAnnotation = "Produces";
            if (isInitializer) {
                String string = "Inject";
            } else if (observesCount > 0) {
                String string = "Observes";
            } else if (disposesCount > 0) {
                String string = "Disposes";
            }
        } else if (isInitializer) {
            firstAnnotation = "Inject";
            if (observesCount > 0) {
                String string = "Observes";
            } else if (disposesCount > 0) {
                String string = "Disposes";
            }
        } else if (observesCount > 0) {
            firstAnnotation = "Observes";
            if (disposesCount > 0) {
                String string = "Disposes";
            }
        }
        if (firstAnnotation != null && var12_20 != null) {
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"ERR_BothAnnotationsMethod", (Object)firstAnnotation, (Object)var12_20));
        }
        if (observesCount > 1) {
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"ERR_ManyObservesParameter"));
        } else if (disposesCount > 1) {
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"ERR_ManyDisposesParameter"));
        }
        this.checkAbstractMethod(element, result, isProducer, disposesCount > 0);
        this.checkBusinessMethod(element, result, isProducer, disposesCount > 0, observesCount > 0);
        if (isInitializer) {
            this.checkInitializerMethod(element, parent, result);
        }
    }

    private void checkBusinessMethod(ExecutableElement element, CdiAnalysisResult result, boolean isProducer, boolean isDisposer, boolean isObserver) {
        CompilationInfo compInfo = result.getInfo();
        if (!(isProducer || isDisposer || isObserver)) {
            return;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC)) {
            return;
        }
        TypeElement containingClass = compInfo.getElementUtilities().enclosingTypeElement((Element)element);
        if (!AnnotationUtil.isSessionBean(containingClass, compInfo)) {
            return;
        }
        String methodName = element.getSimpleName().toString();
        boolean isBusinessMethod = true;
        if (methodName.startsWith(EJB)) {
            isBusinessMethod = false;
        }
        if (AnnotationUtil.isLifecycleCallback(element, compInfo)) {
            isBusinessMethod = false;
        }
        if (modifiers.contains((Object)Modifier.FINAL) || !modifiers.contains((Object)Modifier.PUBLIC)) {
            isBusinessMethod = false;
        }
        if (!isBusinessMethod) {
            String key = null;
            if (isProducer) {
                key = "ERR_ProducerNotBusiness";
            } else if (isDisposer) {
                key = "ERR_DisposerNotBusiness";
            } else if (isObserver) {
                key = "ERR_ObserverNotBusiness";
            }
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)key));
        }
    }

    private void checkInitializerMethod(ExecutableElement element, TypeElement parent, CdiAnalysisResult result) {
        List<? extends TypeVariable> typeVariables;
        TypeMirror method;
        Set<Modifier> modifiers = element.getModifiers();
        boolean isAbstract = modifiers.contains((Object)Modifier.ABSTRACT);
        boolean isStatic = modifiers.contains((Object)Modifier.STATIC);
        if (isAbstract || isStatic) {
            String key = isAbstract ? "ERR_AbstractInitMethod" : "ERR_StaticInitMethod";
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)key));
        }
        if ((method = result.getInfo().getTypes().asMemberOf((DeclaredType)parent.asType(), element)) instanceof ExecutableType && (typeVariables = ((ExecutableType)method).getTypeVariables()) != null && typeVariables.size() > 0) {
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"ERR_GenericInitMethod"));
        }
    }

    private void checkAbstractMethod(ExecutableElement element, CdiAnalysisResult result, boolean isProducer, boolean isDisposer) {
        if (isProducer || isDisposer) {
            String key = isProducer ? "ERR_AbstractProducerMethod" : "ERR_AbstractDisposerMethod";
            Set<Modifier> modifiers = element.getModifiers();
            if (modifiers.contains((Object)Modifier.ABSTRACT)) {
                result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)key));
            }
        }
    }
}

