/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanInputDialog;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;

public abstract class BeanTablePanel
extends JPanel {
    protected JTable table;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected JButton sourceButton;
    private boolean reordable;
    protected BeanTableModel model;
    private boolean isSource;
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private JPanel southPanel;
    protected JButton addButton;
    private JPanel buttonPanel;
    private JScrollPane jScrollPane1;
    protected JButton editButton;
    protected JButton removeButton;
    private JPanel rightPanel;

    public BeanTablePanel(BeanTableModel model) {
        this(model, false, false);
    }

    public BeanTablePanel(BeanTableModel model, boolean reordable) {
        this(model, reordable, false);
    }

    public BeanTablePanel(BeanTableModel model, final boolean reordable, final boolean isSource) {
        this.model = model;
        this.reordable = reordable;
        this.isSource = isSource;
        this.initComponents();
        this.table = new FixedHeightJTable();
        this.table.getAccessibleContext().setAccessibleName(this.getAccessibleName());
        this.table.getAccessibleContext().setAccessibleDescription(this.getAccessibleDesc());
        this.getAccessibleContext().setAccessibleName(this.getAccessibleName());
        this.getAccessibleContext().setAccessibleDescription(this.getAccessibleDesc());
        this.table.setSelectionMode(0);
        this.table.setModel(model);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (((ListSelectionModel)e.getSource()).isSelectionEmpty() || BeanTablePanel.this.table.getModel().getRowCount() == 0) {
                    BeanTablePanel.this.editButton.setEnabled(false);
                    BeanTablePanel.this.removeButton.setEnabled(false);
                    if (reordable) {
                        BeanTablePanel.this.moveUpButton.setEnabled(false);
                        BeanTablePanel.this.moveDownButton.setEnabled(false);
                    }
                    if (isSource) {
                        BeanTablePanel.this.sourceButton.setEnabled(false);
                    }
                } else {
                    BeanTablePanel.this.editButton.setEnabled(true);
                    BeanTablePanel.this.removeButton.setEnabled(true);
                    if (reordable) {
                        int row = BeanTablePanel.this.table.getSelectedRow();
                        if (row < BeanTablePanel.this.table.getModel().getRowCount() - 1) {
                            BeanTablePanel.this.moveDownButton.setEnabled(true);
                        } else {
                            BeanTablePanel.this.moveDownButton.setEnabled(false);
                        }
                        if (row > 0) {
                            BeanTablePanel.this.moveUpButton.setEnabled(true);
                        } else {
                            BeanTablePanel.this.moveUpButton.setEnabled(false);
                        }
                    }
                    if (isSource) {
                        BeanTablePanel.this.sourceButton.setEnabled(true);
                    }
                }
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        if (reordable) {
            this.moveUpButton = new JButton(this.bundle.getString("LBL_Move_Up"));
            this.moveDownButton = new JButton(this.bundle.getString("LBL_Move_Down"));
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.buttonPanel.add(this.moveUpButton);
            this.buttonPanel.add(this.moveDownButton);
        }
        if (isSource) {
            this.sourceButton = new JButton(this.bundle.getString("LBL_Go_To_Source"));
            this.sourceButton.setEnabled(false);
            this.rightPanel.add(this.sourceButton);
        }
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = BeanTablePanel.this.table.getSelectedRow();
                if (row >= 0) {
                    BeanTablePanel.this.getModel().removeRow(row);
                    if (row >= BeanTablePanel.this.getModel().getRowCount()) {
                        --row;
                    }
                    if (row >= 0) {
                        BeanTablePanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BeanTablePanel.this.displayDialog(true);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BeanTablePanel.this.displayDialog(false);
            }
        });
    }

    public void setModel(Object parent, CommonDDBean[] children) {
        this.model.setData(parent, children);
    }

    protected void displayDialog(boolean isEditOperation) {
        int row = -1;
        BeanInputDialog dialog = null;
        if (isEditOperation) {
            row = this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            Object[] values = this.model.getValues(row);
            dialog = this.getInputDialog(values);
        } else {
            dialog = this.getInputDialog();
        }
        do {
            int result = dialog.display();
            if (result == 0) break;
            if (result != 1) continue;
            if (dialog.hasErrors()) {
                dialog.showErrors();
                continue;
            }
            if (isEditOperation) {
                this.model.editRow(row, dialog.getValues());
                continue;
            }
            this.model.addRow(dialog.getValues());
        } while (dialog.hasErrors());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.southPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.rightPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane1, "Center");
        this.southPanel.setLayout(new BorderLayout());
        String buttonText = this.bundle.getString("LBL_New");
        int mnemonicIndex = buttonText.indexOf(this.bundle.getString("MNC_New").charAt(0));
        if (mnemonicIndex < 0) {
            mnemonicIndex = 0;
        }
        this.addButton.setText(buttonText);
        this.addButton.setDisplayedMnemonicIndex(mnemonicIndex);
        AccessibleContext accessibleContext = this.addButton.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_New"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_New"));
        this.buttonPanel.add(this.addButton);
        buttonText = this.bundle.getString("LBL_Edit");
        mnemonicIndex = buttonText.indexOf(this.bundle.getString("MNC_Edit").charAt(0));
        if (mnemonicIndex < 0) {
            mnemonicIndex = 0;
        }
        this.editButton.setText(buttonText);
        this.editButton.setDisplayedMnemonicIndex(mnemonicIndex);
        this.editButton.setEnabled(false);
        accessibleContext = this.editButton.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_Edit"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_Edit"));
        this.buttonPanel.add(this.editButton);
        buttonText = this.bundle.getString("LBL_Delete");
        mnemonicIndex = buttonText.indexOf(this.bundle.getString("MNC_Delete").charAt(0));
        if (mnemonicIndex < 0) {
            mnemonicIndex = 0;
        }
        this.removeButton.setText(buttonText);
        this.removeButton.setDisplayedMnemonicIndex(mnemonicIndex);
        this.removeButton.setEnabled(false);
        accessibleContext = this.removeButton.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_Delete"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_Delete"));
        this.buttonPanel.add(this.removeButton);
        this.southPanel.add((Component)this.buttonPanel, "Center");
        this.southPanel.add((Component)this.rightPanel, "East");
        this.add((Component)this.southPanel, "South");
    }

    public abstract BeanInputDialog getInputDialog(Object[] var1);

    public abstract BeanInputDialog getInputDialog();

    protected String getAccessibleName() {
        return this.bundle.getString("ACSN_Table");
    }

    protected String getAccessibleDesc() {
        return this.bundle.getString("ACSD_Table");
    }

    public BeanTableModel getModel() {
        return this.model;
    }

    public void setTitle(String title) {
        JLabel label = new JLabel(title);
        label.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.add((Component)label, "North");
    }

    public void setSelectedRow(int row) {
        this.table.setRowSelectionInterval(row, row);
    }

    public void setButtons(boolean b1, boolean b2, boolean b3) {
        this.addButton.setEnabled(b1);
        this.editButton.setEnabled(b2);
        this.removeButton.setEnabled(b3);
    }

    public void setButtons(boolean b1, boolean b2, boolean b3, boolean b4, boolean b5, boolean b6) {
        this.setButtons(b1, b2, b3);
        this.moveUpButton.setEnabled(b4);
        this.moveDownButton.setEnabled(b5);
    }

    public boolean isReordable() {
        return this.reordable;
    }

    public boolean isSource() {
        return this.isSource;
    }
}

