/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.sun.share.PrincipalNameMapping;
import org.openide.util.NbBundle;

public class SecurityMasterListModel
extends AbstractTableModel {
    public static final String DUPLICATE_PRINCIPAL = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("ERR_PrincipalExists");
    public static final String DUPLICATE_GROUP = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("ERR_GroupExists");
    public static final String[] PRINCIPAL_COLUMN_NAMES = new String[]{NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("LBL_PrincipalColumnName"), NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("LBL_PrincipalClassColumnName")};
    public static final String[] GROUP_COLUMN_NAMES = new String[]{NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("LBL_GroupColumnName")};
    private Vector masterList;
    private final String[] columnNames;
    private final int columnCount;
    private String duplicateErrorPattern;
    private static SecurityMasterListModel principalMaster = new SecurityMasterListModel(DUPLICATE_PRINCIPAL, PRINCIPAL_COLUMN_NAMES, 2);
    private static SecurityMasterListModel groupMaster = new SecurityMasterListModel(DUPLICATE_GROUP);

    private SecurityMasterListModel(String dupErrorPattern) {
        this(dupErrorPattern, GROUP_COLUMN_NAMES, 1);
    }

    private SecurityMasterListModel(String dupErrorPattern, String[] colNames, int columns) {
        assert (colNames.length == columns);
        this.duplicateErrorPattern = dupErrorPattern;
        this.columnNames = colNames;
        this.columnCount = columns;
        this.masterList = new Vector();
    }

    private SecurityMasterListModel(String dupErrorPattern, String[] colNames, Object[] objects, int columns) {
        assert (colNames.length == columns);
        this.duplicateErrorPattern = dupErrorPattern;
        this.columnNames = colNames;
        this.columnCount = columns;
        this.masterList = new Vector<Object>(Arrays.asList(objects));
    }

    public void addElement(Object obj) {
        int index = this.masterList.size();
        this.masterList.add(obj);
        this.fireTableRowsInserted(index, index);
    }

    public boolean removeElement(Object obj) {
        int index = this.masterList.indexOf(obj);
        boolean result = this.masterList.removeElement(obj);
        if (index >= 0) {
            this.fireTableRowsDeleted(index, index);
        }
        return result;
    }

    public void removeElementAt(int index) {
        if (index >= 0 || index < this.masterList.size()) {
            this.masterList.removeElementAt(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void removeElements(int[] indices) {
        if (indices.length > 0) {
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] < 0 && indices[i] >= this.masterList.size()) continue;
                this.masterList.removeElementAt(indices[i]);
            }
            this.fireTableRowsUpdated(indices[0], indices[indices.length - 1]);
        }
    }

    public boolean replaceElement(Object oldObj, Object newObj) {
        boolean result = false;
        int index = this.masterList.indexOf(oldObj);
        if (index != -1) {
            this.masterList.setElementAt(newObj, index);
            this.fireTableRowsUpdated(index, index);
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = null;
        if (rowIndex >= 0 && rowIndex < this.masterList.size() && columnIndex >= 0 && columnIndex < this.columnCount) {
            Object entry = this.masterList.get(rowIndex);
            if (entry instanceof String) {
                assert (this.columnCount == 1) : "Invalid object for getValueAt() in SecurityMasterListModel.";
                result = (String)entry;
            } else if (entry instanceof PrincipalNameMapping) {
                PrincipalNameMapping principalEntry = (PrincipalNameMapping)this.masterList.get(rowIndex);
                result = columnIndex == 0 ? principalEntry.getPrincipalName() : principalEntry.getClassName();
            } else assert (false) : "Invalid object for getValueAt() in SecurityMasterListModel.";
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.masterList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int column) {
        if (column >= 0 && column < this.columnCount) {
            return this.columnNames[column];
        }
        return null;
    }

    public boolean contains(Object obj) {
        return this.masterList.contains(obj);
    }

    public String getDuplicateErrorMessage(String roleName) {
        Object[] args = new Object[]{roleName};
        return MessageFormat.format(this.duplicateErrorPattern, args);
    }

    public Object getRow(int rowIndex) {
        Object result = null;
        if (rowIndex >= 0 && rowIndex < this.masterList.size()) {
            result = this.masterList.get(rowIndex);
        }
        return result;
    }

    public static SecurityMasterListModel getPrincipalMasterModel() {
        return principalMaster;
    }

    public static SecurityMasterListModel getGroupMasterModel() {
        return groupMaster;
    }
}

