/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;

public class Utils {
    private static final String GET_PREFIX = "get";

    public String getName(String absoluteName, int delimiter) {
        if (null == absoluteName) {
            return absoluteName;
        }
        int index = absoluteName.lastIndexOf(delimiter);
        if (index != -1) {
            return absoluteName.substring(++index);
        }
        return absoluteName;
    }

    public String getParentName(String absoluteName, int delimiter) {
        if (null == absoluteName) {
            return absoluteName;
        }
        int endIndex = absoluteName.lastIndexOf(delimiter);
        if (endIndex != -1) {
            if (0 == endIndex) {
                return null;
            }
            return absoluteName.substring(0, endIndex);
        }
        return null;
    }

    public String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public Object createObject(String type) {
        Object object = null;
        try {
            Class<?> classObject = Class.forName(type);
            object = classObject.newInstance();
        }
        catch (InstantiationException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        return object;
    }

    public Object createObject(Class classObject) {
        Object object = null;
        try {
            object = classObject.newInstance();
        }
        catch (InstantiationException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        return object;
    }

    public Object createObject(Constructor constructor, Object[] arguments) {
        Object object = null;
        try {
            object = constructor.newInstance(arguments);
            return object;
        }
        catch (InstantiationException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
        return object;
    }

    public Constructor getConstructor(String type, Class[] argumentClass) {
        Constructor constructor = null;
        Class classObject = this.getClass(type);
        try {
            constructor = classObject.getConstructor(argumentClass);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        return constructor;
    }

    public Constructor getConstructor(Class classObject, Class[] argumentClass) {
        Constructor constructor = null;
        try {
            constructor = classObject.getConstructor(argumentClass);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        return constructor;
    }

    public Class getClass(Object object) {
        Class<?> classObject = null;
        classObject = object.getClass();
        return classObject;
    }

    public Class getClass(String type) {
        Class<?> classObject = null;
        try {
            classObject = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        return classObject;
    }

    public Method getMethod(String type, String methodName, Class[] argumentClass) {
        Method method = null;
        Class classObject = this.getClass(type);
        try {
            method = classObject.getMethod(methodName, argumentClass);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        return method;
    }

    public Method getMethod(Class classObject, String methodName, Class[] argumentClass) {
        Method method = null;
        try {
            method = classObject.getMethod(methodName, argumentClass);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        return method;
    }

    public Object invoke(Object object, Method method, Object[] arguments) {
        Object result = null;
        try {
            result = method.invoke(object, arguments);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
        return result;
    }

    public Method getMethod(String type, String methodName) {
        Method method = null;
        Class classObject = this.getClass(type);
        try {
            method = classObject.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        return method;
    }

    public Method getMethod(Class classObject, String methodName) {
        Method method = null;
        try {
            method = classObject.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        return method;
    }

    public Object invoke(Object object, Method method) {
        Object result = null;
        try {
            result = method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
        return result;
    }

    public String eleminateHypen(String string) {
        if (string != null && string.length() > 0) {
            int index = string.indexOf(45);
            while (index != -1) {
                string = index == 0 ? string.substring(1) : (index == string.length() - 1 ? string.substring(0, string.length() - 1) : string.substring(0, index) + this.upperCaseFirstLetter(string.substring(index + 1)));
                index = string.indexOf(45);
            }
        }
        return string;
    }

    public String methodNameFromBeanName(String elementName, String prefix) {
        if (null == elementName || null == prefix || prefix.length() <= 0) {
            return elementName;
        }
        String methodName = this.upperCaseFirstLetter(elementName);
        methodName = prefix + methodName;
        return methodName;
    }

    public String methodNameFromDtdName(String elementName, String prefix) {
        return this.methodNameFromBeanName(this.eleminateHypen(elementName), prefix);
    }

    public Object getElement(String elementName, Object object) {
        if (null == object || null == elementName || elementName.length() <= 0) {
            return null;
        }
        String methodName = this.methodNameFromDtdName(elementName, GET_PREFIX);
        Method getMethod = null;
        getMethod = this.getMethod(this.getClass(object), methodName);
        return this.invoke(object, getMethod);
    }

    public Object[] getElements(String elementName, Object object) {
        return (Object[])this.getElement(elementName, object);
    }

    public Object getElement(String elementName, int index, Object object) {
        if (null == object || null == elementName || elementName.length() <= 0 || index < 0) {
            return null;
        }
        String methodName = this.methodNameFromDtdName(elementName, GET_PREFIX);
        Class[] argumentTypes = new Class[]{Integer.TYPE};
        Method getMethod = null;
        getMethod = this.getMethod(this.getClass(object), methodName, argumentTypes);
        Integer in = index;
        Object[] argumentValues = new Object[]{in};
        return this.invoke(object, getMethod, argumentValues);
    }

    public Object getElement(String elementName, Object object, String prefix) {
        if (null == object || null == elementName || elementName.length() <= 0) {
            return null;
        }
        String methodName = this.methodNameFromDtdName(elementName, prefix);
        Class classObject = this.getClass(object);
        Method method = this.getMethod(classObject, methodName);
        return (Integer)this.invoke(object, method);
    }

    public String getIndexedName(String name, int index) {
        if (name != null) {
            String format = BundleReader.getValue("Indexed_Name_Format");
            Object[] arguments = new Object[]{name, String.valueOf(index)};
            name = MessageFormat.format(format, arguments);
        }
        return name;
    }

    public URL getUrlObject(String relativePath) {
        Class<?> cl = this.getClass();
        ClassLoader classLoader = cl.getClassLoader();
        return classLoader.getResource(relativePath);
    }

    public InputStream getInputStream(String relavtiveFilePath) {
        InputStream inputStream = null;
        URL url = null;
        if (relavtiveFilePath != null) {
            url = this.getUrlObject(relavtiveFilePath);
            if (url != null) {
                try {
                    inputStream = url.openStream();
                }
                catch (IOException exception) {
                    System.out.println(exception.getMessage());
                }
            } else {
                String format = BundleReader.getValue("Error_does_not_exists");
                Object[] arguments = new Object[]{"File", relavtiveFilePath};
                System.out.println(MessageFormat.format(format, arguments));
            }
        }
        return inputStream;
    }

    public boolean fileExists(String relativePath) {
        boolean returnValue = false;
        InputStream inputStream = this.getInputStream(relativePath);
        if (inputStream != null) {
            returnValue = true;
        }
        return returnValue;
    }
}

