/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.hyperlink;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.NamedQuery;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NamedQueryHyperlinkProvider
implements HyperlinkProviderExt {
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.STRING_LITERAL);

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        return NamedQueryHyperlinkProvider.getIdentifierSpan(doc, offset, null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        AtomicBoolean cancel = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread(() -> this.goToNQ(doc, offset), (String)NbBundle.getMessage(NamedQueryHyperlinkProvider.class, (String)"LBL_GoToNamedQuery"), (AtomicBoolean)cancel, (boolean)false);
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        String name;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        FileObject fo = NamedQueryHyperlinkProvider.getFileObject(doc);
        String query = this.findNq(fo, name = name.substring((name = t.text().toString()).startsWith("\"") ? 1 : 0, name.endsWith("\"") ? name.length() - 1 : name.length()));
        if (query != null) {
            return query;
        }
        return null;
    }

    private void goToNQ(Document doc, int offset) {
        String name;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return;
        }
        Token t = ts.token();
        FileObject fo = NamedQueryHyperlinkProvider.getFileObject(doc);
        String nam = name = name.substring((name = t.text().toString()).startsWith("\"") ? 1 : 0, name.endsWith("\"") ? name.length() - 1 : name.length());
        Project project = FileOwnerQuery.getOwner((FileObject)NamedQueryHyperlinkProvider.getFileObject(doc));
        if (project == null) {
            return;
        }
        Object[] entInfo = this.findEntity(fo, nam);
        if (entInfo == null) {
            return;
        }
        FileObject ent = (FileObject)entInfo[1];
        String entClasst = (String)entInfo[0];
        if (ent == null) {
            return;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)ent);
        if (ent != null) {
            try {
                js.runUserActionTask(parameter -> {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    AnnotationMirror foundAm = null;
                    AnnotationValue get = null;
                    Trees trees = parameter.getTrees();
                    TypeElement entityElement = parameter.getElements().getTypeElement(entClasst);
                    List<? extends AnnotationMirror> annotationMirrors = entityElement.getAnnotationMirrors();
                    if (annotationMirrors != null) {
                        Iterator<? extends AnnotationMirror> iterator = annotationMirrors.iterator();
                        block0: while (iterator.hasNext() && foundAm == null) {
                            AnnotationMirror next = iterator.next();
                            if (next.getAnnotationType().toString().equals("javax.persistence.NamedQueries")) {
                                Map<? extends ExecutableElement, ? extends AnnotationValue> maps = next.getElementValues();
                                for (AnnotationValue annotationValue : maps.values()) {
                                    List lst = (List)annotationValue.getValue();
                                    for (Object val : lst) {
                                        AnnotationMirror am;
                                        if (val instanceof AnnotationMirror && "javax.persistence.NamedQuery".equals((am = (AnnotationMirror)val).getAnnotationType().toString())) {
                                            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = am.getElementValues();
                                            for (ExecutableElement executableElement : elementValues.keySet()) {
                                                if (!executableElement.getSimpleName().contentEquals("name") || !(get = elementValues.get(executableElement)).getValue().toString().equals(nam)) continue;
                                                foundAm = am;
                                                break;
                                            }
                                        }
                                        if (foundAm == null) continue;
                                        break;
                                    }
                                    if (foundAm == null) continue;
                                    continue block0;
                                }
                                continue;
                            }
                            if (!next.getAnnotationType().toString().equals("javax.persistence.NamedQuery") || next.getElementValues().isEmpty()) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = next.getElementValues();
                            for (ExecutableElement executableElement : elementValues.keySet()) {
                                if (!executableElement.getSimpleName().contentEquals("name") || !(get = elementValues.get(executableElement)).getValue().toString().equals(nam)) continue;
                                foundAm = next;
                                continue block0;
                            }
                        }
                    }
                    if (foundAm != null) {
                        TreePath tree = trees.getPath(entityElement, foundAm, get);
                        int startOffset = (int)trees.getSourcePositions().getStartPosition(parameter.getCompilationUnit(), tree.getLeaf());
                        UiUtils.open((FileObject)ent, (int)startOffset);
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private Object[] findEntity(FileObject javaFile, String nqName) {
        Project prj = FileOwnerQuery.getOwner((FileObject)javaFile);
        if (prj == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        EntityClassScopeProvider provider = (EntityClassScopeProvider)prj.getLookup().lookup(EntityClassScopeProvider.class);
        EntityClassScope ecs = null;
        Entity[] entities = null;
        if (provider != null) {
            ecs = provider.findEntityClassScope(javaFile);
        }
        if (ecs != null) {
            try {
                entities = (Entity[])ecs.getEntityMappingsModel(false).runReadAction(metadata -> metadata.getRoot().getEntity());
            }
            catch (MetadataModelException metadataModelException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (entities != null) {
            for (Entity entity : entities) {
                for (NamedQuery nq : entity.getNamedQuery()) {
                    if (!nqName.equals(nq.getName())) continue;
                    return new Object[]{entity.getClass2(), cp.findResource(entity.getClass2().replace('.', '/') + ".java")};
                }
            }
        }
        return null;
    }

    private String findNq(FileObject javaFile, String nqName) {
        Project prj = FileOwnerQuery.getOwner((FileObject)javaFile);
        if (prj == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        EntityClassScopeProvider provider = (EntityClassScopeProvider)prj.getLookup().lookup(EntityClassScopeProvider.class);
        EntityClassScope ecs = null;
        Entity[] entities = null;
        if (provider != null) {
            ecs = provider.findEntityClassScope(javaFile);
        }
        if (ecs != null) {
            try {
                entities = (Entity[])ecs.getEntityMappingsModel(false).runReadAction(metadata -> metadata.getRoot().getEntity());
            }
            catch (MetadataModelException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (entities != null) {
            for (Entity entity : entities) {
                for (NamedQuery nq : entity.getNamedQuery()) {
                    if (!nqName.equals(nq.getName())) continue;
                    return nq.getQuery();
                }
            }
        }
        return null;
    }

    public static int[] getIdentifierSpan(Document doc, int offset, Token<JavaTokenId>[] token) {
        FileObject fo = NamedQueryHyperlinkProvider.getFileObject(doc);
        if (fo == null) {
            return null;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        if (prj == null) {
            return null;
        }
        EntityClassScopeProvider eCS = (EntityClassScopeProvider)prj.getLookup().lookup(EntityClassScopeProvider.class);
        if (eCS == null) {
            return null;
        }
        int[] ret = new int[]{-1, -1};
        doc.render(() -> {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
            if (ts == null) {
                return;
            }
            ts.move(offset);
            if (!ts.moveNext()) {
                return;
            }
            Token t = ts.token();
            boolean hasMessage = false;
            if (USABLE_TOKEN_IDS.contains(t.id())) {
                for (int i = 0; i < 5 && ts.movePrevious(); ++i) {
                    Token tk = ts.token();
                    if (!TokenUtilities.equals((CharSequence)"createNamedQuery", (Object)tk.text())) continue;
                    hasMessage = true;
                }
                if (hasMessage) {
                    ts.move(offset);
                    ts.moveNext();
                    ret[0] = ts.offset();
                    ret[1] = ts.offset() + t.length();
                    return;
                }
            }
        });
        return ret[0] == -1 ? null : ret;
    }

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }
}

