/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.util.MetadataModelReadHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class EntityClosure {
    private static final Logger LOG = Logger.getLogger(EntityClosure.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Set<Entity> availableEntityInstances = new HashSet<Entity>();
    private Set<String> availableEntities = new HashSet<String>();
    private Set<String> wantedEntities = new HashSet<String>();
    private Set<String> selectedEntities = new HashSet<String>();
    private Set<String> referencedEntities = new HashSet<String>();
    private HashMap<String, Entity> fqnEntityMap = new HashMap();
    private HashMap<String, Boolean> fqnIdExistMap = new HashMap();
    private boolean modelReady;
    private boolean ejbModuleInvolved = false;
    private boolean closureEnabled = true;
    private Project project;
    private final MetadataModelReadHelper<EntityMappingsMetadata, List<Entity>> readHelper;
    private final MetadataModel<EntityMappingsMetadata> model;

    public static EntityClosure create(EntityClassScope entityClassScope, Project project) {
        EntityClosure ec = new EntityClosure(entityClassScope, project);
        ec.initialize();
        return ec;
    }

    public static ComboBoxModel getAsComboModel(EntityClosure ec) {
        return new EntityClosureComboBoxModel(ec);
    }

    private EntityClosure(EntityClassScope entityClassScope, Project project) {
        this.model = entityClassScope.getEntityMappingsModel(true);
        this.project = project;
        this.readHelper = MetadataModelReadHelper.create(this.model, metadata -> Arrays.asList(metadata.getRoot().getEntity()));
    }

    private void initialize() {
        this.readHelper.addChangeListener(e -> {
            if (this.readHelper.getState() == MetadataModelReadHelper.State.FINISHED) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.addAvaliableEntities(new HashSet<Entity>((Collection)this.readHelper.getResult()));
                        this.modelReady = true;
                        this.changeSupport.fireChange();
                    }
                    catch (ExecutionException e1) {
                        Exceptions.printStackTrace((Throwable)e1);
                    }
                });
            }
        });
        this.readHelper.start();
    }

    public void addAvaliableEntities(Set<Entity> entities) {
        this.availableEntityInstances.addAll(entities);
        JavaSource source = null;
        try {
            source = (JavaSource)this.model.runReadAction(metadata -> metadata.createJavaSource());
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (source != null) {
            try {
                ClassPath classPath = source.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                Set<Project> ejbProjects = this.getEjbModulesOfClasspath(classPath);
                source.runUserActionTask(parameter -> {
                    for (Entity en : entities) {
                        this.availableEntities.add(en.getClass2());
                        this.fqnEntityMap.put(en.getClass2(), en);
                        PersistentObject po = (PersistentObject)en;
                        ElementHandle teh = po.getTypeElementHandle();
                        TypeElement te = (TypeElement)teh.resolve((CompilationInfo)parameter);
                        this.fqnIdExistMap.put(en.getClass2(), JpaControllerUtil.haveId(te));
                        FileObject file = SourceUtils.getFile((ElementHandle)teh, (ClasspathInfo)parameter.getClasspathInfo());
                        if (!this.isEjbProjectEntity(ejbProjects, file)) continue;
                        this.ejbModuleInvolved = true;
                        LOG.log(Level.INFO, "Entity came from EJB module and mustn''t be visible on CP, entity={0}", en.getClass2());
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.availableEntities.removeAll(this.selectedEntities);
        this.changeSupport.fireChange();
    }

    private boolean isEjbProjectEntity(Set<Project> ejbProjects, FileObject fo) {
        for (Project relatedProject : ejbProjects) {
            if (!fo.getPath().startsWith(relatedProject.getProjectDirectory().getPath())) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public Set<String> getAvailableEntities() {
        return this.availableEntities;
    }

    public Set<Entity> getAvailableEntityInstances() {
        return this.availableEntityInstances;
    }

    public Set<String> getWantedEntities() {
        return this.wantedEntities;
    }

    public Set<String> getSelectedEntities() {
        return this.selectedEntities;
    }

    public boolean isEjbModuleInvolved() {
        return this.ejbModuleInvolved;
    }

    public void addEntities(Set<String> entities) {
        if (this.isClosureEnabled()) {
            if (this.wantedEntities.addAll(entities)) {
                try {
                    Set<String> refEntities = this.getReferencedEntitiesTransitively(entities);
                    HashSet<String> addedEntities = new HashSet<String>(entities);
                    addedEntities.addAll(refEntities);
                    this.selectedEntities.addAll(addedEntities);
                    this.referencedEntities.addAll(refEntities);
                    this.availableEntities.removeAll(addedEntities);
                    this.changeSupport.fireChange();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        } else {
            this.wantedEntities.addAll(entities);
            this.selectedEntities.addAll(entities);
            this.availableEntities.removeAll(entities);
            this.changeSupport.fireChange();
        }
    }

    public void removeEntities(Set<String> entities) {
        if (this.isClosureEnabled()) {
            if (this.wantedEntities.removeAll(entities)) {
                this.redoClosure();
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedEntities.removeAll(entities);
            this.selectedEntities.removeAll(entities);
            this.availableEntities.addAll(entities);
            this.changeSupport.fireChange();
        }
    }

    public void addAllEntities() {
        this.wantedEntities.addAll(this.availableEntities);
        if (this.isClosureEnabled()) {
            this.redoClosure();
            this.changeSupport.fireChange();
        } else {
            this.selectedEntities.addAll(this.wantedEntities);
            this.availableEntities.clear();
            this.changeSupport.fireChange();
        }
    }

    public void removeAllEntities() {
        this.availableEntities.addAll(this.selectedEntities);
        this.wantedEntities.clear();
        this.selectedEntities.clear();
        this.referencedEntities.clear();
        this.changeSupport.fireChange();
    }

    private Set<String> getReferencedEntitiesTransitively(Set<String> entities) throws IOException {
        Queue<String> entityQueue = new Queue<String>(entities);
        HashSet<String> refEntities = new HashSet<String>();
        while (!entityQueue.isEmpty()) {
            String entity = entityQueue.poll();
            Set<String> referenced = this.getReferencedEntities(entity);
            for (String refEntity : referenced) {
                if (!refEntity.equals(entity)) {
                    refEntities.add(refEntity);
                }
                entityQueue.offer(refEntity);
            }
        }
        return refEntities;
    }

    private Set<String> getReferencedEntities(final String entityClass) throws IOException {
        if (this.readHelper.getState() != MetadataModelReadHelper.State.FINISHED) {
            return Collections.emptySet();
        }
        JavaSource source = (JavaSource)this.model.runReadAction(metadata -> metadata.createJavaSource());
        final HashSet<String> result = new HashSet<String>();
        source.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController parameter) throws Exception {
                List<Entity> entities = EntityClosure.this.readHelper.getResult();
                HashSet<String> entitiesFqn = new HashSet<String>();
                for (Entity entity : entities) {
                    entitiesFqn.add(entity.getClass2());
                }
                TypeElement entity = parameter.getElements().getTypeElement(entityClass);
                for (Element element : parameter.getElements().getAllMembers(entity)) {
                    if (ElementKind.METHOD == element.getKind()) {
                        ExecutableType methodType = (ExecutableType)parameter.getTypes().asMemberOf((DeclaredType)entity.asType(), element);
                        TypeMirror returnType = methodType.getReturnType();
                        this.addTypeMirror(result, parameter, returnType, entitiesFqn);
                        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
                        for (TypeMirror typeMirror : parameterTypes) {
                            this.addTypeMirror(result, parameter, typeMirror, entitiesFqn);
                        }
                        continue;
                    }
                    if (ElementKind.FIELD != element.getKind()) continue;
                    TypeMirror typeMirror = parameter.getTypes().asMemberOf((DeclaredType)entity.asType(), element);
                    this.addTypeMirror(result, parameter, typeMirror, entitiesFqn);
                }
            }

            private void addTypeMirror(Set<String> result2, CompilationController parameter, TypeMirror typeMirror, Set<String> allEntitiesFqn) throws Exception {
                String fqn;
                Element typeElement = parameter.getTypes().asElement(typeMirror);
                if (typeElement instanceof TypeElement && allEntitiesFqn.contains(fqn = ((TypeElement)typeElement).getQualifiedName().toString())) {
                    result2.add(fqn);
                }
            }
        }, true);
        return result;
    }

    private void redoClosure() {
        HashSet<String> allEntities = new HashSet<String>(this.availableEntities);
        allEntities.addAll(this.selectedEntities);
        this.referencedEntities.clear();
        try {
            this.referencedEntities.addAll(this.getReferencedEntitiesTransitively(this.wantedEntities));
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.selectedEntities.clear();
        this.selectedEntities.addAll(this.wantedEntities);
        this.selectedEntities.addAll(this.referencedEntities);
        this.availableEntities.clear();
        this.availableEntities.addAll(allEntities);
        this.availableEntities.removeAll(this.selectedEntities);
    }

    public boolean isClosureEnabled() {
        return this.closureEnabled;
    }

    public void setClosureEnabled(boolean closureEnabled) {
        if (this.closureEnabled == closureEnabled) {
            return;
        }
        this.closureEnabled = closureEnabled;
        if (closureEnabled) {
            this.redoClosure();
        } else {
            HashSet<String> allEntities = new HashSet<String>(this.availableEntities);
            allEntities.addAll(this.selectedEntities);
            this.referencedEntities.clear();
            this.selectedEntities.clear();
            this.selectedEntities.addAll(this.wantedEntities);
            this.availableEntities.clear();
            this.availableEntities.addAll(allEntities);
            this.availableEntities.removeAll(this.selectedEntities);
        }
        this.changeSupport.fireChange();
    }

    public boolean isModelReady() {
        return this.modelReady;
    }

    void waitModelIsReady() {
        try {
            Future result = this.model.runReadActionWhenReady(metadata -> true);
            result.get();
        }
        catch (IOException | InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean isFieldAccess(String entity) throws MetadataModelException, IOException {
        Boolean result = (Boolean)this.model.runReadAction(metadata -> {
            for (Entity e : metadata.getRoot().getEntity()) {
                if (!e.getClass2().equals(entity)) continue;
                return e.getAccess().equals("FIELD");
            }
            return false;
        });
        return result;
    }

    Boolean haveId(String entityFqn) {
        return this.fqnIdExistMap.get(entityFqn);
    }

    Entity getEntity(String entityFqn) {
        return this.fqnEntityMap.get(entityFqn);
    }

    private Set<Project> getEjbModulesOfClasspath(ClassPath classPath) {
        HashSet<Project> ejbProjects = new HashSet<Project>();
        for (FileObject fileObject : classPath.getRoots()) {
            Project rootOwner = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (rootOwner == null || !Util.isEjbModule(rootOwner)) continue;
            ejbProjects.add(rootOwner);
        }
        return ejbProjects;
    }

    private static class EntityClosureComboBoxModel
    extends DefaultComboBoxModel
    implements ChangeListener {
        private EntityClosure entityClosure;
        private List<String> entities = new ArrayList<String>();

        EntityClosureComboBoxModel(EntityClosure entityClosure) {
            this.entityClosure = entityClosure;
            entityClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public int getSize() {
            return this.entities.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.entities.get(index);
        }

        public List<String> getEntityClasses() {
            return this.entities;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.entities = new ArrayList<String>(this.entityClosure.getAvailableEntities());
            Collections.sort(this.entities);
            this.fireContentsChanged(this, 0, Math.max(oldSize, this.getSize()));
        }
    }

    static final class Queue<T> {
        private final List<T> queue;
        private final Set<T> contents;
        private int currentIndex;

        public Queue(Set<T> initialContents) {
            assert (!initialContents.contains(null));
            this.queue = new ArrayList<T>(initialContents);
            this.contents = new HashSet<T>(initialContents);
        }

        public void offer(T element) {
            assert (element != null);
            if (!this.contents.contains(element)) {
                this.contents.add(element);
                this.queue.add(element);
            }
        }

        public boolean isEmpty() {
            return this.currentIndex >= this.queue.size();
        }

        public T poll() {
            T result = null;
            if (!this.isEmpty()) {
                result = this.queue.get(this.currentIndex);
                ++this.currentIndex;
            }
            return result;
        }
    }
}

