/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.openide.util.NbBundle;

class ToplinkProvider
extends Provider {
    private static final String PREFERRED_PROVIDER_CLASS = "oracle.toplink.essentials.PersistenceProvider";
    private static final String ALTERNATIVE_PROVIDER_CLASS = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String ECLIPSELINK_PROVIDER_CLASS = "org.eclipse.persistence.jpa.PersistenceProvider";

    static ToplinkProvider create(String version) {
        if (version != null && !"1.0".equals(version)) {
            return new ToplinkProvider(ECLIPSELINK_PROVIDER_CLASS, version);
        }
        return new ToplinkProvider(PREFERRED_PROVIDER_CLASS, version);
    }

    static ToplinkProvider create55Compatible() {
        return new ToplinkProvider(ALTERNATIVE_PROVIDER_CLASS, "1.0");
    }

    private ToplinkProvider(String providerClass, String version) {
        super(providerClass, version);
    }

    @Override
    public String getDisplayName() {
        String name = "1.0".equals(this.getVersion()) ? NbBundle.getMessage(ToplinkProvider.class, (String)"LBL_TopLinkEssentials") : NbBundle.getMessage(ToplinkProvider.class, (String)"LBL_TopLink");
        return name + (String)(this.getVersion() != null ? " (JPA " + this.getVersion() + ")" : "");
    }

    @Override
    public String getJdbcUrl() {
        return "toplink.jdbc.url";
    }

    @Override
    public String getJdbcDriver() {
        return "toplink.jdbc.driver";
    }

    @Override
    public String getJdbcUsername() {
        return "toplink.jdbc.user";
    }

    @Override
    public String getJdbcPassword() {
        return "toplink.jdbc.password";
    }

    @Override
    public String getTableGenerationPropertyName() {
        return "toplink.ddl-generation";
    }

    @Override
    public String getTableGenerationDropCreateValue() {
        return "drop-and-create-tables";
    }

    @Override
    public String getTableGenerationCreateValue() {
        return "create-tables";
    }

    @Override
    public Map getUnresolvedVendorSpecificProperties() {
        return Collections.emptyMap();
    }

    @Override
    public Map getDefaultVendorSpecificProperties() {
        return Collections.emptyMap();
    }
}

