/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JPAEditorUtil {
    public static final String JDBCURLKEY = "url";
    public static final String JDBCUSERKEY = "user";
    public static final String JDBCDRIVERKEY = "driver";

    public static JavaSource getJavaSource(Document doc) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)doc);
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        int n = 0;
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup[] sourceGroupArray = sourceGroups;
        int n2 = sourceGroupArray.length;
        if (n < n2) {
            SourceGroup sourceGroup = sourceGroupArray[n];
            return JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sourceGroup.getRootFolder()), (FileObject[])new FileObject[0]);
        }
        return null;
    }

    public static Node getClassNode(Node tag) {
        if (tag == null) {
            return null;
        }
        if (tag.getNodeName().equalsIgnoreCase("class") || tag.getNodeName().equalsIgnoreCase("subclass") || tag.getNodeName().equalsIgnoreCase("joined-subclass") || tag.getNodeName().equalsIgnoreCase("union-subclass")) {
            return tag;
        }
        Node current = tag;
        Node parent;
        while ((parent = current.getParentNode()) != null) {
            if (parent.getNodeName().equalsIgnoreCase("class") || parent.getNodeName().equalsIgnoreCase("subclass") || parent.getNodeName().equalsIgnoreCase("joined-subclass") || parent.getNodeName().equalsIgnoreCase("union-subclass")) {
                return parent;
            }
            if (parent.getNodeName().equalsIgnoreCase("hibernate-mapping")) {
                return null;
            }
            current = parent;
        }
        return null;
    }

    public static String getClassName(Node tag) {
        NamedNodeMap attribs;
        Node classNode = JPAEditorUtil.getClassNode(tag);
        if (classNode != null && (attribs = classNode.getAttributes()) != null && attribs.getNamedItem("name") != null) {
            return attribs.getNamedItem("name").getNodeValue();
        }
        return null;
    }

    public static String getTableName(Node tag) {
        NamedNodeMap attribs;
        Node classNode = JPAEditorUtil.getClassNode(tag);
        if (classNode != null && (attribs = classNode.getAttributes()) != null && attribs.getNamedItem("table") != null) {
            return attribs.getNamedItem("table").getNodeValue();
        }
        return null;
    }

    public static String getPersistencePropertyName(Node tag) {
        if (!tag.getNodeName().equalsIgnoreCase("property")) {
            return null;
        }
        NamedNodeMap attribs = tag.getAttributes();
        if (attribs != null && attribs.getNamedItem("name") != null) {
            return attribs.getNamedItem("name").getNodeValue();
        }
        return null;
    }

    public static TypeElement findClassElementByBinaryName(String binaryName, CompilationController cc) {
        PackageElement packElem;
        if (!binaryName.contains("$")) {
            return cc.getElements().getTypeElement(binaryName);
        }
        String packageName = "";
        int dotIndex = binaryName.lastIndexOf(46);
        if (dotIndex != -1) {
            packageName = binaryName.substring(0, dotIndex);
        }
        if ((packElem = cc.getElements().getPackageElement(packageName)) == null) {
            return null;
        }
        return (TypeElement)new BinaryNameTypeScanner().visit(packElem, binaryName);
    }

    public static void findAndOpenJavaClass(String classBinaryName, Document doc) {
        JavaSource js = JPAEditorUtil.getJavaSource(doc);
        if (js != null) {
            try {
                js.runUserActionTask(cc -> {
                    boolean opened = false;
                    TypeElement element = JPAEditorUtil.findClassElementByBinaryName(classBinaryName, cc);
                    if (element != null) {
                        opened = ElementOpen.open((ClasspathInfo)js.getClasspathInfo(), (Element)element);
                    }
                    if (!opened) {
                        String msg = NbBundle.getMessage(JPAEditorUtil.class, (String)"LBL_SourceNotFound", (Object)classBinaryName);
                        StatusDisplayer.getDefault().setStatusText(msg);
                    }
                }, false);
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static VariableElement findFieldElementOnType(ElementUtilities eu, TypeMirror type, String fieldName) {
        FieldAcceptor fieldAcceptor = new FieldAcceptor(fieldName);
        Iterable matchingProp = eu.getMembers(type, (ElementUtilities.ElementAcceptor)fieldAcceptor);
        Iterator it = matchingProp.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return (VariableElement)it.next();
    }

    public static DatabaseConnection findDatabaseConnection(PersistenceUnit pu, Project project) {
        DatabaseConnection dbcon = ProviderUtil.getConnection(pu);
        if (dbcon != null) {
            return dbcon;
        }
        String datasourceName = ProviderUtil.getDatasourceName(pu);
        if (datasourceName == null) {
            return null;
        }
        if (project == null) {
            return null;
        }
        JPADataSource datasource = null;
        JPADataSourceProvider dsProvider = (JPADataSourceProvider)project.getLookup().lookup(JPADataSourceProvider.class);
        if (dsProvider == null) {
            return null;
        }
        for (JPADataSource each : dsProvider.getDataSources()) {
            if (!datasourceName.equals(each.getJndiName())) continue;
            datasource = each;
        }
        if (datasource == null) {
            ErrorManager.getDefault().log(1, "The " + datasourceName + " was not found.");
            return null;
        }
        List<DatabaseConnection> dbconns = JPAEditorUtil.findDatabaseConnections(datasource);
        if (!dbconns.isEmpty()) {
            return dbconns.get(0);
        }
        return null;
    }

    public static HashMap<String, String> findDatabaseConnectionProperties(PersistenceUnit pu, Project project) {
        HashMap<String, String> props = ProviderUtil.getConnectionProperties(pu);
        if (props != null && !props.isEmpty()) {
            return props;
        }
        String datasourceName = ProviderUtil.getDatasourceName(pu);
        if (datasourceName == null) {
            return null;
        }
        if (project == null) {
            return null;
        }
        JPADataSource datasource = null;
        JPADataSourceProvider dsProvider = (JPADataSourceProvider)project.getLookup().lookup(JPADataSourceProvider.class);
        if (dsProvider == null) {
            return null;
        }
        for (JPADataSource each : dsProvider.getDataSources()) {
            if (!datasourceName.equals(each.getJndiName())) continue;
            datasource = each;
        }
        if (datasource == null) {
            ErrorManager.getDefault().log(1, "The " + datasourceName + " was not found.");
            return null;
        }
        props = new HashMap();
        props.put(JDBCURLKEY, datasource.getUrl());
        props.put(JDBCUSERKEY, datasource.getUsername());
        props.put(JDBCDRIVERKEY, datasource.getDriverClassName());
        return props;
    }

    private static List<DatabaseConnection> findDatabaseConnections(JPADataSource datasource) {
        if (datasource == null) {
            throw new NullPointerException("The datasource parameter cannot be null.");
        }
        String databaseUrl = datasource.getUrl();
        String user = datasource.getUsername();
        if (databaseUrl == null || user == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseConnection> result = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection dbconn : ConnectionManager.getDefault().getConnections()) {
            if (!databaseUrl.equals(dbconn.getDatabaseURL()) || !user.equals(dbconn.getUser())) continue;
            result.add(dbconn);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private static class BinaryNameTypeScanner
    extends SimpleElementVisitor6<TypeElement, String> {
        private BinaryNameTypeScanner() {
        }

        @Override
        public TypeElement visitPackage(PackageElement packElem, String binaryName) {
            for (Element element : packElem.getEnclosedElements()) {
                TypeElement ret;
                if (!element.getKind().isClass() || (ret = element.accept(this, binaryName)) == null) continue;
                return ret;
            }
            return null;
        }
    }

    private static class FieldAcceptor
    implements ElementUtilities.ElementAcceptor {
        private String fieldName;

        public FieldAcceptor(String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean accept(Element e, TypeMirror type) {
            if (e.getKind() != ElementKind.FIELD) {
                return false;
            }
            return e.getSimpleName().toString().equals(this.fieldName);
        }
    }
}

