/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableProvider;
import org.openide.filesystems.FileObject;

public class DBSchemaTableProvider
implements TableProvider {
    private final SchemaElement schemaElement;
    private final PersistenceGenerator persistenceGen;
    private final Set<Table> tables;
    private Set<String> tablesReferecedByOtherTables;
    private Project project;

    public DBSchemaTableProvider(SchemaElement schemaElement, PersistenceGenerator persistenceGen) {
        this(schemaElement, persistenceGen, null);
    }

    public DBSchemaTableProvider(SchemaElement schemaElement, PersistenceGenerator persistenceGen, Project project) {
        this.schemaElement = schemaElement;
        this.project = project;
        this.persistenceGen = persistenceGen;
        this.tablesReferecedByOtherTables = DbSchemaEjbGenerator.getTablesReferecedByOtherTables(schemaElement);
        this.tables = this.buildTables();
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    private Set<Table> buildTables() {
        HashMap<String, DBSchemaTable> name2Table = new HashMap<String, DBSchemaTable>();
        HashMap name2Referenced = new HashMap();
        HashMap name2ReferencedBy = new HashMap();
        HashMap name2Join = new HashMap();
        Sources tableElements = this.schemaElement.getTables();
        ClassPath source = null;
        if (this.project != null) {
            Sources sources = ProjectUtils.getSources((Project)this.project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            SourceGroup firstGroup = groups[0];
            FileObject fo = firstGroup.getRootFolder();
            source = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        }
        for (Sources tableElement : tableElements) {
            boolean join = DbSchemaEjbGenerator.isJoinTable((TableElement)tableElement, this.tablesReferecedByOtherTables);
            List<Table.DisabledReason> disabledReasons = DBSchemaTableProvider.getDisabledReasons((TableElement)tableElement, this.persistenceGen, source);
            Table.DisabledReason disabledReason = null;
            for (Table.DisabledReason reason : disabledReasons) {
                if (join && reason instanceof Table.NoPrimaryKeyDisabledReason) continue;
                disabledReason = reason;
                break;
            }
            String catalogName = tableElement.getDeclaringSchema().getCatalog().getName();
            String schemaName = tableElement.getDeclaringSchema().getSchema().getName();
            String tableName = tableElement.getName().getName();
            DBSchemaTable table = new DBSchemaTable(catalogName, schemaName, tableName, join, disabledReason, this.persistenceGen, tableElement.isTable());
            table.setUniqueConstraints(this.getUniqueConstraints((TableElement)tableElement));
            name2Table.put(tableName, table);
            name2Referenced.put(tableName, new HashSet());
            name2ReferencedBy.put(tableName, new HashSet());
            name2Join.put(tableName, new HashSet());
        }
        for (Sources tableElement : tableElements) {
            if (!tableElement.isTable()) continue;
            String tableName = tableElement.getName().getName();
            Table table = (Table)name2Table.get(tableName);
            ForeignKeyElement[] foreignKeyElements = tableElement.getForeignKeys();
            if (foreignKeyElements == null) continue;
            for (ForeignKeyElement foreignKeyElement : foreignKeyElements) {
                TableElement referencedTableElement = foreignKeyElement.getReferencedTable();
                String referencedTableName = referencedTableElement.getName().getName();
                Table referencedTable = (Table)name2Table.get(referencedTableName);
                ((Set)name2Referenced.get(tableName)).add(referencedTable);
                ((Set)name2ReferencedBy.get(referencedTableName)).add(table);
                if (!table.isJoin()) continue;
                ((Set)name2Join.get(referencedTableName)).add(table);
            }
        }
        HashSet<DBSchemaTable> result = new HashSet<DBSchemaTable>();
        for (DBSchemaTable table : name2Table.values()) {
            String tableName = table.getName();
            table.setReferencedTables(Collections.unmodifiableSet((Set)name2Referenced.get(tableName)));
            table.setReferencedByTables(Collections.unmodifiableSet((Set)name2ReferencedBy.get(tableName)));
            table.setJoinTables(Collections.unmodifiableSet((Set)name2Join.get(tableName)));
            result.add(table);
        }
        return Collections.unmodifiableSet(result);
    }

    private Set<List<String>> getUniqueConstraints(TableElement tableElement) {
        HashSet<List<String>> uniqueConstraintsCols = new HashSet<List<String>>();
        UniqueKeyElement[] uks = tableElement.getUniqueKeys();
        for (int ukIx = 0; ukIx < uks.length; ++ukIx) {
            ColumnElement[] colElms;
            if (uks[ukIx].isPrimaryKey() || (colElms = uks[ukIx].getColumns()) == null || colElms.length == 0) continue;
            ArrayList<String> cols = new ArrayList<String>();
            for (int cIx = 0; cIx < colElms.length; ++cIx) {
                cols.add(colElms[cIx].getName().getName());
            }
            uniqueConstraintsCols.add(cols);
        }
        return uniqueConstraintsCols;
    }

    private static List<Table.DisabledReason> getDisabledReasons(TableElement tableElement, PersistenceGenerator persistenceGen, ClassPath source) {
        String fqClassName;
        ArrayList<Table.DisabledReason> result = new ArrayList<Table.DisabledReason>();
        if (tableElement.isTable() && DBSchemaTableProvider.hasNoPrimaryKey(tableElement)) {
            result.add(new Table.NoPrimaryKeyDisabledReason());
        }
        if ((fqClassName = persistenceGen.getFQClassName(tableElement.getName().getName())) != null) {
            if (source == null || source.findResource(fqClassName.replace('.', '/') + ".java") != null) {
                result.add(new Table.ExistingDisabledReason(fqClassName));
            } else {
                result.add(new Table.ExistingNotInSourceDisabledReason(fqClassName));
            }
        }
        return result;
    }

    private static boolean hasNoPrimaryKey(TableElement tableElement) {
        return tableElement.getPrimaryKey() == null;
    }

    private static final class DBSchemaTable
    extends Table {
        private Set<Table> referencedTables;
        private Set<Table> referencedByTables;
        private Set<Table> joinTables;
        private Set<List<String>> uniqueConstraints;

        public DBSchemaTable(String catalog, String schema, String name, boolean join, Table.DisabledReason disabledReason, PersistenceGenerator persistenceGen) {
            super(catalog, schema, name, join, disabledReason);
        }

        public DBSchemaTable(String catalog, String schema, String name, boolean join, Table.DisabledReason disabledReason, PersistenceGenerator persistenceGen, boolean isTable) {
            super(catalog, schema, name, join, disabledReason, isTable);
        }

        @Override
        public Set<Table> getReferencedTables() {
            return this.referencedTables;
        }

        private void setReferencedTables(Set<Table> referencedTables) {
            this.referencedTables = referencedTables;
        }

        @Override
        public Set<Table> getReferencedByTables() {
            return this.referencedByTables;
        }

        private void setReferencedByTables(Set<Table> referencedByTables) {
            this.referencedByTables = referencedByTables;
        }

        @Override
        public Set<Table> getJoinTables() {
            return this.joinTables;
        }

        private void setJoinTables(Set<Table> joinTables) {
            this.joinTables = joinTables;
        }

        @Override
        public Set<List<String>> getUniqueConstraints() {
            return this.uniqueConstraints;
        }

        public void setUniqueConstraints(Set<List<String>> constraints) {
            this.uniqueConstraints = constraints;
        }
    }
}

