/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.DelegatingWizardDescriptorPanel;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.EntityMethodGenerator;
import org.netbeans.modules.j2ee.persistence.util.JPAClassPathHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class EntityWizard
implements WizardDescriptor.InstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private EntityWizardDescriptor ejbPanel;
    private PersistenceUnitWizardDescriptor puPanel;
    private WizardDescriptor wiz;
    private SourceGroup[] sourceGroups;

    public static EntityWizard create() {
        return new EntityWizard();
    }

    public String name() {
        return NbBundle.getMessage(EntityWizard.class, (String)"LBL_EntityEJBWizardTitle");
    }

    public void uninitialize(WizardDescriptor wiz) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        ValidatingPanel targetChooserPanel;
        this.wiz = wizardDescriptor;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        Sources sources = ProjectUtils.getSources((Project)project);
        this.sourceGroups = sources.getSourceGroups("java");
        this.ejbPanel = new EntityWizardDescriptor();
        if (this.sourceGroups.length == 0) {
            this.sourceGroups = sources.getSourceGroups("generic");
            targetChooserPanel = new ValidatingPanel(Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])this.sourceGroups).bottomPanel((WizardDescriptor.Panel)this.ejbPanel).create());
        } else {
            targetChooserPanel = new ValidatingPanel(JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])this.sourceGroups, (WizardDescriptor.Panel)this.ejbPanel, (boolean)true));
        }
        boolean noPuNeeded = true;
        try {
            noPuNeeded = ProviderUtil.persistenceExists(project, Templates.getTargetFolder((WizardDescriptor)this.wiz)) || !ProviderUtil.isValidServerInstanceOrNone(project);
        }
        catch (RuntimeException | InvalidPersistenceXmlException ex) {
            Logger.getLogger(EntityWizard.class.getName()).log(Level.FINE, "Invalid persistence.xml");
        }
        if (noPuNeeded) {
            this.panels = new WizardDescriptor.Panel[]{targetChooserPanel};
        } else {
            this.puPanel = new PersistenceUnitWizardDescriptor(project);
            this.panels = new WizardDescriptor.Panel[]{targetChooserPanel, this.puPanel};
        }
        Wizards.mergeSteps((WizardDescriptor)this.wiz, (WizardDescriptor.Panel[])this.panels, null);
    }

    public Set instantiate() throws IOException {
        FileObject result = EntityWizard.generateEntity(Templates.getTargetFolder((WizardDescriptor)this.wiz), Templates.getTargetName((WizardDescriptor)this.wiz), this.ejbPanel.getPrimaryKeyClassName(), true);
        try {
            boolean isCreatePU = this.ejbPanel.isCreatePU();
            Project project = Templates.getProject((WizardDescriptor)this.wiz);
            if (isCreatePU) {
                PersistenceUnit punit = Util.buildPersistenceUnitUsingData(project, this.puPanel.getPersistenceUnitName(), this.puPanel.getPersistenceConnection() != null ? this.puPanel.getPersistenceConnection().getName() : this.puPanel.getDatasource(), PersistenceUnitWizardPanel.TableGeneration.NONE, this.puPanel.getSelectedProvider());
                ProviderUtil.setTableGeneration(punit, this.puPanel.getTableGeneration(), this.puPanel.getSelectedProvider());
                if (punit != null) {
                    Util.addPersistenceUnitToProjectRoot(project, result, punit);
                }
            } else {
                Util.addPersistenceUnitToProject(project);
            }
            this.addEntityToPersistenceUnit(result);
            PersistenceUtils.logUsage(EntityWizard.class, "USG_PERSISTENCE_ENTITY", null);
        }
        catch (InvalidPersistenceXmlException ipx) {
            Logger.getLogger(EntityWizard.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + ipx.getPath(), ipx);
        }
        return Collections.singleton(result);
    }

    private void addEntityToPersistenceUnit(FileObject entity) throws InvalidPersistenceXmlException {
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        if (project != null) {
            String entityFQN = "";
            ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
            if (classPathProvider != null) {
                ClassPath clsPath = classPathProvider.findClassPath(entity, "classpath/source");
                if (clsPath == null) {
                    return;
                }
                entityFQN = clsPath.getResourceName(entity, '.', false);
            }
            if (!(Util.isSupportedJavaEEVersion(project) && Util.isContainerManaged(project) || ProviderUtil.getDDFile(project, entity) == null)) {
                PUDataObject pudo = ProviderUtil.getPUDataObject(project, entity, null);
                try {
                    PersistenceUnit[] pu = pudo.getPersistence().getPersistenceUnit();
                    if (pu.length == 1) {
                        pudo.addClass(pu[0], entityFQN, false);
                    }
                }
                catch (RuntimeException ex) {
                    Logger.getLogger(EntityWizard.class.getName()).log(Level.FINE, "Invalid persistence.xml");
                }
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1 && this.ejbPanel.isCreatePU();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public static FileObject generateEntity(FileObject targetFolder, String targetName, String primaryKeyClassName, boolean isAccessProperty) throws IOException {
        FileObject entityFo = GenerationUtils.createClass((FileObject)targetFolder, (String)targetName, null);
        ClassPath boot = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/boot");
        ClassPath moduleBoot = ClassPath.getClassPath((FileObject)targetFolder, (String)"modules/boot");
        ClassPath compile = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/compile");
        ClassPath moduleCompile = ClassPath.getClassPath((FileObject)targetFolder, (String)"modules/compile");
        ClassPath moduleClass = ClassPath.getClassPath((FileObject)targetFolder, (String)"modules/classpath");
        ClassPath source = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/source");
        ClassPath moduleSource = ClassPath.getClassPath((FileObject)targetFolder, (String)"modules/source");
        JPAClassPathHelper cpHelper = new JPAClassPathHelper(Collections.singleton(boot), Collections.singleton(compile), Collections.singleton(source)).setModuleBootPaths(moduleBoot != null ? Collections.singleton(moduleBoot) : null).setModuleCompilePaths(moduleCompile != null ? Collections.singleton(moduleCompile) : null).setModuleClassPaths(moduleClass != null ? Collections.singleton(moduleClass) : null).setModuleSourcePaths(moduleSource != null ? Collections.singleton(moduleSource) : null);
        JavaSource targetSource = JavaSource.create((ClasspathInfo)cpHelper.createClasspathInfo(), (FileObject[])new FileObject[]{entityFo});
        Task task = workingCopy -> {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
            assert (typeElement != null);
            ClassTree clazz = workingCopy.getTrees().getTree(typeElement);
            GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
            ClassTree modifiedClazz = genUtils.ensureNoArgConstructor(clazz);
            TreeMaker make = workingCopy.getTreeMaker();
            String idFieldName = "id";
            TypeMirror type = workingCopy.getTreeUtilities().parseType(primaryKeyClassName, typeElement);
            Tree typeTree = make.Type(type);
            EnumSet<Modifier> serialVersionUIDModifiers = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
            VariableTree serialVersionUID = make.Variable(make.Modifiers(serialVersionUIDModifiers), (CharSequence)"serialVersionUID", genUtils.createType("long", typeElement), (ExpressionTree)make.Literal((Object)Long.valueOf("1")));
            VariableTree idField = make.Variable(genUtils.createModifiers(Modifier.PRIVATE), (CharSequence)idFieldName, typeTree, null);
            ModifiersTree idMethodModifiers = genUtils.createModifiers(Modifier.PUBLIC);
            MethodTree idGetter = genUtils.createPropertyGetterMethod(idMethodModifiers, idFieldName, typeTree);
            MethodTree idSetter = genUtils.createPropertySetterMethod(idMethodModifiers, idFieldName, typeTree);
            AnnotationTree idAnnotation = genUtils.createAnnotation("javax.persistence.Id");
            ExpressionTree generationStrategy = genUtils.createAnnotationArgument("strategy", "javax.persistence.GenerationType", "AUTO");
            AnnotationTree generatedValueAnnotation = genUtils.createAnnotation("javax.persistence.GeneratedValue", Collections.singletonList(generationStrategy));
            if (isAccessProperty) {
                idField = genUtils.addAnnotation(idField, idAnnotation);
                idField = genUtils.addAnnotation(idField, generatedValueAnnotation);
            } else {
                idGetter = genUtils.addAnnotation(idGetter, idAnnotation);
                idGetter = genUtils.addAnnotation(idGetter, generatedValueAnnotation);
            }
            ArrayList<VariableTree> classFields = new ArrayList<VariableTree>();
            classFields.add(serialVersionUID);
            classFields.add(idField);
            modifiedClazz = genUtils.addClassFields(clazz, classFields);
            modifiedClazz = make.addClassMember(modifiedClazz, (Tree)idGetter);
            modifiedClazz = make.addClassMember(modifiedClazz, (Tree)idSetter);
            modifiedClazz = genUtils.addImplementsClause(modifiedClazz, "java.io.Serializable");
            modifiedClazz = genUtils.addAnnotation(modifiedClazz, genUtils.createAnnotation("javax.persistence.Entity"));
            String entityClassFqn = typeElement.getQualifiedName().toString();
            EntityMethodGenerator methodGenerator = new EntityMethodGenerator((WorkingCopy)workingCopy, genUtils, typeElement);
            List<VariableTree> fieldsForEquals = Collections.singletonList(idField);
            modifiedClazz = make.addClassMember(modifiedClazz, (Tree)methodGenerator.createHashCodeMethod(fieldsForEquals));
            modifiedClazz = make.addClassMember(modifiedClazz, (Tree)methodGenerator.createEqualsMethod(targetName, fieldsForEquals));
            modifiedClazz = make.addClassMember(modifiedClazz, (Tree)methodGenerator.createToStringMethod(entityClassFqn, fieldsForEquals));
            workingCopy.rewrite((Tree)clazz, (Tree)modifiedClazz);
        };
        if (targetSource == null) {
            Logger.getLogger(EntityWizard.class.getName()).log(Level.WARNING, "Classpaths compile, boot, source: {0},{1},{2}; target folder is valid, entity fo is valid: {3},{4}", new Object[]{compile, boot, source, targetFolder.isValid(), entityFo.isValid()});
            return entityFo;
        }
        targetSource.runModificationTask(task).commit();
        return entityFo;
    }

    private static final class ValidatingPanel
    extends DelegatingWizardDescriptorPanel {
        public ValidatingPanel(WizardDescriptor.Panel delegate) {
            super(delegate);
        }

        public boolean isValid() {
            boolean valid = super.isValid();
            if (!ProviderUtil.isValidServerInstanceOrNone(this.getProject())) {
                this.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_MissingServer"));
            }
            return valid;
        }
    }
}

