/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.persistence.dd.common.ParseUtils;
import org.openide.filesystems.FileObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JPAParseUtils {
    private static final Logger LOGGER = Logger.getLogger(JPAParseUtils.class.getName());

    public static String getVersion(InputStream is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static String getVersion(InputSource is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static SAXParseException parse(FileObject fo) throws SAXException, IOException {
        return JPAParseUtils.parse(new InputSource(fo.getInputStream()));
    }

    public static SAXParseException parse(InputSource is) throws SAXException, IOException {
        return ParseUtils.parseDD(is, DDResolver.getInstance());
    }

    public static SAXParseException parse(InputSource is, EntityResolver resolver) throws SAXException, IOException {
        return ParseUtils.parseDD(is, resolver);
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Resolving entity [publicId: ''{0}'', systemId: ''{1}'']", new Object[]{publicId, systemId});
            }
            String resource = null;
            if (systemId != null && systemId.endsWith("persistence_3_0.xsd")) {
                resource = "/org/netbeans/modules/j2ee/persistence/dd/resources/persistence_3_0.xsd";
            } else if (systemId != null && systemId.endsWith("persistence_2_2.xsd")) {
                resource = "/org/netbeans/modules/j2ee/persistence/dd/resources/persistence_2_2.xsd";
            } else if (systemId != null && systemId.endsWith("persistence_2_1.xsd")) {
                resource = "/org/netbeans/modules/j2ee/persistence/dd/resources/persistence_2_1.xsd";
            } else if (systemId != null && systemId.endsWith("persistence_2_0.xsd")) {
                resource = "/org/netbeans/modules/j2ee/persistence/dd/resources/persistence_2_0.xsd";
            } else if (systemId != null && systemId.endsWith("persistence_1_0.xsd")) {
                resource = "/org/netbeans/modules/j2ee/persistence/dd/resources/persistence_1_0.xsd";
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Got resource: {0}", resource);
            }
            if (resource == null) {
                return null;
            }
            URL url = this.getClass().getResource(resource);
            return new InputSource(url.toString());
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        private VersionHandler() {
        }

        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            if ("persistence".equals(rawName)) {
                String version = atts.getValue("version");
                throw new SAXException("version:" + (version == null ? "3.1" : version));
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return super.resolveEntity(publicId, systemId);
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            if ("persistence".equals(qName)) {
                String version = attributes.getValue("version");
                throw new SAXException("version:" + (version == null ? "3.1" : version));
            }
        }
    }
}

