/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class PersistenceUtils {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.j2ee.persistence");
    private static final Logger LOG = Logger.getLogger(PersistenceUtils.class.getName());

    public static EntityMappings getEntityMappings(FileObject documentFO) {
        Project project = FileOwnerQuery.getOwner((FileObject)documentFO);
        if (project == null) {
            return null;
        }
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)project.getProjectDirectory());
        if (entityClassScope == null) {
            return null;
        }
        MetadataModel model = entityClassScope.getEntityMappingsModel(true);
        EntityMappings mappings = null;
        try {
            mappings = (EntityMappings)model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, EntityMappings>(){

                public EntityMappings run(EntityMappingsMetadata metadata) throws Exception {
                    return metadata.getRoot();
                }
            });
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return mappings;
    }

    private PersistenceUtils() {
    }

    public static PersistenceUnit[] getPersistenceUnits(FileObject sourceFile) throws IOException {
        if (sourceFile == null) {
            throw new NullPointerException("The sourceFile parameter cannot be null");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)sourceFile);
        if (project == null) {
            return new PersistenceUnit[0];
        }
        ArrayList<PersistenceUnit> result = new ArrayList<PersistenceUnit>();
        ClassPath cp = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/source");
        for (PersistenceScope persistenceScope : PersistenceUtils.getPersistenceScopes(project, cp != null ? cp.findOwnerRoot(sourceFile) : null)) {
            Persistence persistence = null;
            try {
                persistence = PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml());
            }
            catch (RuntimeException ex) {
                LOG.log(Level.INFO, null, ex);
            }
            if (persistence == null) continue;
            result.addAll(Arrays.asList(persistence.getPersistenceUnit()));
        }
        return result.toArray(new PersistenceUnit[result.size()]);
    }

    public static Entity getEntity(String className, EntityMappings entityMappings) {
        if (className == null) {
            throw new NullPointerException("The javaClass parameter cannot be null");
        }
        if (entityMappings == null) {
            throw new NullPointerException("The entityMappings parameter cannot be null");
        }
        for (Entity entity : entityMappings.getEntity()) {
            if (!className.equals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static PersistenceScope[] getPersistenceScopes(Project project) {
        return PersistenceUtils.getPersistenceScopes(project, null);
    }

    public static PersistenceScope[] getPersistenceScopes(Project project, FileObject fo) {
        if (project == null) {
            throw new NullPointerException("The project parameter cannot be null");
        }
        PersistenceScopes persistenceScopes = PersistenceScopes.getPersistenceScopes((Project)project, (FileObject)fo);
        if (persistenceScopes != null) {
            return persistenceScopes.getPersistenceScopes();
        }
        return new PersistenceScope[0];
    }

    public static String getJPAVersion(Project target) {
        String version = null;
        Sources sources = ProjectUtils.getSources((Project)target);
        SourceGroup[] groups = sources.getSourceGroups("java");
        SourceGroup firstGroup = groups[0];
        FileObject fo = firstGroup.getRootFolder();
        ClassPath compile = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
        if (compile.findResource("javax/persistence/criteria/CriteriaUpdate.class") != null) {
            version = "2.1";
        } else if (compile.findResource("javax/persistence/criteria/JoinType.class") != null) {
            version = "2.0";
        } else if (compile.findResource("javax/persistence/Entity.class") != null) {
            version = "1.0";
        }
        return version;
    }

    public static String getJPAVersion(Library lib) {
        List roots = lib.getContent("classpath");
        ClassPath cp = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
        String version = null;
        if (cp.findResource("javax/persistence/criteria/CriteriaUpdate.class") != null) {
            version = "2.1";
        } else if (cp.findResource("javax/persistence/criteria/JoinType.class") != null) {
            version = "2.0";
        } else if (cp.findResource("javax/persistence/Entity.class") != null) {
            version = "1.0";
        }
        return version;
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }
}

