/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.common;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;

public class Utilities {
    public static AnnotationMirror findAnnotation(Element element, String annotationClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClass.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static List<AnnotationMirror> findAnnotations(Element element, String annotationClass) {
        ArrayList<AnnotationMirror> ret = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClass.equals(annotationMirror.getAnnotationType().toString())) continue;
            ret.add(annotationMirror);
        }
        return ret;
    }

    public static boolean hasAnnotation(Element element, String annClass) {
        AnnotationMirror annEntity = Utilities.findAnnotation(element, annClass);
        return annEntity != null;
    }

    public static AnnotationValue getAnnotationAttrValue(AnnotationMirror ann, String attrName) {
        if (ann != null) {
            for (ExecutableElement executableElement : ann.getElementValues().keySet()) {
                if (!attrName.equals(executableElement.getSimpleName().toString())) continue;
                return ann.getElementValues().get(executableElement);
            }
        }
        return null;
    }

    public static TextSpan getUnderlineSpan(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        Tree startSearchingForNameIndentifierBehindThisTree = null;
        if (tree != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                startSearchingForNameIndentifierBehindThisTree = ((ClassTree)tree).getModifiers();
            } else if (tree.getKind() == Tree.Kind.METHOD) {
                startSearchingForNameIndentifierBehindThisTree = ((MethodTree)tree).getReturnType();
            } else if (tree.getKind() == Tree.Kind.VARIABLE) {
                startSearchingForNameIndentifierBehindThisTree = ((VariableTree)tree).getType();
            }
            if (startSearchingForNameIndentifierBehindThisTree != null) {
                int searchStart = (int)srcPos.getEndPosition(info.getCompilationUnit(), startSearchingForNameIndentifierBehindThisTree);
                TokenSequence tokenSequence = info.getTreeUtilities().tokensFor(tree);
                if (tokenSequence != null) {
                    boolean eob = false;
                    tokenSequence.move(searchStart);
                    do {
                        boolean bl = eob = !tokenSequence.moveNext();
                    } while (!eob && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                    if (!eob) {
                        Token identifier = tokenSequence.token();
                        startOffset = identifier.offset(info.getTokenHierarchy());
                        endOffset = startOffset + identifier.length();
                    }
                }
            }
        }
        return new TextSpan(startOffset, endOffset);
    }

    public static String getShortClassName(String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

