/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.fixes.MakeClassPublic;
import org.netbeans.modules.j2ee.ejbverification.fixes.RemoveModifier;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;

public final class LegalModifiers {
    private LegalModifiers() {
    }

    public static Collection<ErrorDescription> run(HintContext hintContext) {
        EJBProblemContext ctx = HintsUtils.getOrCacheContext(hintContext);
        if (ctx != null && ctx.getEjb() != null) {
            ErrorDescription err;
            Object fix;
            LinkedList<ErrorDescription> problemsFounds = new LinkedList<ErrorDescription>();
            Set<Modifier> modifiers = ctx.getClazz().getModifiers();
            if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                fix = new MakeClassPublic(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)ctx.getClazz()));
                err = HintsUtils.createProblem((Element)ctx.getClazz(), hintContext.getInfo(), Bundle.LegalModifiers_BeanClassMustBePublic(), fix);
                problemsFounds.add(err);
            }
            if (modifiers.contains((Object)Modifier.FINAL)) {
                fix = new RemoveModifier(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)ctx.getClazz()), Modifier.FINAL);
                err = HintsUtils.createProblem((Element)ctx.getClazz(), hintContext.getInfo(), Bundle.LegalModifiers_BeanClassNotBeFinal(), fix);
                problemsFounds.add(err);
            }
            if (modifiers.contains((Object)Modifier.ABSTRACT)) {
                if (LegalModifiers.isInterface(hintContext.getInfo(), ctx.getClazz())) {
                    ErrorDescription err2 = HintsUtils.createProblem(ctx.getClazz(), hintContext.getInfo(), Bundle.LegalModifiers_BeanClassNotBeAbstract());
                    problemsFounds.add(err2);
                } else {
                    fix = new RemoveModifier(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)ctx.getClazz()), Modifier.ABSTRACT);
                    err = HintsUtils.createProblem((Element)ctx.getClazz(), hintContext.getInfo(), Bundle.LegalModifiers_BeanClassNotBeAbstract(), fix);
                    problemsFounds.add(err);
                }
            }
            return problemsFounds;
        }
        return Collections.emptyList();
    }

    private static boolean isInterface(CompilationInfo info, TypeElement clazz) {
        ClassTree classTree = info.getTrees().getTree(clazz);
        return classTree.getKind() == Tree.Kind.INTERFACE;
    }
}

