/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.common.xmlutils;

import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.ElementAttrInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLJ2eeUtils {
    public static void updateDocument(javax.swing.text.Document doc, String newDoc, String prefixMark) throws BadLocationException {
        int origLen = doc.getLength();
        String origDoc = doc.getText(0, origLen);
        int prefixInd = 0;
        if (prefixMark != null) {
            prefixInd = origDoc.indexOf(prefixMark);
            if (prefixInd > 0) {
                origDoc = doc.getText(prefixInd, origLen -= prefixInd);
            } else {
                prefixInd = 0;
            }
            int prefixIndNewDoc = newDoc.indexOf(prefixMark);
            if (prefixIndNewDoc > 0) {
                newDoc = newDoc.substring(prefixIndNewDoc);
            }
        }
        int newLen = newDoc.length();
        if (origDoc.equals(newDoc)) {
            return;
        }
        int granularity = 20;
        int prefix = -1;
        int postfix = -1;
        String toInsert = newDoc;
        if (origLen > 20 && newLen > 20) {
            int pos1;
            block18: {
                pos1 = 0;
                int len = Math.min(origLen, newLen);
                while (origDoc.regionMatches(pos1, newDoc, pos1, 20) && (pos1 += 20) + 20 < len) {
                }
                if (pos1 > 0) {
                    prefix = pos1;
                }
                pos1 = origLen - 20;
                int pos2 = newLen - 20;
                while (origDoc.regionMatches(pos1, newDoc, pos2, 20)) {
                    pos2 -= 20;
                    if ((pos1 -= 20) < 0) {
                        pos1 += 20;
                    } else {
                        if (pos2 >= 0) continue;
                        pos2 += 20;
                    }
                    break block18;
                }
                pos1 += 20;
                pos2 += 20;
            }
            if (pos1 < origLen - 20) {
                postfix = pos1;
            }
        }
        if (prefix != -1 && postfix != -1) {
            int delta;
            if (postfix < prefix) {
                postfix = prefix;
            }
            if ((delta = prefix + (origLen - postfix) - newLen) > 0) {
                postfix += delta;
            }
        }
        int removeBeginIndex = prefix == -1 ? 0 : prefix;
        int removeEndIndex = postfix == -1 ? origLen - 1 : postfix;
        doc.remove(prefixInd + removeBeginIndex, removeEndIndex - removeBeginIndex);
        if (toInsert.length() > 0) {
            int p1 = prefix == -1 ? 0 : prefix;
            int p2 = toInsert.length();
            if (postfix != -1) {
                p2 -= origLen - postfix;
            }
            if (p2 > p1) {
                toInsert = toInsert.substring(p1, p2);
                doc.insertString(prefixInd + removeBeginIndex, toInsert, null);
            }
        }
    }

    public static void replaceDocument(javax.swing.text.Document doc, String newDoc, String prefixMark) throws BadLocationException {
        int removeBeginIndex;
        int origLen = doc.getLength();
        String origDoc = doc.getText(0, origLen);
        int prefixInd = 0;
        if (prefixMark != null) {
            prefixInd = origDoc.indexOf(prefixMark);
            if (prefixInd > 0) {
                origDoc = doc.getText(prefixInd, origLen -= prefixInd);
            } else {
                prefixInd = 0;
            }
            int prefixIndNewDoc = newDoc.indexOf(prefixMark);
            if (prefixIndNewDoc > 0) {
                newDoc = newDoc.substring(prefixIndNewDoc);
            }
        }
        newDoc = XMLJ2eeUtils.filterEndLines(newDoc);
        int newLen = newDoc.length();
        if (origDoc.equals(newDoc)) {
            return;
        }
        int granularity = 20;
        int prefix = -1;
        int postfix = -1;
        String toInsert = newDoc;
        if (origLen > 20 && newLen > 20) {
            int pos1;
            block18: {
                pos1 = 0;
                int len = Math.min(origLen, newLen);
                while (origDoc.regionMatches(pos1, newDoc, pos1, 20) && (pos1 += 20) + 20 < len) {
                }
                if (pos1 > 0) {
                    prefix = pos1;
                }
                pos1 = origLen - 20;
                int pos2 = newLen - 20;
                while (origDoc.regionMatches(pos1, newDoc, pos2, 20)) {
                    pos2 -= 20;
                    if ((pos1 -= 20) < 0) {
                        pos1 += 20;
                    } else {
                        if (pos2 >= 0) continue;
                        pos2 += 20;
                    }
                    break block18;
                }
                pos1 += 20;
                pos2 += 20;
            }
            if (pos1 < origLen - 20) {
                postfix = pos1;
            }
        }
        if (prefix != -1 && postfix != -1) {
            int delta;
            if (postfix < prefix) {
                postfix = prefix;
            }
            if ((delta = prefix + (origLen - postfix) - newLen) > 0) {
                postfix += delta;
            }
        }
        int n = removeBeginIndex = prefix == -1 ? 0 : prefix;
        int removeEndIndex = postfix == -1 ? (doc.getText(0, doc.getLength()).charAt(doc.getLength() - 1) == '>' ? origLen : origLen - 1) : postfix;
        doc.remove(prefixInd + removeBeginIndex, removeEndIndex - removeBeginIndex);
        if (toInsert.length() > 0) {
            int p1 = prefix == -1 ? 0 : prefix;
            int p2 = toInsert.length();
            if (postfix != -1) {
                p2 -= origLen - postfix;
            }
            if (p2 > p1) {
                toInsert = toInsert.substring(p1, p2);
                doc.insertString(prefixInd + removeBeginIndex, toInsert, null);
            }
        }
    }

    public static void replaceDocument(javax.swing.text.Document doc, String newDoc) throws BadLocationException {
        XMLJ2eeUtils.replaceDocument(doc, newDoc, null);
    }

    public static String filterEndLines(String str) {
        char[] text = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < text.length; ++i) {
            char c = text[i];
            if (c == '\r') continue;
            if (pos != i) {
                text[pos] = c;
            }
            ++pos;
        }
        return new String(text, 0, pos - 1);
    }

    public static boolean changeAttribute(Element root, List<ElementAttrInfo> elementPath, String attrName, String attrValue) throws DOMException {
        if (elementPath == null) {
            return false;
        }
        Iterator<ElementAttrInfo> it = elementPath.iterator();
        Element element = root;
        String keyAttributeName = null;
        NodeList lastNodeList = null;
        int elementIndex = -1;
        while (it.hasNext()) {
            elementIndex = -1;
            ElementAttrInfo info = it.next();
            String attributeName = info.getAttributeName();
            String attributeValue = info.getAttributeValue();
            NodeList nodeList = element.getElementsByTagName(info.getElementName());
            if (nodeList.getLength() == 0) {
                return false;
            }
            lastNodeList = nodeList;
            Element newElement = null;
            if (attributeName == null) {
                newElement = (Element)nodeList.item(0);
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element el = (Element)nodeList.item(i);
                    String value = el.getAttribute(attributeName);
                    if (value == null || !value.equals(attributeValue)) continue;
                    newElement = el;
                    keyAttributeName = attributeName;
                    elementIndex = i;
                    break;
                }
            }
            if (newElement == null) {
                return false;
            }
            element = newElement;
        }
        if (attrValue == null) {
            element.removeAttribute(attrName);
        } else {
            if (attrName != null && elementIndex >= 0 && attrName.equals(keyAttributeName)) {
                for (int i = 0; i < lastNodeList.getLength(); ++i) {
                    Element el;
                    if (elementIndex == i || !(el = (Element)lastNodeList.item(i)).getAttribute(attrName).equals(attrValue)) continue;
                    XMLJ2eeUtils.showDialog(element.getNodeName(), attrName, attrValue);
                    return false;
                }
            }
            element.setAttribute(attrName, attrValue);
        }
        return true;
    }

    public static boolean changeAttribute(Element root, List<ElementAttrInfo> elementPath, String elementName, int index, String attrName, String attrValue) throws DOMException {
        if (elementPath.isEmpty()) {
            return false;
        }
        Iterator<ElementAttrInfo> it = elementPath.iterator();
        Element element = root;
        NodeList lastNodeList = null;
        int elementIndex = -1;
        while (it.hasNext()) {
            elementIndex = -1;
            ElementAttrInfo info = it.next();
            String attributeName = info.getAttributeName();
            String attributeValue = info.getAttributeValue();
            NodeList nodeList = element.getElementsByTagName(info.getElementName());
            if (nodeList.getLength() == 0) {
                return false;
            }
            lastNodeList = nodeList;
            Element newElement = null;
            if (attributeName == null) {
                newElement = (Element)nodeList.item(0);
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element el = (Element)nodeList.item(i);
                    String value = el.getAttribute(attributeName);
                    if (value == null || !value.equals(attributeValue)) continue;
                    newElement = el;
                    elementIndex = i;
                    break;
                }
            }
            if (newElement == null) {
                return false;
            }
            element = newElement;
        }
        NodeList nodeList = element.getElementsByTagName(elementName);
        element = (Element)nodeList.item(index);
        if (attrValue == null) {
            element.removeAttribute(attrName);
        } else {
            element.setAttribute(attrName, attrValue);
        }
        return true;
    }

    public static boolean deleteElement(Element root, List<ElementAttrInfo> elementPath) throws DOMException {
        Node next;
        if (elementPath.isEmpty()) {
            return false;
        }
        Iterator<ElementAttrInfo> it = elementPath.iterator();
        Node parent = null;
        Element element = root;
        while (it.hasNext()) {
            ElementAttrInfo info = it.next();
            String attributeName = info.getAttributeName();
            String attributeValue = info.getAttributeValue();
            NodeList nodeList = element.getElementsByTagName(info.getElementName());
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element newElement = null;
            if (attributeName == null) {
                newElement = (Element)nodeList.item(0);
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element el = (Element)nodeList.item(i);
                    String name = el.getAttribute(attributeName);
                    if (name == null || !name.equals(attributeValue)) continue;
                    newElement = el;
                    break;
                }
            }
            if (newElement == null) {
                return false;
            }
            parent = element;
            element = newElement;
        }
        Node previous = element.getPreviousSibling();
        boolean firstElement = false;
        if (previous == null) {
            firstElement = true;
        } else if (previous instanceof CharacterData) {
            if (previous.getPreviousSibling() == null) {
                firstElement = true;
            }
            parent.removeChild(previous);
        }
        if (firstElement && (next = element.getNextSibling()) != null && next instanceof CharacterData && next.getNextSibling() == null) {
            parent.removeChild(next);
        }
        parent.removeChild(element);
        return true;
    }

    public static boolean addElement(Element root, List<ElementAttrInfo> elementPath, String elementName, String keyAttribute, String[] attrNames, String[] attrValues) {
        String newKeyValue;
        NodeList nodeList;
        Iterator<ElementAttrInfo> it = elementPath.iterator();
        Element element = root;
        while (it.hasNext()) {
            ElementAttrInfo info = it.next();
            String attributeName = info.getAttributeName();
            String attributeValue = info.getAttributeValue();
            nodeList = element.getElementsByTagName(info.getElementName());
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element newElement = null;
            if (attributeName == null) {
                newElement = (Element)nodeList.item(0);
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element el = (Element)nodeList.item(i);
                    String name = el.getAttribute(attributeName);
                    if (name == null || !name.equals(attributeValue)) continue;
                    newElement = el;
                    break;
                }
            }
            if (newElement == null) {
                return false;
            }
            element = newElement;
        }
        Document doc = root.getOwnerDocument();
        Element newElement = doc.createElement(elementName);
        for (int i = 0; i < attrNames.length; ++i) {
            newElement.setAttribute(attrNames[i], attrValues[i]);
        }
        if (keyAttribute != null && (newKeyValue = newElement.getAttribute(keyAttribute)) != null && (nodeList = element.getElementsByTagName(elementName)) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!newKeyValue.equals(((Element)nodeList.item(i)).getAttribute(keyAttribute))) continue;
                XMLJ2eeUtils.showDialog(elementName, keyAttribute, newKeyValue);
                return false;
            }
        }
        if (!element.hasChildNodes()) {
            element.appendChild(doc.createTextNode(XMLJ2eeUtils.getIndentBefore(elementPath.size())));
            element.appendChild(newElement);
            element.appendChild(doc.createTextNode(XMLJ2eeUtils.getIndentAfter(elementPath.size())));
        } else {
            NodeList list = element.getElementsByTagName(elementName);
            if (list.getLength() == 0) {
                Node lastChild = element.getLastChild();
                if (lastChild instanceof CharacterData) {
                    element.appendChild(doc.createTextNode("  "));
                    element.appendChild(newElement);
                    element.appendChild(lastChild.cloneNode(false));
                } else {
                    element.appendChild(newElement);
                }
            } else {
                Node lastInList = list.item(list.getLength() - 1);
                Node previous = lastInList.getPreviousSibling();
                Node next = lastInList.getNextSibling();
                if (next != null) {
                    if (previous != null && previous instanceof CharacterData) {
                        element.insertBefore(previous.cloneNode(false), next);
                    }
                    element.insertBefore(newElement, next);
                } else {
                    if (previous != null && previous instanceof CharacterData) {
                        element.appendChild(previous.cloneNode(false));
                    }
                    element.appendChild(newElement);
                }
            }
        }
        return true;
    }

    public static boolean addStringElement(Element root, List<ElementAttrInfo> elementPath, String elementName, String elementValue) {
        Iterator<ElementAttrInfo> it = elementPath.iterator();
        Element element = root;
        while (it.hasNext()) {
            ElementAttrInfo info = it.next();
            String attributeName = info.getAttributeName();
            String attributeValue = info.getAttributeValue();
            NodeList nodeList = element.getElementsByTagName(info.getElementName());
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element newElement = null;
            if (attributeName == null) {
                newElement = (Element)nodeList.item(0);
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element el = (Element)nodeList.item(i);
                    String name = el.getAttribute(attributeName);
                    if (name == null || !name.equals(attributeValue)) continue;
                    newElement = el;
                    break;
                }
            }
            if (newElement == null) {
                return false;
            }
            element = newElement;
        }
        Document doc = root.getOwnerDocument();
        Element newElement = doc.createElement(elementName);
        newElement.appendChild(doc.createTextNode(elementValue));
        if (!element.hasChildNodes()) {
            element.appendChild(doc.createTextNode(XMLJ2eeUtils.getIndentBefore(elementPath.size())));
            element.appendChild(newElement);
            element.appendChild(doc.createTextNode(XMLJ2eeUtils.getIndentAfter(elementPath.size())));
        } else {
            NodeList list = element.getElementsByTagName(elementName);
            if (list.getLength() == 0) {
                Node lastChild = element.getLastChild();
                if (lastChild instanceof CharacterData) {
                    element.appendChild(doc.createTextNode("  "));
                    element.appendChild(newElement);
                    element.appendChild(lastChild.cloneNode(false));
                } else {
                    element.appendChild(newElement);
                }
            } else {
                Node lastInList = list.item(list.getLength() - 1);
                Node previous = lastInList.getPreviousSibling();
                Node next = lastInList.getNextSibling();
                if (next != null) {
                    if (previous != null && previous instanceof CharacterData) {
                        element.insertBefore(previous.cloneNode(false), next);
                    }
                    element.insertBefore(newElement, next);
                } else {
                    if (previous != null && previous instanceof CharacterData) {
                        element.appendChild(previous.cloneNode(false));
                    }
                    element.appendChild(newElement);
                }
            }
        }
        return true;
    }

    public static boolean deleteAllElements(Element root, List<ElementAttrInfo> elementPath, String elementName) throws DOMException {
        Node next;
        if (elementPath.isEmpty()) {
            return false;
        }
        Iterator<ElementAttrInfo> it = elementPath.iterator();
        Element parent = null;
        Element element = root;
        while (it.hasNext()) {
            ElementAttrInfo info = it.next();
            String attributeName = info.getAttributeName();
            String attributeValue = info.getAttributeValue();
            NodeList nodeList = element.getElementsByTagName(info.getElementName());
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element newElement = null;
            if (attributeName == null) {
                newElement = (Element)nodeList.item(0);
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element el = (Element)nodeList.item(i);
                    String name = el.getAttribute(attributeName);
                    if (name == null || !name.equals(attributeValue)) continue;
                    newElement = el;
                    break;
                }
            }
            if (newElement == null) {
                return false;
            }
            parent = element;
            element = newElement;
        }
        NodeList list = element.getElementsByTagName(elementName);
        if (list.getLength() == 0) {
            return false;
        }
        Node beforeFirst = list.item(0).getPreviousSibling();
        boolean firstElement = false;
        if (beforeFirst == null) {
            firstElement = true;
        } else if (beforeFirst instanceof CharacterData && beforeFirst.getPreviousSibling() == null) {
            firstElement = true;
        }
        if (firstElement && (next = list.item(list.getLength() - 1).getNextSibling()) != null && next instanceof CharacterData && next.getNextSibling() == null) {
            element.removeChild(next);
        }
        for (int i = list.getLength() - 1; i >= 0; --i) {
            Node item = list.item(i);
            Node previous = item.getPreviousSibling();
            if (previous != null && previous instanceof CharacterData) {
                element.removeChild(previous);
            }
            element.removeChild(item);
        }
        return true;
    }

    private static void showDialog(String elementName, String attrName, String attrValue) {
        String mes = NbBundle.getMessage(XMLJ2eeUtils.class, (String)"TXT_elementExists", (Object[])new Object[]{elementName, attrName, attrValue});
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)mes);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private static String getIndentBefore(int level) {
        StringBuffer sb = new StringBuffer("\n");
        for (int i = 0; i <= level; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    private static String getIndentAfter(int level) {
        StringBuffer sb = new StringBuffer("\n");
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

