/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.RelationshipHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.CmpRelationshipsForm;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Utilities;

public class CmpRelationshipsDialogHelper {
    private static final String CLASS_COLLECTION = "java.util.Collection";
    private static final String CLASS_SET = "java.util.Set";
    private static final String[] FILED_TYPE_ITEMS = new String[]{"java.util.Collection", "java.util.Set"};
    private final EjbJarMultiViewDataObject dataObject;
    private final EjbJar ejbJar;
    private JTextField relationshipNameTextField;
    private JTextArea descriptionTextArea;
    private Vector entityNames;
    private RelationshipDialogActionListener listener;
    FormRoleHelper roleA = new FormRoleHelper();
    FormRoleHelper roleB = new FormRoleHelper();

    public CmpRelationshipsDialogHelper(EjbJarMultiViewDataObject dataObject, EjbJar ejbJar) {
        this.dataObject = dataObject;
        this.ejbJar = ejbJar;
    }

    public boolean showCmpRelationshipsDialog(String title, EjbRelation relation) {
        RelationshipHelper helper;
        CmpRelationshipsForm form = this.initForm();
        JLabel errorLabel = form.getErrorLabel();
        if (relation != null) {
            helper = new RelationshipHelper(relation);
            this.populateFormFields(helper);
        } else {
            helper = null;
        }
        this.listener.validate();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)form, title);
        dialogDescriptor.setOptionType(2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setFocusTraversalPolicy(form.createFocusTraversalPolicy());
        DialogListener dialogListener = new DialogListener(errorLabel, dialogDescriptor);
        form.getFieldNameTextField().getDocument().addDocumentListener(dialogListener);
        form.getFieldNameTextField2().getDocument().addDocumentListener(dialogListener);
        form.getCreateCmrFieldCheckBox().addActionListener(dialogListener);
        form.getCreateCmrFieldCheckBox2().addActionListener(dialogListener);
        form.getRoleNameTextField().getDocument().addDocumentListener(dialogListener);
        form.getRoleNameTextField2().getDocument().addDocumentListener(dialogListener);
        form.getEjbComboBox().addActionListener(dialogListener);
        form.getEjbComboBox2().addActionListener(dialogListener);
        dialogListener.validateFields();
        if (this.dataObject.getEjbJar().getEnterpriseBeans().getEntity().length == 0) {
            dialogDescriptor.setValid(false);
        }
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            if (helper == null) {
                Relationships relationships = this.ejbJar.getSingleRelationships();
                if (relationships == null) {
                    relationships = this.ejbJar.newRelationships();
                    this.ejbJar.setRelationships(relationships);
                }
                helper = new RelationshipHelper(relationships);
            }
            this.processResult(helper);
            return true;
        }
        return false;
    }

    private Vector getEntities() {
        Vector<String> entityNames = new Vector<String>();
        Entity[] entities = this.ejbJar.getEnterpriseBeans().getEntity();
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            if (entity.getLocal() == null) continue;
            entityNames.add(entity.getEjbName());
        }
        return entityNames;
    }

    private void processResult(RelationshipHelper helper) {
        String relationName = this.relationshipNameTextField.getText().trim();
        if (relationName.length() == 0) {
            relationName = this.roleA.getEjbName() + "-" + this.roleB.getEjbName();
        }
        helper.setRelationName(relationName);
        helper.setDescription(this.descriptionTextArea.getText().trim());
        this.roleA.processResult(helper.roleA);
        this.roleB.processResult(helper.roleB);
    }

    private void populateFormFields(RelationshipHelper helper) {
        this.relationshipNameTextField.setText(helper.getRelationName());
        this.descriptionTextArea.setText(helper.getDescription());
        this.roleA.populateFormFields(helper.roleA);
        this.roleB.populateFormFields(helper.roleB);
    }

    private Entity getEntity(String entityName) {
        if (entityName == null) {
            return null;
        }
        Entity[] entities = this.ejbJar.getEnterpriseBeans().getEntity();
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            if (!entityName.equals(entity.getEjbName())) continue;
            return entity;
        }
        return null;
    }

    private CmpRelationshipsForm initForm() {
        this.listener = new RelationshipDialogActionListener();
        this.entityNames = this.getEntities();
        CmpRelationshipsForm form = new CmpRelationshipsForm();
        this.relationshipNameTextField = form.getRelationshipNameTextField();
        this.descriptionTextArea = form.getDescriptionTextArea();
        this.roleA.roleNameTextField = form.getRoleNameTextField();
        this.roleA.ejbComboBox = form.getEjbComboBox();
        this.roleA.multiplicityManyRadioButton = form.getMultiplicityManyRadioButton();
        this.roleA.multiplicityOneRadioButton = form.getMultiplicityOneRadioButton();
        this.roleA.cascadeDeleteCheckBox = form.getCascadeDeleteCheckBox();
        this.roleA.createCmrFieldCheckBox = form.getCreateCmrFieldCheckBox();
        this.roleA.fieldNameTextField = form.getFieldNameTextField();
        this.roleA.fieldTypeComboBox = form.getFieldTypeComboBox();
        this.roleA.init();
        this.roleB.roleNameTextField = form.getRoleNameTextField2();
        this.roleB.ejbComboBox = form.getEjbComboBox2();
        this.roleB.multiplicityManyRadioButton = form.getMultiplicityManyRadioButton2();
        this.roleB.multiplicityOneRadioButton = form.getMultiplicityOneRadioButton2();
        this.roleB.cascadeDeleteCheckBox = form.getCascadeDeleteCheckBox2();
        this.roleB.createCmrFieldCheckBox = form.getCreateCmrFieldCheckBox2();
        this.roleB.fieldNameTextField = form.getFieldNameTextField2();
        this.roleB.fieldTypeComboBox = form.getFieldTypeComboBox2();
        this.roleB.init();
        return form;
    }

    private class DialogListener
    implements DocumentListener,
    ActionListener {
        private final JLabel errorLabel;
        private final DialogDescriptor dialogDescriptor;

        public DialogListener(JLabel errorLabel, DialogDescriptor dialogDescriptor) {
            this.errorLabel = errorLabel;
            this.dialogDescriptor = dialogDescriptor;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validateFields();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validateFields();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validateFields();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.validateFields();
        }

        private boolean isCmrFieldSpecified() {
            boolean a = CmpRelationshipsDialogHelper.this.roleA.createCmrFieldCheckBox.isSelected() && !CmpRelationshipsDialogHelper.this.roleA.fieldNameTextField.getText().trim().equals("");
            boolean b = CmpRelationshipsDialogHelper.this.roleB.createCmrFieldCheckBox.isSelected() && !CmpRelationshipsDialogHelper.this.roleB.fieldNameTextField.getText().trim().equals("");
            return a || b;
        }

        private void validateFields() {
            String roleNameA = CmpRelationshipsDialogHelper.this.roleA.getRoleName();
            String roleNameB = CmpRelationshipsDialogHelper.this.roleB.getRoleName();
            if (roleNameA != null && roleNameA.equals(roleNameB)) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_SameRoleNames"));
                this.dialogDescriptor.setValid(false);
            } else if (!this.isCmrFieldSpecified()) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_NoCmrDefined"));
                this.dialogDescriptor.setValid(false);
            } else if (CmpRelationshipsDialogHelper.this.ejbJar.getEnterpriseBeans().getEntity() == null || CmpRelationshipsDialogHelper.this.ejbJar.getEnterpriseBeans().getEntity().length == 0) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_NoEntitiesFound"));
                this.dialogDescriptor.setValid(false);
            } else if (this.isEmpty(CmpRelationshipsDialogHelper.this.roleA.getEjbName()) || this.isEmpty(CmpRelationshipsDialogHelper.this.roleB.getEjbName())) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_NoEJbNameSpecified"));
                this.dialogDescriptor.setValid(false);
            } else {
                String s1 = CmpRelationshipsDialogHelper.this.roleA.validateFieldName();
                if (s1 != null) {
                    this.errorLabel.setText(s1);
                    this.dialogDescriptor.setValid(false);
                } else {
                    String s2 = CmpRelationshipsDialogHelper.this.roleB.validateFieldName();
                    if (s2 != null) {
                        this.errorLabel.setText(s2);
                        this.dialogDescriptor.setValid(false);
                    } else {
                        this.errorLabel.setText(" ");
                        this.dialogDescriptor.setValid(true);
                    }
                }
            }
        }

        private boolean isEmpty(String str) {
            return null == str || "".equals(str.trim());
        }
    }

    private class RelationshipDialogActionListener
    implements ActionListener {
        private RelationshipDialogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.validate();
        }

        public void validate() {
            CmpRelationshipsDialogHelper.this.roleA.setFieldStates(CmpRelationshipsDialogHelper.this.roleB);
            CmpRelationshipsDialogHelper.this.roleB.setFieldStates(CmpRelationshipsDialogHelper.this.roleA);
        }
    }

    private class FormRoleHelper {
        private JTextField roleNameTextField;
        private JComboBox ejbComboBox;
        private JRadioButton multiplicityManyRadioButton;
        private JRadioButton multiplicityOneRadioButton;
        private JCheckBox cascadeDeleteCheckBox;
        private JCheckBox createCmrFieldCheckBox;
        private JTextField fieldNameTextField;
        private JComboBox fieldTypeComboBox;
        private String origEjbName;
        private String origFieldName;
        private String origFieldType;
        protected boolean origGetter;
        protected boolean origSetter;
        private String lastFieldName;
        private String lastFieldType = "java.util.Collection";
        private boolean createCmrFieldChanged = true;

        private FormRoleHelper() {
        }

        private void init() {
            this.ejbComboBox.setModel(new DefaultComboBoxModel(CmpRelationshipsDialogHelper.this.entityNames));
            this.fieldTypeComboBox.setModel(new DefaultComboBoxModel<String>(FILED_TYPE_ITEMS));
            this.multiplicityOneRadioButton.addActionListener(CmpRelationshipsDialogHelper.this.listener);
            this.multiplicityManyRadioButton.addActionListener(CmpRelationshipsDialogHelper.this.listener);
            this.createCmrFieldCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FormRoleHelper.this.createCmrFieldChanged = true;
                    CmpRelationshipsDialogHelper.this.listener.validate();
                }
            });
        }

        private void processResult(RelationshipHelper.RelationshipRoleHelper helper) {
            String ejbName = this.getEjbName();
            String roleName = this.getRoleName();
            helper.setEjbName(ejbName);
            helper.setRoleName(roleName);
            helper.setMultiple(this.isMultiple());
            helper.setCascadeDelete(this.isCascadeDelete());
            if (this.isCreateCmrField()) {
                String fieldName = this.getFieldName();
                String fieldType = this.getFieldType();
                helper.setCmrField(fieldName, fieldType);
            } else {
                Object fieldName = null;
                Object fieldType = null;
                helper.setCmrField(null);
            }
        }

        private boolean equal(String s1, String s2) {
            return s1 == null ? s2 == null : s1.equals(s2);
        }

        private boolean isCascadeDelete() {
            return this.cascadeDeleteCheckBox.isSelected();
        }

        private void setCascadeDelete(boolean cascadeDelete) {
            this.cascadeDeleteCheckBox.setSelected(cascadeDelete);
        }

        private boolean isMultiple() {
            return this.multiplicityManyRadioButton.isSelected();
        }

        private void setMultiple(boolean multiple) {
            if (multiple) {
                this.multiplicityManyRadioButton.setSelected(true);
            } else {
                this.multiplicityOneRadioButton.setSelected(true);
            }
        }

        private boolean isCreateCmrField() {
            return this.createCmrFieldCheckBox.isSelected();
        }

        private String getFieldType() {
            return (String)this.fieldTypeComboBox.getSelectedItem();
        }

        private void setFieldType(String fieldType) {
            if (fieldType != null) {
                this.lastFieldType = fieldType;
            }
            this.fieldTypeComboBox.setSelectedItem(fieldType);
        }

        private String getRoleName() {
            String roleName = this.roleNameTextField.getText().trim();
            return roleName.length() == 0 ? null : roleName;
        }

        private void setRoleName(String roleName) {
            this.roleNameTextField.setText(roleName);
        }

        private String getEjbName() {
            return (String)this.ejbComboBox.getSelectedItem();
        }

        private void setEjbName(String ejbName) {
            this.ejbComboBox.setSelectedItem(ejbName);
        }

        private void populateFormFields(RelationshipHelper.RelationshipRoleHelper helper) {
            this.setRoleName(helper.getRoleName());
            this.origEjbName = helper.getEjbName();
            this.setEjbName(this.origEjbName);
            this.setMultiple(helper.isMultiple());
            this.setCascadeDelete(helper.isCascadeDelete());
            CmrField field = helper.getCmrField();
            if (field == null) {
                this.origFieldName = null;
                this.origFieldType = null;
                this.setCreateCmrField(false);
                this.setFieldName(null);
                this.setFieldType(null);
            } else {
                this.origFieldName = field.getCmrFieldName();
                this.origFieldType = field.getCmrFieldType();
                this.setCreateCmrField(true);
                this.setFieldName(this.origFieldName);
                this.setFieldType(this.origFieldType);
            }
        }

        private void setCreateCmrField(boolean selected) {
            this.createCmrFieldCheckBox.setSelected(selected);
        }

        public String getFieldName() {
            return this.fieldNameTextField.getText().trim();
        }

        private void setFieldName(String fieldName) {
            if (fieldName != null && fieldName.length() > 0) {
                this.lastFieldName = fieldName;
            }
            this.fieldNameTextField.setText(fieldName);
        }

        public void setFieldStates(FormRoleHelper opositeRole) {
            boolean createCmrField = this.isCreateCmrField();
            String fieldName = this.getFieldName();
            if (this.createCmrFieldChanged) {
                this.createCmrFieldChanged = false;
                if (createCmrField) {
                    if (fieldName.length() == 0) {
                        this.setFieldName(this.lastFieldName);
                    }
                    this.fieldNameTextField.setEnabled(true);
                } else {
                    if (fieldName.length() > 0) {
                        this.lastFieldName = fieldName;
                    }
                    this.setFieldName(null);
                    this.fieldNameTextField.setEnabled(false);
                }
            }
            boolean opositeMultiple = opositeRole.isMultiple();
            String fieldType = this.getFieldType();
            if (createCmrField && opositeMultiple) {
                if (fieldType == null) {
                    this.setFieldType(this.lastFieldType);
                }
                this.fieldTypeComboBox.setEnabled(true);
            } else {
                if (fieldType != null) {
                    this.lastFieldType = fieldType;
                }
                this.setFieldType(null);
                this.fieldTypeComboBox.setEnabled(false);
            }
        }

        private String validateFieldName() {
            String fieldName;
            if (this.isCreateCmrField() && !Utilities.isJavaIdentifier((String)(fieldName = this.getFieldName()))) {
                return Utils.getBundleMessage("MSG_InvalidFieldName");
            }
            return null;
        }
    }
}

