/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.hudson.php.options.HudsonOptions;
import org.netbeans.modules.hudson.php.options.HudsonOptionsValidator;
import org.netbeans.modules.hudson.php.ui.options.Bundle;
import org.netbeans.modules.hudson.php.ui.options.HudsonOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class HudsonOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String OPTIONS_SUBPATH = "Hudson";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private HudsonOptionsPanel hudsonOptionsPanel = null;
    private volatile boolean changed = false;

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/Hudson";
    }

    public void update() {
        this.hudsonOptionsPanel.setBuildXml(this.getOptions().getBuildXml());
        this.hudsonOptionsPanel.setJobConfig(this.getOptions().getJobConfig());
        this.hudsonOptionsPanel.setPhpUnitConfig(this.getOptions().getPhpUnitConfig());
        this.changed = false;
    }

    public void applyChanges() {
        this.getOptions().setBuildXml(this.hudsonOptionsPanel.getBuildXml());
        this.getOptions().setJobConfig(this.hudsonOptionsPanel.getJobConfig());
        this.getOptions().setPhpUnitConfig(this.hudsonOptionsPanel.getPhpUnitConfig());
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        String warning = HudsonOptionsValidator.validate(this.hudsonOptionsPanel.getBuildXml(), this.hudsonOptionsPanel.getJobConfig(), this.hudsonOptionsPanel.getPhpUnitConfig());
        if (warning != null) {
            this.hudsonOptionsPanel.setWarning(warning);
            return true;
        }
        this.hudsonOptionsPanel.setWarning(Bundle.HudsonOptionsPanelController_warning_existingFiles());
        return true;
    }

    public boolean isChanged() {
        String saved = this.getOptions().getBuildXml();
        String current = this.hudsonOptionsPanel.getBuildXml().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getOptions().getJobConfig();
        current = this.hudsonOptionsPanel.getJobConfig().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getOptions().getPhpUnitConfig();
        current = this.hudsonOptionsPanel.getPhpUnitConfig().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.hudsonOptionsPanel == null) {
            this.hudsonOptionsPanel = new HudsonOptionsPanel();
            this.hudsonOptionsPanel.addChangeListener(this);
        }
        return this.hudsonOptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.hudson.php.ui.options.Options");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private HudsonOptions getOptions() {
        return HudsonOptions.getInstance();
    }
}

