/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.threads.TaskQueue;
import org.netbeans.modules.httpserver.AccessFilter;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.netbeans.modules.httpserver.WrapperServlet;
import org.openide.modules.ModuleInstall;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public class HttpServerModule
extends ModuleInstall
implements Externalizable {
    private static final Logger LOG = Logger.getLogger(HttpServerModule.class.getName());
    private static final String SERVLET_MAPPER = "ServletMapper";
    private static final String WRAPPER_SERVLET = "WrapperServlet";
    private static final String ACCESS_FILTER = "AccessFilter";
    private static ContextReloader reloader;
    private static Tomcat tomcat;
    private static boolean inSetRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            HttpServerModule.stopHTTPServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initHTTPServer() {
        if (inSetRunning) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            block22: {
                if (inSetRunning) {
                    return;
                }
                inSetRunning = true;
                try {
                    if (tomcat != null && !HttpServerSettings.running) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (tomcat != null && !HttpServerSettings.running) {
                            try {
                                tomcat.stop();
                                tomcat.destroy();
                            }
                            catch (LifecycleException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            tomcat = null;
                        }
                    }
                    if (tomcat != null) break block22;
                    try {
                        HttpServerModule.buildServer();
                        tomcat.start();
                        HttpServerModule.httpserverSettings().runSuccess();
                        reloader.activate();
                    }
                    catch (Exception e) {
                        if (tomcat != null) {
                            try {
                                tomcat.stop();
                                tomcat.destroy();
                            }
                            catch (LifecycleException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            tomcat = null;
                        }
                        inSetRunning = false;
                        Logger.getLogger("global").log(Level.INFO, null, e);
                        HttpServerModule.httpserverSettings().runFailure(e);
                    }
                    finally {
                        HttpServerModule.httpserverSettings().setStartStopMessages(true);
                    }
                }
                finally {
                    inSetRunning = false;
                }
            }
        }
    }

    public void uninstalled() {
        HttpServerModule.stopHTTPServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopHTTPServer() {
        if (inSetRunning) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            block12: {
                if (inSetRunning) {
                    return;
                }
                inSetRunning = true;
                try {
                    if (reloader != null) {
                        reloader.deactivate();
                        reloader = null;
                    }
                    if (tomcat == null) break block12;
                    try {
                        tomcat.stop();
                        tomcat.destroy();
                    }
                    catch (RuntimeException | LifecycleException throwable) {
                        // empty catch block
                    }
                    tomcat = null;
                    if (HttpServerModule.httpserverSettings().isStartStopMessages()) {
                        LOG.log(Level.INFO, "Internal HTTP server stopped");
                    }
                }
                finally {
                    inSetRunning = false;
                }
            }
        }
    }

    private static void buildServer() throws Exception {
        tomcat = new Tomcat();
        tomcat.setPort(HttpServerModule.httpserverSettings().getPort());
        tomcat.getServer().setUtilityThreads(1);
        tomcat.getConnector().setXpoweredBy(false);
        tomcat.getConnector().setEncodedSolidusHandling("PASSTHROUGH");
        TaskQueue tq = new TaskQueue(10);
        ThreadPoolExecutor tf = new ThreadPoolExecutor(0, 3, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)tq);
        tomcat.getConnector().getProtocolHandler().setExecutor((Executor)tf);
        File wd = Places.getCacheSubdirectory((String)"httpwork");
        Context ctx = tomcat.addContext("", wd.getAbsolutePath());
        if (ctx instanceof StandardContext) {
            ((StandardContext)ctx).setClearReferencesRmiTargets(false);
        }
        ctx.setResources((WebResourceRoot)new StandardRoot(){

            protected void registerURLStreamHandlerFactory() {
            }
        });
        ctx.setSessionTimeout(30);
        HttpServerModule.initContext(ctx);
        reloader = new ContextReloader(tomcat, ctx);
    }

    private static void initContext(final Context ctx) {
        ctx.setParentClassLoader((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
        for (String mapping : ctx.findServletMappings()) {
            ctx.removeServletMapping(mapping);
        }
        for (Container container : Arrays.asList(ctx.findChildren())) {
            ctx.removeChild(container);
        }
        for (FilterMap fm : ctx.findFilterMaps()) {
            ctx.removeFilterMap(fm);
        }
        for (FilterDef fd : ctx.findFilterDefs()) {
            ctx.removeFilterDef(fd);
        }
        FilterDef filterDef = new FilterDef();
        filterDef.setFilter((Filter)new AccessFilter());
        filterDef.setFilterName(ACCESS_FILTER);
        FilterMap filterMap = new FilterMap();
        filterMap.addURLPattern("/*");
        filterMap.setFilterName(ACCESS_FILTER);
        ctx.addFilterDef(filterDef);
        ctx.addFilterMap(filterMap);
        Wrapper sw = ctx.createWrapper();
        sw.setServlet((Servlet)new WrapperServlet());
        sw.setName(WRAPPER_SERVLET);
        ctx.addChild((Container)sw);
        ctx.addServletMappingDecoded(HttpServerModule.httpserverSettings().getWrapperBaseURL() + "*", WRAPPER_SERVLET);
        sw = ctx.createWrapper();
        sw.setServlet((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                String className = HttpServerModule.classFromPath(request);
                LOG.log(Level.FINE, "Servlet class name: {0}", className);
                if (className != null) {
                    try {
                        Class<?> clazz = Class.forName(className, true, ctx.getParentClassLoader());
                        Tomcat.addServlet((Context)ctx, (String)className, (Servlet)((Servlet)clazz.getConstructor(new Class[0]).newInstance(new Object[0])));
                        ctx.addServletMappingDecoded("/servlet/" + className + "/*", className);
                        request.getRequestDispatcher(request.getRequestURI()).forward((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                }
            }
        });
        sw.setName(SERVLET_MAPPER);
        ctx.addChild((Container)sw);
        ctx.addServletMappingDecoded("/servlet/*", SERVLET_MAPPER);
    }

    private static String classFromPath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        int startPos = pathInfo.startsWith("/") ? 1 : 0;
        int endPos = pathInfo.indexOf("/", startPos);
        if (endPos < 0) {
            endPos = pathInfo.length();
        }
        String className = pathInfo.substring(startPos, endPos);
        return className;
    }

    static HttpServerSettings httpserverSettings() {
        return HttpServerSettings.getDefault();
    }

    static {
        inSetRunning = false;
    }

    private static class ContextReloader
    implements LookupListener,
    Runnable {
        private final Context ctx;
        private Lookup.Result<ClassLoader> res;

        public ContextReloader(Tomcat tc, Context ctx) {
            this.ctx = ctx;
        }

        public void activate() {
            this.res = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
            this.res.addLookupListener((LookupListener)this);
        }

        public void deactivate() {
            if (this.res != null) {
                this.res.removeLookupListener((LookupListener)this);
                this.res = null;
            }
        }

        public void resultChanged(LookupEvent evt) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            HttpServerModule.initContext(this.ctx);
        }
    }
}

