/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.api.Snapshot;

public class Utils {
    private static final int URL_CONNECTION_TIMEOUT = 1000;
    private static final int URL_READ_TIMEOUT = 3000;

    public static OffsetRange getValidDocumentOffsetRange(int efrom, int eto, Snapshot snapshot) {
        if (efrom == -1 || eto == -1) {
            throw new IllegalArgumentException(String.format("bad range: %s - %s", efrom, eto));
        }
        int dfrom = snapshot.getOriginalOffset(efrom);
        int dto = snapshot.getOriginalOffset(eto);
        if (dfrom == -1 || dto == -1) {
            return null;
        }
        if (dfrom > dto) {
            return null;
        }
        return new OffsetRange(dfrom, dto);
    }

    public static String hexColorCode(Color c) {
        return Integer.toHexString(c.getRGB()).substring(2);
    }

    public static String getContentAsString(URL url, Charset charset) throws IOException {
        StringWriter writer = new StringWriter();
        Utils.loadURL(url, writer, charset);
        return writer.getBuffer().toString();
    }

    public static void loadURL(URL url, Writer writer, Charset charset) throws IOException {
        int read;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        URLConnection con = url.openConnection();
        con.setConnectTimeout(1000);
        con.setReadTimeout(3000);
        con.connect();
        InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(con.getInputStream()), charset);
        char[] buf = new char[2048];
        while ((read = r.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        ((Reader)r).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            int read;
            char[] buf = new char[2048];
            while ((read = r.read(buf)) != -1) {
                sb.append(buf, 0, read);
            }
        }
        return sb.toString();
    }

    public static String cutQueryFromTemplateUrl(String url) {
        int index = url.indexOf(63);
        return index > 0 ? url.substring(0, index) : url;
    }
}

