/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PersistenceScopesProviderImpl
implements PersistenceScopesProvider,
PropertyChangeListener {
    private PersistenceScopesHelper scopesHelper = null;
    private PersistenceScopeProvider scopeProvider = null;
    private final AtomicBoolean checked = new AtomicBoolean();

    public PersistenceScopesProviderImpl(PersistenceScopeProvider provider) {
        this.scopesHelper = new PersistenceScopesHelper();
        this.scopeProvider = provider;
    }

    public PersistenceScopes getPersistenceScopes() {
        if (this.checked.compareAndSet(false, true)) {
            this.checkScope();
        }
        return this.scopesHelper.getPersistenceScopes();
    }

    private void checkScope() {
        PersistenceScope scope = this.scopeProvider.findPersistenceScope(null);
        if (scope != null) {
            File persistenceXml = FileUtil.toFile((FileObject)scope.getPersistenceXml());
            this.scopesHelper.changePersistenceScope(scope, persistenceXml);
        } else {
            this.scopesHelper.changePersistenceScope(null, null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("GradlePersistence".equals(evt.getPropertyName())) {
            this.checkScope();
        }
    }
}

