/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.api;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.javaee.api.GradleWebProject;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;

final class GradleWebProjectBuilder
implements ProjectInfoExtractor.Result {
    public static final String WEB_PLUGIN = "war";
    final Map<String, Object> info;
    final GradleWebProject prj = new GradleWebProject();

    GradleWebProjectBuilder(Map<String, Object> info) {
        this.info = info;
    }

    GradleWebProjectBuilder build() {
        this.prj.webAppDir = (File)this.info.get("webapp_dir");
        this.prj.webXml = (File)this.info.get("webxml");
        Set classpath = (Set)this.info.get("web_classpath");
        this.prj.mainWar = (File)this.info.get("main_war");
        this.prj.classpath = classpath != null ? Collections.unmodifiableSet(new LinkedHashSet(classpath)) : Collections.emptySet();
        this.prj.explodedWarDir = (File)this.info.get("exploded_war_dir");
        return this;
    }

    public Set getExtract() {
        return Collections.singleton(this.prj);
    }

    public Set<String> getProblems() {
        return Collections.emptySet();
    }

    public static final class Extractor
    implements ProjectInfoExtractor {
        public ProjectInfoExtractor.Result fallback(GradleFiles files) {
            File srcDir = new File(files.getProjectDir(), "src/main/webapp");
            String prjName = files.getProjectDir().getName();
            if (srcDir.exists()) {
                GradleWebProject prj = new GradleWebProject();
                prj.webAppDir = srcDir;
                prj.webXml = new File(srcDir, "WEB-INF/web.xml");
                prj.mainWar = new File(files.getProjectDir(), "build/libs/" + prjName + ".war");
                prj.classpath = Collections.emptySet();
                prj.explodedWarDir = new File(files.getProjectDir(), "build/exploded/" + prjName + ".war");
                return new ProjectInfoExtractor.DefaultResult((Object)prj, new String[0]);
            }
            return ProjectInfoExtractor.Result.NONE;
        }

        public ProjectInfoExtractor.Result extract(Map<String, Object> props, Map<Class, Object> otherInfo) {
            GradleBaseProject gp = (GradleBaseProject)otherInfo.get(GradleBaseProject.class);
            assert (gp != null) : "GradleProject should have been evaluated first, check the position of this extractor!";
            if (gp.getPlugins().contains(GradleWebProjectBuilder.WEB_PLUGIN)) {
                return new GradleWebProjectBuilder(props).build();
            }
            return ProjectInfoExtractor.Result.NONE;
        }
    }
}

