/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.htmlui;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.templates.FileBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.MapFormat;

public final class GradleArchetype {
    private final FileObject templates;
    private final FileObject projectFo;
    private final Map<String, Object> params;

    public GradleArchetype(FileObject templates, FileObject projectFo, Map<String, Object> params) {
        this.templates = templates;
        this.projectFo = projectFo;
        this.params = params;
    }

    public final void copyTemplates() throws IOException {
        MapFormat mf = new MapFormat(this.params);
        mf.setLeftBrace("${");
        mf.setRightBrace("}");
        Enumeration en = this.templates.getChildren(true);
        while (en.hasMoreElements()) {
            FileObject destinationFolder;
            FileObject previous;
            FileObject template = (FileObject)en.nextElement();
            if (!template.isData()) continue;
            String relativeParent = FileUtil.getRelativePath((FileObject)this.templates, (FileObject)template.getParent());
            Object packageAttr = template.getAttribute("package");
            if (packageAttr instanceof String) {
                String packageName = mf.format(packageAttr).replace('.', '/');
                relativeParent = relativeParent + "/" + packageName;
            }
            if ((previous = (destinationFolder = FileUtil.createFolder((FileObject)this.projectFo, (String)relativeParent)).getFileObject(template.getNameExt())) != null) {
                previous.delete();
            }
            FileBuilder fb = new FileBuilder(template, destinationFolder);
            fb.withParameters(this.params);
            fb.defaultMode(FileBuilder.Mode.COPY);
            FileObject copied = (FileObject)fb.build().iterator().next();
            assert (copied != null && copied.getNameExt().equals(template.getNameExt())) : "Created " + copied;
        }
        ProjectManager.getDefault().clearNonProjectCache();
        assert (ProjectManager.getDefault().findProject(this.projectFo) != null) : "Project found for " + this.projectFo;
    }
}

