/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.parser;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.glassfish.common.parser.TreeParser;
import org.netbeans.modules.glassfish.common.utils.Util;
import org.netbeans.modules.glassfish.spi.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JvmConfigReader
extends TreeParser.NodeReader {
    private static final String SERVER_NAME = "server";
    private final Map<String, String> argMap;
    private final Map<String, String> varMap;
    private final Map<String, String> propMap;
    private final List<String> optList;
    private String serverConfigName;
    private boolean readJvmConfig = false;
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public JvmConfigReader(List<String> optList, Map<String, String> argMap, Map<String, String> varMap, Map<String, String> propMap) {
        this.optList = optList;
        this.argMap = argMap;
        this.varMap = varMap;
        this.propMap = propMap;
    }

    public TreeParser.NodeReader getServerFinder() {
        return new TreeParser.NodeReader(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if ((JvmConfigReader.this.serverConfigName == null || JvmConfigReader.this.serverConfigName.length() == 0) && JvmConfigReader.SERVER_NAME.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.serverConfigName = attributes.getValue("config-ref");
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: Server profile defined by " + JvmConfigReader.this.serverConfigName);
                }
            }
        };
    }

    public TreeParser.NodeReader getConfigFinder() {
        return new TreeParser.NodeReader(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.serverConfigName != null && JvmConfigReader.this.serverConfigName.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.readJvmConfig = true;
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: Reading JVM options from server profile " + JvmConfigReader.this.serverConfigName);
                }
            }

            @Override
            public void endNode(String qname) throws SAXException {
                JvmConfigReader.this.readJvmConfig = false;
            }
        };
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        if (this.readJvmConfig) {
            int attrLen = attributes.getLength();
            for (int i = 0; i < attrLen; ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                this.propMap.put(name, value);
            }
        }
    }

    @Override
    public void readCData(String qname, char[] ch, int start, int length) throws SAXException {
        if (this.readJvmConfig) {
            String option = new String(ch, start, length);
            if (option.startsWith("-D")) {
                int splitIndex = option.indexOf(61);
                if (splitIndex != -1) {
                    String name = option.substring(2, splitIndex);
                    String value = this.doSub(option.substring(splitIndex + 1));
                    if (name.length() > 0) {
                        Logger.getLogger("glassfish").finer("DOMAIN.XML: argument name = " + name + ", value = " + value);
                        this.argMap.put(name, value);
                    }
                }
            } else if (option.startsWith("-X")) {
                int splitIndex = (option = this.doSub(option)).indexOf(61);
                if (splitIndex != -1) {
                    String name = option.substring(0, splitIndex);
                    String value = option.substring(splitIndex + 1);
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + name + " = " + value);
                    this.optList.add(name + '=' + Util.quote(value));
                } else {
                    Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + option);
                    this.optList.add(option);
                }
            } else if (option.startsWith("-")) {
                Logger.getLogger("glassfish").finer("DOMAIN.XML: jvm option: " + option);
                this.optList.add(option);
            }
        }
    }

    private String doSub(String value) {
        try {
            Matcher matcher = this.pattern.matcher(value);
            boolean result = matcher.find();
            if (result) {
                StringBuffer sb = new StringBuffer(value.length() * 2);
                do {
                    String key;
                    String replacement;
                    if ((replacement = this.varMap.get(key = matcher.group(1))) == null) {
                        replacement = System.getProperty(key);
                        replacement = replacement != null ? Utils.escapePath(replacement) : "\\$\\{" + key + "\\}";
                    }
                    matcher.appendReplacement(sb, replacement);
                } while (result = matcher.find());
                matcher.appendTail(sb);
                value = sb.toString();
            }
        }
        catch (Exception ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        return value;
    }

    public TreeParser.NodeReader getMonitoringFinder(final File btraceJar) {
        return new TreeParser.NodeReader(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.readJvmConfig && !"false".equals(attributes.getValue("monitoring-enabled"))) {
                    JvmConfigReader.this.optList.add("-javaagent:" + Util.quote(btraceJar.getAbsolutePath()) + "=unsafe=true,noServer=true");
                }
            }
        };
    }
}

