/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.docker.HttpUtils;

public class ChunkedInputStream
extends FilterInputStream {
    private boolean started;
    private boolean finished;
    private int remaining;

    public ChunkedInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        int current = this.fetchData();
        if (current < 0) {
            return -1;
        }
        --this.remaining;
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int current = this.fetchData();
        if (current < 0) {
            return -1;
        }
        int count = 0;
        int limit = off + Math.min(len, this.remaining);
        for (int i = off; i < limit; ++i) {
            int value = this.in.read();
            if (value < 0) {
                return count;
            }
            ++count;
            b[i] = (byte)value;
        }
        this.remaining -= count;
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.remaining;
    }

    private int fetchData() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (this.remaining == 0) {
            String line;
            if (this.started) {
                line = HttpUtils.readResponseLine(this.in);
                if (!line.isEmpty()) {
                    throw new IOException("Chunk content has additional data: " + line);
                }
            } else {
                this.started = true;
            }
            if ((line = HttpUtils.readResponseLine(this.in)) == null) {
                this.finished = true;
                return -1;
            }
            int semicolon = line.indexOf(59);
            if (semicolon > 0) {
                line = line.substring(0, semicolon);
            }
            try {
                this.remaining = Integer.parseInt(line, 16);
                if (this.remaining == 0) {
                    line = HttpUtils.readResponseLine(this.in);
                    if (!line.isEmpty()) {
                        throw new IOException("End of chunk stream contains additional data: " + line);
                    }
                    this.finished = true;
                    return -1;
                }
            }
            catch (NumberFormatException ex) {
                throw new IOException("Wrong chunk size");
            }
        }
        return this.remaining;
    }
}

