/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.terminal.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.dlight.api.terminal.TerminalSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.terminal.api.ui.TerminalContainer;
import org.netbeans.modules.terminal.support.TerminalPinSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.windows.IOContainer;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TerminalContainerTopComponent
extends TopComponent {
    public static final String LOCAL_TERMINAL_PREFIX = "LocalTerminal";
    public static final String SILENT_MODE_COMMAND = "silent_mode";
    private static TerminalContainerTopComponent instance;
    private static final String ICON_PATH = "org/netbeans/modules/dlight/terminal/ui/term.png";
    private static final String PREFERRED_ID = "TerminalContainerTopComponent";
    public static final String AUTO_OPEN_LOCAL_PROPERTY = "AutoOpenLocalTerminal";
    private final TerminalContainer tc;
    private JToolBar actionsBar;
    private static Action[] actions;

    public TerminalContainerTopComponent() {
        this.initComponents();
        this.initToolbar();
        this.fillToolBar();
        String title = NbBundle.getMessage(TerminalContainerTopComponent.class, (String)"CTL_TerminalContainerTopComponent");
        this.setName(title);
        this.setToolTipText(NbBundle.getMessage(TerminalContainerTopComponent.class, (String)"HINT_TerminalContainerTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.tc = TerminalContainer.create((TopComponent)this, (String)title);
        this.add((Component)this.tc);
    }

    public IOContainer getIOContainer() {
        return this.tc.ioContainer();
    }

    private void initComponents() {
        this.actionsBar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.actionsBar.setFloatable(false);
        this.actionsBar.setOrientation(1);
        this.actionsBar.setRollover(true);
        this.actionsBar.setFocusable(false);
        this.add(this.actionsBar, "Before");
    }

    public static synchronized TerminalContainerTopComponent getDefault() {
        if (instance == null) {
            instance = new TerminalContainerTopComponent();
        }
        return instance;
    }

    private static synchronized Action[] getToolbarActions() {
        if (actions == null) {
            List termActions = Utilities.actionsForPath((String)"Terminal/Actions");
            actions = termActions.toArray(new Action[0]);
        }
        return actions;
    }

    public static synchronized TerminalContainerTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(TerminalContainerTopComponent.class.getName()).warning("Cannot find TerminalContainerTopComponent component. It will not be located properly in the window system.");
            return TerminalContainerTopComponent.getDefault();
        }
        if (win instanceof TerminalContainerTopComponent) {
            return (TerminalContainerTopComponent)win;
        }
        Logger.getLogger(TerminalContainerTopComponent.class.getName()).warning("There seem to be multiple components with the 'TerminalContainerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TerminalContainerTopComponent.getDefault();
    }

    public TopComponent.SubComponent[] getSubComponents() {
        ArrayList terminalList = new ArrayList();
        terminalList.addAll(this.tc.getAllTabs());
        if (terminalList.size() <= 1) {
            return super.getSubComponents();
        }
        TopComponent.SubComponent[] subs = new TopComponent.SubComponent[terminalList.size()];
        for (int i = 0; i < terminalList.size(); ++i) {
            final Component terminal = (Component)terminalList.get(i);
            String title = terminal.getName();
            subs[i] = new TopComponent.SubComponent(title, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (terminal instanceof JComponent) {
                        TerminalContainerTopComponent.this.tc.ioContainer().select((JComponent)terminal);
                        TerminalContainerTopComponent.this.requestActive();
                    }
                }
            }, terminal == this.tc.ioContainer().getSelected());
        }
        return subs;
    }

    public int getPersistenceType() {
        return 0;
    }

    public void requestActive() {
        super.requestActive();
        this.tc.requestFocusInWindow();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.tc.componentActivated();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.tc.componentDeactivated();
    }

    public void componentOpened() {
        TerminalPinSupport support = TerminalPinSupport.getDefault();
        List readStoredDetails = support.readStoredDetails();
        for (TerminalPinSupport.TerminalDetails details : readStoredDetails) {
            TerminalPinSupport.TerminalCreationDetails creationDetails = details.getCreationDetails();
            TerminalPinSupport.TerminalPinningDetails pinningDetails = details.getPinningDetails();
            ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)creationDetails.getExecEnv());
            String cwd = pinningDetails.getCwd();
            if (cwd.isEmpty()) {
                cwd = null;
            }
            TerminalSupport.restoreTerminal(pinningDetails.getTitle(), env, cwd, creationDetails.isPwdFlag(), creationDetails.getId());
        }
        JComponent selectedTerminal = this.getIOContainer().getSelected();
        if (selectedTerminal == null && this.getClientProperty(AUTO_OPEN_LOCAL_PROPERTY) != Boolean.FALSE) {
            for (Action action : TerminalContainerTopComponent.getToolbarActions()) {
                if (!action.getValue("Name").toString().startsWith(LOCAL_TERMINAL_PREFIX) || !action.isEnabled()) continue;
                action.actionPerformed(new ActionEvent((Object)this, 1001, SILENT_MODE_COMMAND));
                break;
            }
        }
    }

    public void componentClosed() {
        JComponent selected = this.getIOContainer().getSelected();
        while (selected != null) {
            this.getIOContainer().remove(selected);
            selected = this.getIOContainer().getSelected();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void addPanel(JComponent panel) {
    }

    private void fillToolBar() {
        this.actionsBar.removeAll();
        for (Action action : TerminalContainerTopComponent.getToolbarActions()) {
            if (!(action instanceof Presenter.Toolbar)) continue;
            this.actionsBar.add(((Presenter.Toolbar)action).getToolbarPresenter());
        }
        this.actionsBar.revalidate();
        this.actionsBar.repaint();
    }

    private void initToolbar() {
        Insets ins = this.actionsBar.getMargin();
        JButton dummy = new JButton();
        dummy.setBorderPainted(false);
        dummy.setOpaque(false);
        dummy.setText(null);
        dummy.setIcon(new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        });
        this.actionsBar.add(dummy);
        Dimension buttonPref = dummy.getPreferredSize();
        Dimension minDim = new Dimension(buttonPref.width + ins.left + ins.right, buttonPref.height + ins.top + ins.bottom);
        this.actionsBar.setMinimumSize(minDim);
        this.actionsBar.setPreferredSize(minDim);
        this.actionsBar.remove(dummy);
        this.actionsBar.setBorder(new RightBorder());
        this.actionsBar.setBorderPainted(true);
    }

    private static final class RightBorder
    implements Border {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color old = g.getColor();
            g.setColor(this.getColor());
            g.drawLine(x + width - 1, y, x + width - 1, y + height);
            g.setColor(old);
        }

        public Color getColor() {
            if (Utilities.isMac()) {
                Color c1 = UIManager.getColor("controlShadow");
                Color c2 = UIManager.getColor("control");
                return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
            }
            return UIManager.getColor("controlShadow");
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 2);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

