/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class UnbufferSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final boolean UNBUFFER_DISABLED = Boolean.getBoolean("execution.no_unbuffer");
    private static final HashMap<ExecutionEnvironment, String> cache = new HashMap();

    private UnbufferSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initUnbuffer(ExecutionEnvironment execEnv, MacroMap env) throws IOException {
        HostInfo hinfo;
        if (UNBUFFER_DISABLED) {
            return;
        }
        try {
            hinfo = HostInfoUtils.getHostInfo(execEnv);
        }
        catch (ConnectionManager.CancellationException ex) {
            return;
        }
        boolean isWindows = false;
        switch (hinfo.getOSFamily()) {
            case MACOSX: 
            case FREEBSD: {
                return;
            }
            case LINUX: {
                if (hinfo.getCpuFamily().equals((Object)HostInfo.CpuFamily.X86) || hinfo.getCpuFamily().equals((Object)HostInfo.CpuFamily.SPARC) || hinfo.getCpuFamily().equals((Object)HostInfo.CpuFamily.AARCH64)) break;
                return;
            }
            case WINDOWS: {
                isWindows = true;
            }
        }
        MacroExpanderFactory.MacroExpander macroExpander = MacroExpanderFactory.getExpander(execEnv);
        String unbufferPath = null;
        String unbufferPath_64 = null;
        String unbufferLib = null;
        try {
            unbufferPath = macroExpander.expandPredefinedMacros("bin/nativeexecution/$osname-$platform" + (isWindows ? "${_isa}" : ""));
            unbufferPath_64 = macroExpander.expandPredefinedMacros("bin/nativeexecution/$osname-$platform${_isa}");
            unbufferLib = macroExpander.expandPredefinedMacros("unbuffer.$soext");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (unbufferLib != null && unbufferPath != null) {
            InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
            File file = fl.locate(unbufferPath + "/" + unbufferLib, "org.netbeans.modules.dlight.nativeexecution", false);
            File file_64 = fl.locate(unbufferPath_64 + "/" + unbufferLib, "org.netbeans.modules.dlight.nativeexecution", false);
            log.log(Level.FINE, "Look for unbuffer library here: {0}/{1}", new Object[]{unbufferPath, unbufferLib});
            log.log(Level.FINE, "Look for unbuffer library here: {0}/{1}", new Object[]{unbufferPath_64, unbufferLib});
            if (file != null && file.exists() || file_64 != null && file_64.exists()) {
                String ldPreloadEnv;
                String ldLibraryPathEnv;
                if (execEnv.isRemote()) {
                    Object remotePath = null;
                    HashMap<ExecutionEnvironment, String> hashMap = cache;
                    synchronized (hashMap) {
                        remotePath = cache.get(execEnv);
                        if (remotePath == null) {
                            remotePath = hinfo.getTempDir() + "/" + unbufferPath;
                            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
                            npb.setExecutable("/bin/mkdir").setArguments(new String[]{"-p", remotePath, (String)remotePath + "_64"});
                            ProcessUtils.execute(npb);
                            try {
                                Future<CommonTasksSupport.UploadStatus> copyTask;
                                String remoteLib_32 = (String)remotePath + "/" + unbufferLib;
                                String remoteLib_64 = (String)remotePath + "_64/" + unbufferLib;
                                if (file != null && file.exists()) {
                                    String fullLocalPath = file.getParentFile().getAbsolutePath();
                                    copyTask = CommonTasksSupport.uploadFile(fullLocalPath + "/" + unbufferLib, execEnv, remoteLib_32, 493, true);
                                    copyTask.get();
                                }
                                if (file_64 != null && file_64.exists()) {
                                    String fullLocalPath_64 = file_64.getParentFile().getAbsolutePath();
                                    copyTask = CommonTasksSupport.uploadFile(fullLocalPath_64 + "/" + unbufferLib, execEnv, remoteLib_64, 493, true);
                                    copyTask.get();
                                }
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (ExecutionException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            cache.put(execEnv, (String)remotePath);
                        }
                    }
                    unbufferPath = remotePath;
                } else {
                    unbufferPath = file != null ? new File(file.getParent()).getAbsolutePath() : new File(file_64.getParent()).getAbsolutePath();
                }
                if (isWindows) {
                    ldLibraryPathEnv = "PATH";
                    ldPreloadEnv = "LD_PRELOAD";
                } else {
                    ldLibraryPathEnv = "LD_LIBRARY_PATH";
                    ldPreloadEnv = "LD_PRELOAD";
                }
                Object ldPreload = env.get(ldPreloadEnv);
                if (isWindows) {
                    ldPreload = (String)(ldPreload == null ? "" : (String)ldPreload + ";") + new File(unbufferPath, unbufferLib).getAbsolutePath();
                    ldPreload = WindowsSupport.getInstance().convertToAllShellPaths((String)ldPreload);
                    if (ldPreload == null) {
                        return;
                    }
                } else {
                    ldPreload = (String)(ldPreload == null ? "" : (String)ldPreload + ":") + unbufferLib;
                }
                env.put(ldPreloadEnv, (String)ldPreload);
                if (!isWindows) {
                    Object ldLibPath = env.get(ldLibraryPathEnv);
                    ldLibPath = (String)(ldLibPath == null ? "" : (String)ldLibPath + ":") + unbufferPath + ":" + unbufferPath + "_64";
                    env.put(ldLibraryPathEnv, (String)ldLibPath);
                }
            }
        }
    }
}

