/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.ExternalTerminalAccessor;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class TerminalLocalNativeProcess
extends AbstractNativeProcess {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final File dorunScript;
    private ExternalTerminal terminal;
    private File resultFile;
    private final HostInfo.OSFamily osFamily;

    public TerminalLocalNativeProcess(NativeProcessInfo info, ExternalTerminal terminal) {
        super(info);
        this.terminal = terminal;
        this.setInputStream(new ByteArrayInputStream((TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.ProcessStarted.text", new String[0]) + "\n").getBytes()));
        this.osFamily = this.hostInfo == null ? HostInfo.OSFamily.UNKNOWN : this.hostInfo.getOSFamily();
    }

    @Override
    protected void create() throws Throwable {
        File pidFileFile = null;
        File shFileFile = null;
        try {
            if (dorunScript == null) {
                throw new IOException(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.dorunNotFound.text", new String[0]));
            }
            if (this.osFamily == HostInfo.OSFamily.WINDOWS && this.hostInfo.getShell() == null) {
                throw new IOException(TerminalLocalNativeProcess.loc("NativeProcess.shellNotFound.text", new String[0]));
            }
            String commandLine = this.info.getCommandLineForShell();
            String wDir = this.info.getWorkingDirectory(true);
            File workingDirectory = wDir == null ? new File(".") : new File(wDir);
            pidFileFile = Files.createTempFile(this.hostInfo.getTempDirFile().toPath(), "dlight", "termexec", new FileAttribute[0]).toFile().getAbsoluteFile();
            shFileFile = new File(pidFileFile.getPath() + ".sh");
            this.resultFile = new File(shFileFile.getPath() + ".res");
            this.resultFile.deleteOnExit();
            String pidFile = this.osFamily == HostInfo.OSFamily.WINDOWS ? WindowsSupport.getInstance().convertToShellPath(pidFileFile.getPath()) : pidFileFile.getPath();
            String shFile = pidFile + ".sh";
            FileOutputStream shfos = new FileOutputStream(shFileFile);
            Charset scriptCharset = this.info.getCharset() != null ? this.info.getCharset() : (this.osFamily == HostInfo.OSFamily.WINDOWS ? WindowsSupport.getInstance().getShellCharset() : Charset.defaultCharset());
            ExternalTerminalAccessor terminalInfo = ExternalTerminalAccessor.getDefault();
            if (terminalInfo.getTitle(this.terminal) == null) {
                String title = this.getExecutableName();
                if (title == null) {
                    title = NbBundle.getMessage(TerminalLocalNativeProcess.class, (String)"TerminalLocalNativeProcess.terminalTitle.text");
                }
                this.terminal = this.terminal.setTitle(title);
            }
            ArrayList<String> terminalArgs = new ArrayList<String>();
            String shellScriptPath = dorunScript.getAbsolutePath();
            if (this.osFamily == HostInfo.OSFamily.WINDOWS) {
                shellScriptPath = WindowsSupport.getInstance().convertToShellPath(shellScriptPath);
            }
            this.terminal = this.terminal.setWorkdir(workingDirectory.toString());
            terminalArgs.addAll(Arrays.asList(shellScriptPath, "-p", terminalInfo.getPrompt(this.terminal), "-x", shFile));
            List<String> command = terminalInfo.wrapCommand(this.info.getExecutionEnvironment(), this.terminal, terminalArgs);
            ProcessBuilder pb = new ProcessBuilder(command);
            if (!workingDirectory.exists()) {
                throw new FileNotFoundException(TerminalLocalNativeProcess.loc("NativeProcess.noSuchDirectoryError.text", workingDirectory.getAbsolutePath()));
            }
            pb.directory(workingDirectory);
            pb.redirectErrorStream(true);
            LOG.log(Level.FINEST, "External terminal command: {0}", command);
            MacroMap env = this.info.getEnvironment().clone();
            if (this.osFamily == HostInfo.OSFamily.MACOSX) {
                ProcessBuilder pb1 = new ProcessBuilder(this.hostInfo.getShell(), "-c", "/bin/echo $DISPLAY");
                ProcessUtils.ExitStatus res = ProcessUtils.execute(pb1);
                String display = null;
                if (res.isOK()) {
                    display = res.getOutputString();
                }
                if (display == null || "".equals(display)) {
                    display = ":0.0";
                }
                pb.environment().put("DISPLAY", display);
            }
            OutputStreamWriter shWriter = new OutputStreamWriter((OutputStream)shfos, scriptCharset);
            shWriter.write("echo $$ > \"" + pidFile + "\" || exit $?\n");
            if (!env.isEmpty()) {
                if (this.osFamily == HostInfo.OSFamily.WINDOWS) {
                    String path = env.get("PATH");
                    env.remove("PATH");
                    env.put("PATH", WindowsSupport.getInstance().convertToAllShellPaths(path));
                }
                EnvWriter ew = new EnvWriter(shWriter);
                ew.write(env);
                if (LOG.isLoggable(Level.FINEST)) {
                    env.dump(System.err);
                }
            }
            shWriter.write("exec " + commandLine + "\n");
            shWriter.close();
            Process terminalProcess = ProcessUtils.ignoreProcessOutputAndError(pb.start());
            this.creation_ts = System.nanoTime();
            this.waitPID(terminalProcess, pidFileFile);
            if (this.isInterrupted()) {
                throw new IOException(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.terminalRunCancelled.text", new String[0]));
            }
        }
        catch (Throwable ex) {
            this.resultFile = null;
            throw ex;
        }
        finally {
            if (pidFileFile != null) {
                pidFileFile.delete();
            }
            if (shFileFile != null) {
                shFileFile.delete();
            }
        }
    }

    private int getPIDNoException() {
        int pid = -1;
        try {
            pid = this.getPID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitResult() throws InterruptedException {
        int pid = this.getPIDNoException();
        if (pid < 0) {
            return -1;
        }
        if (this.osFamily == HostInfo.OSFamily.LINUX || this.osFamily == HostInfo.OSFamily.SUNOS) {
            File f = new File("/proc/" + pid);
            while (f.exists()) {
                Thread.sleep(300L);
            }
        } else {
            int rc = 0;
            while (rc == 0) {
                try {
                    rc = CommonTasksSupport.sendSignal(this.info.getExecutionEnvironment(), pid, Signal.NULL, null).get();
                }
                catch (ExecutionException ex) {
                    log.log(Level.FINEST, "", ex);
                    rc = -1;
                }
                Thread.sleep(300L);
            }
        }
        if (this.resultFile == null) {
            return -1;
        }
        int exitCode = -1;
        BufferedReader statusReader = null;
        try {
            int attempts = 10;
            while (attempts-- > 0) {
                if (this.resultFile.exists() && this.resultFile.length() > 0L) {
                    statusReader = new BufferedReader(new FileReader(this.resultFile));
                    String exitCodeString = statusReader.readLine();
                    if (exitCodeString != null) {
                        exitCode = Integer.parseInt(exitCodeString.trim());
                    }
                    break;
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedIOException ex) {
            throw new InterruptedException();
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            if (statusReader != null) {
                try {
                    statusReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPID(Process termProcess, File pidFile) throws IOException {
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
            if (pidFile.exists() && pidFile.length() > 0L) {
                try (FileInputStream pidIS = null;){
                    pidIS = new FileInputStream(pidFile);
                    this.readPID(pidIS);
                    break;
                }
            }
            try {
                int result = termProcess.exitValue();
                if (result != 0) {
                    String err = ProcessUtils.readProcessErrorLine(termProcess);
                    if (!err.isEmpty()) {
                        err = ProcessUtils.readProcessOutputLine(termProcess);
                    }
                    log.info(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.terminalFailed.text", new String[0]));
                    log.info(err);
                    throw new IOException(err);
                }
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(TerminalLocalNativeProcess.class, (String)key, (Object[])params);
    }

    private String getExecutableName() {
        String[] params;
        String exec = this.info.getExecutable();
        if (exec != null) {
            if (new File(exec).exists()) {
                return new File(exec).getName();
            }
            if (this.osFamily == HostInfo.OSFamily.WINDOWS && new File(exec + ".exe").exists()) {
                return new File(exec).getName();
            }
        }
        if ((params = Utilities.parseParameters((String)this.info.getCommandLineForShell())) != null && params.length > 0 && (exec = params[0]) != null && new File(exec).exists()) {
            return new File(exec).getName();
        }
        return null;
    }

    static {
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        File dorunScriptFile = fl.locate("bin/nativeexecution/dorun.sh", "org.netbeans.modules.dlight.nativeexecution", false);
        if (dorunScriptFile == null) {
            log.severe("Unable to locate bin/nativeexecution/dorun.sh file!");
        } else if (!Utilities.isWindows()) {
            CommonTasksSupport.chmod(ExecutionEnvironmentFactory.getLocal(), dorunScriptFile.getAbsolutePath(), 493, null);
        }
        dorunScript = dorunScriptFile;
    }
}

