/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import com.jcraft.jsch.JSchException;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.JschSupport;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.UnbufferSupport;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.openide.util.Exceptions;

public final class RemoteNativeProcess
extends AbstractNativeProcess {
    private static final int startupErrorExitValue = 184;
    private JschSupport.ChannelStreams streams = null;

    public RemoteNativeProcess(NativeProcessInfo info) {
        super(info);
    }

    @Override
    protected void create() throws Throwable {
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        String commandLine = this.info.getCommandLineForShell();
        MacroMap envVars = this.info.getEnvironment().clone();
        if (this.info.isUnbuffer()) {
            UnbufferSupport.initUnbuffer(this.info.getExecutionEnvironment(), envVars);
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        JschSupport.ChannelParams params = new JschSupport.ChannelParams();
        params.setX11Forwarding(this.info.getX11Forwarding());
        this.streams = JschSupport.startCommand(this.info.getExecutionEnvironment(), "/bin/sh -s", params);
        this.setErrorStream(this.streams.err);
        this.setInputStream(this.streams.out);
        this.setOutputStream(this.streams.in);
        this.streams.in.write("echo $$\n".getBytes());
        this.streams.in.flush();
        String workingDirectory = this.info.getWorkingDirectory(true);
        if (workingDirectory != null) {
            this.streams.in.write(EnvWriter.getBytes("cd \"" + workingDirectory + "\" || exit 184\n", true));
        }
        EnvWriter ew = new EnvWriter(this.streams.in, true);
        ew.write(envVars);
        if (this.info.getInitialSuspend()) {
            this.streams.in.write("ITS_TIME_TO_START=\n".getBytes());
            this.streams.in.write("trap 'ITS_TIME_TO_START=1' CONT\n".getBytes());
            this.streams.in.write("while [ -z \"$ITS_TIME_TO_START\" ]; do sleep 1; done\n".getBytes());
        }
        if (this.info.isRedirectError()) {
            this.streams.in.write("exec 2>&1\n".getBytes());
        }
        this.streams.in.write(EnvWriter.getBytes("exec " + commandLine + "\n", true));
        this.streams.in.flush();
        this.readPID(this.streams.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitResult() throws InterruptedException {
        if (this.streams == null || this.streams.channel == null) {
            return -1;
        }
        try {
            while (this.streams.channel.isConnected()) {
                Thread.sleep(200L);
            }
            this.finishing();
            int exitValue = this.streams.channel.getExitStatus();
            if (exitValue == 184) {
                exitValue = -1;
            }
            int n = exitValue;
            return n;
        }
        finally {
            if (this.streams != null) {
                try {
                    ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(this.getExecutionEnvironment(), this.streams.channel);
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    @Override
    public boolean isAlive() {
        if (this.streams == null || this.streams.channel == null) {
            return false;
        }
        return this.streams.channel.isConnected();
    }
}

