/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.ShellScriptRunner;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class PathUtils {
    private PathUtils() {
    }

    public static String getPathFromSymlink(String path, ExecutionEnvironment execEnv) {
        int pos;
        String line;
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
        npb.setExecutable("/bin/ls").setArguments("-l", path).redirectError();
        ProcessUtils.ExitStatus res = ProcessUtils.execute(npb);
        List<String> outputLines = res.getOutputLines();
        String string = line = outputLines.isEmpty() ? null : outputLines.get(0);
        if (line != null && (pos = line.indexOf("->")) > 0) {
            return line.substring(pos + 2).trim();
        }
        return null;
    }

    public static String expandPath(String text, ExecutionEnvironment env) throws IOException, ConnectionManager.CancellationException, ParseException {
        HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
        text = MacroExpanderFactory.getExpander(env).expandMacros(text, hostInfo.getEnvironment());
        char fileSeparatorChar = '/';
        if (env.isLocal()) {
            fileSeparatorChar = File.separatorChar;
        }
        if (text.equals("~")) {
            return hostInfo.getUserDir();
        }
        if (text.startsWith("~" + fileSeparatorChar)) {
            return hostInfo.getUserDir() + text.substring(1);
        }
        return text;
    }

    public static String getExePath(long pid, ExecutionEnvironment execEnv) {
        if (pid > 0L) {
            String procdir = "/proc/" + Long.toString(pid);
            String path = PathUtils.getPathFromSymlink(procdir + "/path/a.out", execEnv);
            if (path == null) {
                path = PathUtils.getPathFromSymlink(procdir + "/exe", execEnv);
            }
            if (path != null && path.length() > 0) {
                return path;
            }
            path = PathUtils.getExePath_(pid, execEnv);
            return path;
        }
        return null;
    }

    private static String getExePath_(long pid, ExecutionEnvironment execEnv) {
        return PathUtils.run_("exepath.sh", pid, execEnv);
    }

    private static String getCwdPath_(long pid, ExecutionEnvironment execEnv) {
        return PathUtils.run_("cwdpath.sh", pid, execEnv);
    }

    private static String run_(String scriptName, long pid, ExecutionEnvironment execEnv) {
        try {
            InstalledFileLocator fl = InstalledFileLocator.getDefault();
            File localScript = fl.locate("bin/nativeexecution/" + scriptName, "org.netbeans.modules.nativeexecution", false);
            if (localScript == null) {
                return null;
            }
            ShellScriptRunner.BufferedLineProcessor bufferedLineProcessor = new ShellScriptRunner.BufferedLineProcessor();
            ShellScriptRunner scriptRunner = new ShellScriptRunner(execEnv, Utilities.toURI((File)localScript), (LineProcessor)bufferedLineProcessor);
            scriptRunner.setArguments(pid + "");
            int execute = scriptRunner.execute();
            if (execute != 0) {
                return null;
            }
            return bufferedLineProcessor.getAsString();
        }
        catch (IOException iOException) {
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    public static String getCwdPath(long pid, ExecutionEnvironment execEnv) {
        if (pid > 0L) {
            String procdir = "/proc/" + Long.toString(pid);
            String path = PathUtils.getPathFromSymlink(procdir + "/cwd", execEnv);
            if (path != null && path.length() > 0) {
                return path;
            }
            path = PathUtils.getCwdPath_(pid, execEnv);
            return path;
        }
        return null;
    }
}

