/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.nativeexecution.ui.Completable;
import org.openide.util.NbBundle;

public final class CompletionPopup
extends JPopupMenu
implements KeyListener {
    private final String[] NO_COMPLETION_OPTIONS = new String[]{this.loc("CompletionPopup.NoAutoCompletion", new String[0])};
    private final String[] WAITING_FOR_DATA = new String[]{this.loc("CompletionPopup.Waiting", new String[0])};
    private boolean enabled = false;
    private final Completable completable;
    private final JList list;
    private final Color enabledColor;
    private final Color disabledColor = Color.lightGray;

    public CompletionPopup(Completable completable) {
        this.list = new JList();
        this.enabledColor = this.list.getForeground();
        this.list.setVisibleRowCount(4);
        this.list.setSelectionMode(0);
        this.completable = completable;
        JScrollPane jsp = new JScrollPane(this.list);
        this.add(jsp);
        this.list.setFocusable(false);
        jsp.setFocusable(false);
        this.setFocusable(false);
        this.list.addFocusListener(new FocusHandler());
        this.list.addMouseListener(new MouseHandler());
        this.list.addMouseMotionListener(new MouseHandler());
        completable.addKeyListener(this);
    }

    public void setOptionsList(List<String> options) {
        if (options.isEmpty()) {
            this.list.setListData(this.NO_COMPLETION_OPTIONS);
            this.list.setForeground(this.disabledColor);
            this.enabled = false;
        } else {
            this.list.setListData(options.toArray(new String[0]));
            this.list.setForeground(this.enabledColor);
            this.enabled = true;
        }
    }

    private void setSelectNext() {
        if (this.list.getModel().getSize() > 0 && this.enabled) {
            int cur = (this.list.getSelectedIndex() + 1) % this.list.getModel().getSize();
            this.list.setSelectedIndex(cur);
            this.list.ensureIndexIsVisible(cur);
        }
    }

    private void setSelectPrevious() {
        if (this.list.getModel().getSize() > 0 && this.enabled) {
            int cur = this.list.getSelectedIndex() == -1 ? 0 : this.list.getSelectedIndex();
            cur = cur == 0 ? this.list.getModel().getSize() - 1 : cur - 1;
            this.list.setSelectedIndex(cur);
            this.list.ensureIndexIsVisible(cur);
        }
    }

    public void showPopup(JTextComponent source, int x, int y) {
        this.setPreferredSize(new Dimension(source.getWidth(), source.getHeight() * 4));
        this.show(source, x, y);
        this.list.clearSelection();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.isVisible() || e.isConsumed()) {
            return;
        }
        int code = e.getKeyCode();
        String commonPrefix = null;
        String option = null;
        switch (code) {
            case 40: {
                this.setSelectNext();
                e.consume();
                break;
            }
            case 38: {
                this.setSelectPrevious();
                e.consume();
                break;
            }
            case 27: {
                this.setVisible(false);
                this.completable.requestFocus();
                e.consume();
                break;
            }
            case 10: {
                if (this.enabled && (option = (String)this.list.getSelectedValue()) != null) {
                    boolean leaveVisible = this.completable.completeWith(option);
                    if (!leaveVisible) {
                        this.setVisible(false);
                    }
                    this.completable.requestFocus();
                }
                e.consume();
                break;
            }
            case 9: 
            case 39: {
                if (this.enabled) {
                    option = (String)this.list.getSelectedValue();
                    if (option == null && this.list.getModel().getSize() == 1) {
                        option = (String)this.list.getModel().getElementAt(0);
                    }
                    if (option != null) {
                        boolean leaveVisible = this.completable.completeWith(option);
                        if (!leaveVisible) {
                            this.setVisible(false);
                        }
                        this.completable.requestFocus();
                    } else {
                        commonPrefix = this.getCommonPrefix();
                        if (commonPrefix != null) {
                            this.completable.completeWith(commonPrefix);
                        }
                    }
                }
                if (code != 9) break;
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private String getCommonPrefix() {
        int listSize = this.list.getModel().getSize();
        if (listSize == 0) {
            return null;
        }
        String first = (String)this.list.getModel().getElementAt(0);
        StringBuilder prefix = new StringBuilder(first);
        int prefixLen = first.length();
        for (int i = 1; i < listSize; ++i) {
            if (prefixLen == 0) {
                return null;
            }
            String item = (String)this.list.getModel().getElementAt(i);
            int itemLen = item.length();
            if (itemLen < prefixLen) {
                prefixLen = itemLen;
                prefix.setLength(prefixLen);
            }
            for (int j = 0; j < prefixLen; ++j) {
                if (item.charAt(j) == prefix.charAt(j)) continue;
                prefixLen = j;
                prefix.setLength(prefixLen);
            }
        }
        return prefixLen == 0 ? null : prefix.toString();
    }

    public void setWaiting() {
        this.list.setListData(this.WAITING_FOR_DATA);
        this.list.setForeground(this.disabledColor);
        this.enabled = false;
    }

    private String loc(String message, String ... params) {
        return NbBundle.getMessage(CompletionPopup.class, (String)message, (Object[])params);
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                CompletionPopup.this.setVisible(false);
                CompletionPopup.this.completable.requestFocus();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!CompletionPopup.this.enabled) {
                return;
            }
            if (e.getSource() == CompletionPopup.this.list) {
                Point location = e.getPoint();
                int index = CompletionPopup.this.list.locationToIndex(location);
                Rectangle r = new Rectangle();
                CompletionPopup.this.list.computeVisibleRect(r);
                if (r.contains(location)) {
                    CompletionPopup.this.list.setSelectedIndex(index);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getSource() == CompletionPopup.this.list) {
                return;
            }
            if (CompletionPopup.this.isVisible()) {
                MouseEvent newEvent = this.convertMouseEvent(e);
                Rectangle r = new Rectangle();
                CompletionPopup.this.list.computeVisibleRect(r);
                Point location = newEvent.getPoint();
                int index = CompletionPopup.this.list.locationToIndex(location);
                if (r.contains(location)) {
                    CompletionPopup.this.list.setSelectedIndex(index);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!CompletionPopup.this.enabled) {
                return;
            }
            Point p = e.getPoint();
            int index = CompletionPopup.this.list.locationToIndex(p);
            CompletionPopup.this.list.setSelectedIndex(index);
            CompletionPopup.this.setVisible(false);
            String option = (String)CompletionPopup.this.list.getSelectedValue();
            if (option == null) {
                return;
            }
            CompletionPopup.this.completable.completeWith(option);
            CompletionPopup.this.completable.requestFocus();
        }

        private MouseEvent convertMouseEvent(MouseEvent e) {
            Point convertedPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), CompletionPopup.this.list);
            MouseEvent newEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), convertedPoint.x, convertedPoint.y, e.getClickCount(), e.isPopupTrigger());
            return newEvent;
        }
    }
}

