/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.source;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.js.source.ObservableSet;
import org.netbeans.modules.debugger.jpda.js.vars.DebuggerSupport;
import org.netbeans.modules.javascript2.debug.sources.SourceFilesCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class Source {
    private static final Logger LOG = Logger.getLogger(Source.class.getName());
    private static final String SOURCE_CLASS = "jdk.nashorn.internal.runtime.Source";
    private static final String SOURCE_FIELD = "source";
    private static final String SOURCE_VAR_NAME = "name";
    private static final String SOURCE_VAR_CONTENT = "content";
    private static final String SOURCE_VAR_HASH = "hash";
    private static final String SOURCE_VAR_URL = "url";
    private static final String SOURCE_VAR_DATA = "data";
    private static final String SOURCE_VAR_DATA_ARRAY = "array";
    private static final Map<JPDADebugger, Map<Long, Source>> knownSources = new WeakHashMap<JPDADebugger, Map<Long, Source>>();
    private final String name;
    private final JPDAClassType classType;
    private final ObservableSet<JPDAClassType> functionClassTypes = new ObservableSet();
    private final URL url;
    private final URL runtimeURL;
    private final int contentLineShift;
    private final int hash;
    private final String content;
    private final long sourceVarId;

    private Source(String name, JPDAClassType classType, URL url, boolean compareContent, int hash, String content, long sourceVarId) {
        this.name = name;
        this.classType = classType;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new Source(" + name + ", " + classType.getName() + ", " + url + ")");
        }
        URL rURL = null;
        int lineShift = 0;
        if (url == null || !"file".equalsIgnoreCase(url.getProtocol()) && !"jar".equalsIgnoreCase(url.getProtocol())) {
            url = SourceFilesCache.getDefault().getSourceFile(name, hash, content);
        } else if (compareContent) {
            lineShift = Source.getContentLineShift(url, content);
            if (lineShift > 0) {
                rURL = SourceFilesCache.getDefault().getSourceFile(name, hash, content);
            } else {
                lineShift = 0;
            }
        }
        this.url = url;
        this.runtimeURL = rURL;
        this.contentLineShift = lineShift;
        this.hash = hash;
        this.content = content;
        this.sourceVarId = sourceVarId;
    }

    public long getSourceVarId() {
        return this.sourceVarId;
    }

    public static Source getSource(CallStackFrame frame) {
        JPDAClassType classType;
        if (frame == null) {
            return null;
        }
        try {
            classType = (JPDAClassType)frame.getClass().getMethod("getClassType", new Class[0]).invoke((Object)frame, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        return Source.getSource(classType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Source getSource(JPDAClassType classType) {
        JPDADebugger debugger;
        long uniqueClassID = classType.classObject().getUniqueID();
        try {
            Field debuggerField = classType.getClass().getDeclaredField("debugger");
            debuggerField.setAccessible(true);
            debugger = (JPDADebugger)debuggerField.get(classType);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        Map<JPDADebugger, Map<Long, Source>> ex = knownSources;
        synchronized (ex) {
            Source src;
            Map<Long, Source> dbgSources = knownSources.get(debugger);
            if (dbgSources != null && (src = dbgSources.get(uniqueClassID)) != null) {
                return src;
            }
        }
        ObjectVariable sourceVar = null;
        if (DebuggerSupport.hasSourceInfo(debugger)) {
            sourceVar = (ObjectVariable)DebuggerSupport.getSourceInfo(debugger, classType);
            LOG.log(Level.FINE, "Source info for class {0} is {1}", new Object[]{classType, sourceVar});
        }
        if (sourceVar == null) {
            sourceVar = Source.getSourceVar(debugger, classType);
            LOG.log(Level.FINE, "Source var for class {0} is {1}", new Object[]{classType, sourceVar});
            if (sourceVar == null) {
                return null;
            }
        }
        return Source.getSource(debugger, classType, sourceVar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Source getSource(JPDADebugger debugger, JPDAClassType classType, ObjectVariable sourceVar) {
        File nameFile;
        int nl;
        URL url;
        org.netbeans.api.debugger.jpda.Field fieldData;
        long uniqueClassID = classType.classObject().getUniqueID();
        org.netbeans.api.debugger.jpda.Field fieldName = sourceVar.getField(SOURCE_VAR_NAME);
        org.netbeans.api.debugger.jpda.Field fieldContent = sourceVar.getField(SOURCE_VAR_CONTENT);
        org.netbeans.api.debugger.jpda.Field fieldHash = sourceVar.getField(SOURCE_VAR_HASH);
        org.netbeans.api.debugger.jpda.Field fieldURL = sourceVar.getField(SOURCE_VAR_URL);
        if (fieldContent == null && fieldURL == null && (fieldData = sourceVar.getField(SOURCE_VAR_DATA)) instanceof ObjectVariable) {
            fieldURL = ((ObjectVariable)fieldData).getField(SOURCE_VAR_URL);
            fieldContent = ((ObjectVariable)fieldData).getField(SOURCE_VAR_DATA_ARRAY);
        }
        if (fieldName == null || fieldContent == null || fieldHash == null) {
            return null;
        }
        Object urlObj = fieldURL != null ? fieldURL.createMirrorObject() : null;
        boolean compareContent = false;
        if (urlObj == null && fieldURL != null) {
            url = Source.readURLFromFields(fieldURL);
            compareContent = true;
        } else {
            url = (URL)urlObj;
        }
        Object hashMirror = fieldHash.createMirrorObject();
        if (!(hashMirror instanceof Integer)) {
            return null;
        }
        int hash = (Integer)hashMirror;
        Object contentMirror = fieldContent.createMirrorObject();
        if (!(contentMirror instanceof char[])) {
            return null;
        }
        String content = new String((char[])contentMirror);
        String name = fieldName.getValue();
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if ((nl = name.length()) < 4 || !name.substring(nl - 3, nl).toLowerCase().equals(".js")) {
            name = name + ".js";
        }
        if ((nameFile = new File(name)).isAbsolute() && nameFile.exists()) {
            try {
                url = nameFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Source src = new Source(name, classType, url, compareContent, hash, content, sourceVar.getUniqueID());
        Map<JPDADebugger, Map<Long, Source>> map = knownSources;
        synchronized (map) {
            Map<Long, Source> dbgSources = knownSources.get(debugger);
            if (dbgSources == null) {
                dbgSources = new HashMap<Long, Source>();
                knownSources.put(debugger, dbgSources);
            }
            dbgSources.put(uniqueClassID, src);
        }
        return src;
    }

    private static ObjectVariable getSourceVar(JPDADebugger debugger, JPDAClassType classType) {
        List staticFields = classType.staticFields();
        for (org.netbeans.api.debugger.jpda.Field sf : staticFields) {
            if (!(sf instanceof ObjectVariable) || !SOURCE_FIELD.equals(sf.getName()) || !SOURCE_CLASS.equals(sf.getType())) continue;
            return (ObjectVariable)sf;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public JPDAClassType getClassType() {
        return this.classType;
    }

    public ObservableSet<JPDAClassType> getFunctionClassTypes() {
        return this.functionClassTypes;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getRuntimeURL() {
        return this.runtimeURL;
    }

    public int getContentLineShift() {
        return this.contentLineShift;
    }

    public int getHash() {
        return this.hash;
    }

    public String getContent() {
        return this.content;
    }

    private static URL readURLFromFields(org.netbeans.api.debugger.jpda.Field fieldURL) {
        if (!(fieldURL instanceof ObjectVariable)) {
            return null;
        }
        ObjectVariable urlObj = (ObjectVariable)fieldURL;
        org.netbeans.api.debugger.jpda.Field protocolField = urlObj.getField("protocol");
        org.netbeans.api.debugger.jpda.Field authorityField = urlObj.getField("authority");
        org.netbeans.api.debugger.jpda.Field pathField = urlObj.getField("path");
        if (protocolField == null || authorityField == null || pathField == null) {
            return null;
        }
        String protocol = Source.stripQuotes(protocolField.getValue());
        String authority = Source.stripQuotes(authorityField.getValue());
        String path = Source.stripQuotes(pathField.getValue());
        StringBuilder result = new StringBuilder();
        result.append(protocol);
        result.append(":");
        if (authority != null && authority.length() > 0) {
            result.append("//");
            result.append(authority);
        }
        if (path != null) {
            result.append(path);
        }
        try {
            return new URL(result.toString());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private static String stripQuotes(String str) {
        if ("null".equals(str)) {
            str = null;
        }
        if (str != null && str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    static int getContentLineShift(URL url, String content) {
        String origContent;
        FileObject fo = URLMapper.findFileObject((URL)url);
        if (fo != null) {
            try {
                origContent = fo.asText();
            }
            catch (IOException ex) {
                return 0;
            }
        } else {
            return 0;
        }
        int index = content.indexOf(origContent);
        if (index < 0) {
            return -1;
        }
        String prep = content.substring(0, index);
        return Source.countNewLines(prep);
    }

    private static int countNewLines(String prep) {
        String nl = "\n";
        int c = 0;
        int index = 0;
        while ((index = prep.indexOf(nl, index)) >= 0) {
            ++c;
            ++index;
        }
        return c;
    }

    public void addFunctionClass(ClassVariable rootClass) {
        try {
            this.functionClassTypes.add((JPDAClassType)rootClass.getClass().getMethod("getReflectedType", new Class[0]).invoke((Object)rootClass, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

